/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import javax.management.RuntimeErrorException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.web.data.layer.NewLayerPage;
import org.geoserver.web.data.store.AbstractWMSStorePage;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFinder;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wms.WebMapServer;
import org.geotools.ows.wms.xml.WMSSchema;
import org.xml.sax.EntityResolver;

public class WMSStoreNewPage
extends AbstractWMSStorePage {
    public WMSStoreNewPage() {
        try {
            CatalogBuilder builder = new CatalogBuilder(this.getCatalog());
            WMSStoreInfo store = builder.buildWMSStore(null);
            this.initUI(store);
            GeoServerEnvironment gsEnvironment = (GeoServerEnvironment)GeoServerExtensions.bean(GeoServerEnvironment.class);
            if (gsEnvironment == null || !GeoServerEnvironment.allowEnvParametrization()) {
                this.capabilitiesURL.getFormComponent().add((IValidator)new WMSCapabilitiesURLValidator());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not setup the WMS store: " + e.getMessage(), e);
        }
    }

    @Override
    protected void onSave(WMSStoreInfo info, AjaxRequestTarget target) throws IllegalArgumentException {
        NewLayerPage layerChooserPage;
        WMSStoreInfo expandedStore = this.getCatalog().getResourcePool().clone(info, true);
        WMSStoreInfo savedStore = this.getCatalog().getFactory().createWebMapServer();
        try {
            this.getCatalog().validate((StoreInfo)expandedStore, false).throwIfInvalid();
            savedStore = this.getCatalog().getResourcePool().clone(info, false);
            this.getCatalog().save((StoreInfo)savedStore);
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.INFO, "Adding the store for " + info.getCapabilitiesURL(), e);
            throw new IllegalArgumentException("The WMS store could not be saved. Failure message: " + e.getMessage());
        }
        try {
            layerChooserPage = new NewLayerPage(savedStore.getId());
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.INFO, "Getting list of layers for the WMS store " + info.getCapabilitiesURL(), e);
            try {
                this.getCatalog().remove((StoreInfo)expandedStore);
                this.getCatalog().remove((StoreInfo)savedStore);
            }
            catch (RuntimeErrorException shouldNotHappen) {
                LOGGER.log(Level.WARNING, "Can't remove CoverageStoreInfo after adding it!", e);
            }
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        this.setResponsePage((IRequestablePage)layerChooserPage);
    }

    final class WMSCapabilitiesURLValidator
    implements IValidator<String> {
        WMSCapabilitiesURLValidator() {
        }

        public void validate(IValidatable<String> validatable) {
            String url = (String)validatable.getValue();
            try {
                EntityResolver entityResolver;
                HTTPClient client = HTTPClientFinder.createClient();
                WMSStoreNewPage.this.usernamePanel.getFormComponent().processInput();
                String user = WMSStoreNewPage.this.usernamePanel.getFormComponent().getInput();
                WMSStoreNewPage.this.password.getFormComponent().processInput();
                String pwd = WMSStoreNewPage.this.password.getFormComponent().getInput();
                if (user != null && user.length() > 0 && pwd != null && pwd.length() > 0) {
                    client.setUser(user);
                    client.setPassword(pwd);
                }
                HashMap<String, Object> hints = new HashMap<String, Object>();
                hints.put("org.geotools.xml.handlers.DocumentHandler.DEFAULT_NAMESPACE_HINT_KEY", WMSSchema.getInstance());
                hints.put("DocumentFactory_VALIDATION_HINT", Boolean.FALSE);
                EntityResolverProvider provider = WMSStoreNewPage.this.getCatalog().getResourcePool().getEntityResolverProvider();
                if (provider != null && (entityResolver = provider.getEntityResolver()) != null) {
                    hints.put("org.xml.sax.EntityResolver", entityResolver);
                }
                WebMapServer server = new WebMapServer(new URL(url), client, hints);
                server.getCapabilities();
            }
            catch (IOException | ServiceException e) {
                ValidationError err = new ValidationError("WMSCapabilitiesValidator.connectionFailure").addKey("WMSCapabilitiesValidator.connectionFailure").setVariable("error", (Object)e.getMessage());
                validatable.error((IValidationError)err);
            }
        }
    }
}

