/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.store.ParamInfo;
import org.geotools.data.DataAccessFactory;

public abstract class StoreEditPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    protected final Form storeEditForm;

    protected StoreEditPanel(String componentId, Form storeEditForm) {
        super(componentId);
        boolean isNew;
        this.storeEditForm = storeEditForm;
        StoreInfo info = (StoreInfo)storeEditForm.getModel().getObject();
        boolean bl = isNew = null == info.getId();
        if (isNew && info instanceof DataStoreInfo) {
            this.applyDataStoreParamsDefaults(info);
        }
    }

    protected void applyDataStoreParamsDefaults(StoreInfo info) {
        DataAccessFactory dsFactory;
        DataStoreInfo dsInfo = (DataStoreInfo)info;
        try {
            dsFactory = this.getCatalog().getResourcePool().getDataStoreFactory(dsInfo);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        DataAccessFactory.Param[] dsParams = dsFactory.getParametersInfo();
        Map connParams = info.getConnectionParameters();
        for (DataAccessFactory.Param p : dsParams) {
            ParamInfo paramInfo = new ParamInfo(p);
            if (connParams.containsKey(p.key) && connParams.get(p.key) != null) continue;
            this.applyParamDefault(paramInfo, info);
        }
    }

    protected void applyParamDefault(ParamInfo paramInfo, StoreInfo info) {
        Object defValue = paramInfo.getValue();
        defValue = "namespace".equals(paramInfo.getName()) ? this.getCatalog().getDefaultNamespace().getURI() : (URL.class == paramInfo.getBinding() && null == defValue ? "file:data/example.extension" : paramInfo.getValue());
        info.getConnectionParameters().put(paramInfo.getName(), defValue);
    }

    protected Catalog getCatalog() {
        GeoServerApplication application = (GeoServerApplication)this.getApplication();
        return application.getCatalog();
    }

    public boolean onSave() {
        return true;
    }
}

