/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.data.store.NamespaceParamModel;
import org.geoserver.web.data.store.ParamInfo;
import org.geoserver.web.data.store.StoreEditPanel;
import org.geoserver.web.data.store.panel.CheckBoxParamPanel;
import org.geoserver.web.data.store.panel.DropDownChoiceParamPanel;
import org.geoserver.web.data.store.panel.FileParamPanel;
import org.geoserver.web.data.store.panel.NamespacePanel;
import org.geoserver.web.data.store.panel.ParamPanel;
import org.geoserver.web.data.store.panel.PasswordParamPanel;
import org.geoserver.web.data.store.panel.TextAreaParamPanel;
import org.geoserver.web.data.store.panel.TextParamPanel;
import org.geoserver.web.util.EnumAdapterModel;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.FileExistsValidator;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.Repository;
import org.xml.sax.EntityResolver;

public class DefaultDataStoreEditPanel
extends StoreEditPanel {
    private static final long serialVersionUID = -1969433619372747193L;

    public DefaultDataStoreEditPanel(String componentId, Form storeEditForm) {
        super(componentId, storeEditForm);
        DataAccessFactory.Param[] dsParams;
        DataAccessFactory dsFactory;
        IModel model = storeEditForm.getModel();
        DataStoreInfo info = (DataStoreInfo)model.getObject();
        Catalog catalog = this.getCatalog();
        ResourcePool resourcePool = catalog.getResourcePool();
        try {
            dsFactory = resourcePool.getDataStoreFactory(info);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final LinkedHashMap<String, ParamInfo> paramsMetadata = new LinkedHashMap<String, ParamInfo>();
        boolean isNew = null == info.getId();
        for (DataAccessFactory.Param p : dsParams = dsFactory.getParametersInfo()) {
            ParamInfo paramInfo = new ParamInfo(p);
            if (Repository.class.equals(paramInfo.getBinding()) || EntityResolver.class.equals(paramInfo.getBinding())) continue;
            paramsMetadata.put(p.key, paramInfo);
            if (!isNew || p.isDeprecated().booleanValue()) continue;
            this.applyParamDefault(paramInfo, (StoreInfo)info);
        }
        ArrayList keys = new ArrayList(paramsMetadata.keySet());
        PropertyModel paramsModel = new PropertyModel((Object)model, "connectionParameters");
        ListView<String> paramsList = new ListView<String>("parameters", keys, (IModel)paramsModel){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ IModel val$paramsModel;
            {
                this.val$paramsModel = iModel;
                super(x0, x1);
            }

            protected void populateItem(ListItem<String> item) {
                String paramName = item.getDefaultModelObjectAsString();
                ParamInfo paramMetadata = (ParamInfo)paramsMetadata.get(paramName);
                Panel inputComponent = DefaultDataStoreEditPanel.this.getInputComponent("parameterPanel", (IModel<Map<String, Serializable>>)this.val$paramsModel, paramMetadata);
                String description = paramMetadata.getTitle();
                if (description != null) {
                    inputComponent.add(new Behavior[]{AttributeModifier.replace((String)"title", (Serializable)((Object)description))});
                }
                item.add(new Component[]{inputComponent});
            }
        };
        paramsList.setReuseItems(true);
        this.add(new Component[]{paramsList});
    }

    protected Panel getInputComponent(String componentId, IModel<Map<String, Serializable>> paramsModel, ParamInfo paramMetadata) {
        Panel parameterPanel;
        GeoServerEnvironment gsEnvironment = (GeoServerEnvironment)GeoServerExtensions.bean(GeoServerEnvironment.class);
        String paramName = paramMetadata.getName();
        String paramLabel = paramMetadata.getName();
        boolean required = paramMetadata.isRequired();
        boolean deprecated = paramMetadata.isDeprecated();
        Class<?> binding = paramMetadata.getBinding();
        List<Serializable> options = paramMetadata.getOptions();
        if ("namespace".equals(paramName)) {
            NamespaceParamModel namespaceModel = new NamespaceParamModel(paramsModel, paramName);
            ResourceModel paramLabelModel = new ResourceModel(paramLabel, paramLabel);
            parameterPanel = new NamespacePanel(componentId, namespaceModel, (IModel)paramLabelModel, true);
        } else if (options != null && !options.isEmpty()) {
            MapModel<Serializable> valueModel = new MapModel<Serializable>(paramsModel, paramName);
            if (binding.isEnum()) {
                valueModel = this.adaptEnumeration(binding, valueModel);
            }
            ResourceModel labelModel = new ResourceModel(paramLabel, paramLabel);
            parameterPanel = new DropDownChoiceParamPanel(componentId, valueModel, (IModel<String>)labelModel, options, required);
        } else if (Boolean.class == binding) {
            parameterPanel = new CheckBoxParamPanel(componentId, new MapModel<Boolean>(paramsModel, paramName), (IModel)new ResourceModel(paramLabel, paramLabel));
        } else if (File.class == binding) {
            parameterPanel = new FileParamPanel(componentId, new MapModel<String>(paramsModel, paramName), (IModel<String>)new ResourceModel(paramLabel, paramLabel), required, new IValidator[0]);
        } else if (String.class == binding && paramMetadata.isPassword()) {
            parameterPanel = new PasswordParamPanel(componentId, new MapModel<String>(paramsModel, paramName), (IModel<String>)new ResourceModel(paramLabel, paramLabel), required);
        } else {
            MapModel model = "url".equalsIgnoreCase(paramName) ? new URLModel(paramsModel, paramName) : new MapModel(paramsModel, paramName);
            Panel tp = paramMetadata.isLargeText() ? new TextAreaParamPanel(componentId, model, (IModel<String>)new ResourceModel(paramLabel, paramLabel), required, new IValidator[0]) : new TextParamPanel<String>(componentId, model, (IModel<String>)new ResourceModel(paramLabel, paramLabel), required, new IValidator[0]);
            FormComponent fc = ((ParamPanel)tp).getFormComponent();
            if (paramName.equalsIgnoreCase("url") && (gsEnvironment == null || !GeoServerEnvironment.allowEnvParametrization())) {
                fc.add((IValidator)new FileExistsValidator());
            }
            if (!(gsEnvironment != null && GeoServerEnvironment.allowEnvParametrization() || binding == null || String.class.equals(binding) || File.class.equals(binding) || URL.class.equals(binding) || binding.isArray())) {
                fc.setType(binding);
            }
            parameterPanel = tp;
        }
        Object parameterValue = parameterPanel.getDefaultModelObject();
        boolean visible = (!deprecated || !this.isEmpty(parameterValue)) && !paramMetadata.getLevel().equals("program");
        parameterPanel.setVisible(visible);
        parameterPanel.setVisibilityAllowed(visible);
        return parameterPanel;
    }

    private IModel<Serializable> adaptEnumeration(Class<?> binding, IModel<Serializable> valueModel) {
        return new EnumAdapterModel<Serializable>(valueModel, binding);
    }

    private boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        return false;
    }

    static final class URLModel
    extends MapModel<String> {
        URLModel(IModel<Map<String, Serializable>> model, String expression) {
            super(model, expression);
        }

        @Override
        public void setObject(String file) {
            if (!(file.startsWith("file://") || file.startsWith("file:") || file.startsWith("http://") || file.startsWith("https://"))) {
                file = "file://" + file;
            }
            super.setObject(file);
        }
    }
}

