/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.util.logging.Level;
import javax.management.RuntimeErrorException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.component.IRequestablePage;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.data.layer.NewLayerPage;
import org.geoserver.web.data.store.AbstractCoverageStorePage;
import org.geoserver.web.data.store.CoverageStoreEditPage;

public class CoverageStoreNewPage
extends AbstractCoverageStorePage {
    public CoverageStoreNewPage(String coverageFactoryName) {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo workspace = catalog.getDefaultWorkspace();
        CoverageStoreInfo store = catalog.getFactory().createCoverageStore();
        store.setWorkspace(workspace);
        store.setType(coverageFactoryName);
        store.setEnabled(true);
        store.setURL("file:data/example.extension");
        this.initUI(store);
    }

    @Override
    protected void onSave(CoverageStoreInfo info, AjaxRequestTarget target, boolean doReturn) throws IllegalArgumentException {
        Catalog catalog = this.getCatalog();
        CoverageStoreInfo expandedStore = this.getCatalog().getResourcePool().clone(info, true);
        CoverageStoreInfo savedStore = catalog.getFactory().createCoverageStore();
        try {
            catalog.validate((StoreInfo)expandedStore, false).throwIfInvalid();
            savedStore = catalog.getResourcePool().clone(info, false);
            catalog.save((StoreInfo)savedStore);
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.INFO, "Adding the store for " + info.getURL(), e);
            throw new IllegalArgumentException("The coverage store could not be saved. Failure message: " + e.getMessage());
        }
        this.onSuccessfulSave(info, catalog, savedStore, doReturn);
    }

    protected void onSuccessfulSave(CoverageStoreInfo info, Catalog catalog, CoverageStoreInfo savedStore, boolean doReturn) {
        if (doReturn) {
            NewLayerPage layerChooserPage;
            try {
                catalog.getResourcePool().clone(savedStore, true);
                layerChooserPage = new NewLayerPage(savedStore.getId());
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.INFO, "Getting list of coverages for saved store " + info.getURL(), e);
                try {
                    catalog.remove((StoreInfo)savedStore);
                }
                catch (RuntimeErrorException shouldNotHappen) {
                    LOGGER.log(Level.WARNING, "Can't remove CoverageStoreInfo after adding it!", e);
                }
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            this.setResponsePage((IRequestablePage)layerChooserPage);
        } else {
            this.setResponsePage((IRequestablePage)new CoverageStoreEditPage(savedStore.getId()));
        }
    }
}

