/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.web.data.resource.DimensionEditorBase;
import org.geoserver.web.data.resource.VectorCustomDimensionEntry;

public class VectorCustomDimensionEditor
extends DimensionEditorBase<VectorCustomDimensionEntry> {
    private TextField<String> nameInput;

    public VectorCustomDimensionEditor(String id, IModel<VectorCustomDimensionEntry> model, ResourceInfo resource, Class<?> type, boolean editNearestMatch) {
        super(id, model, resource, type, editNearestMatch, false);
    }

    public VectorCustomDimensionEditor(String id, IModel<VectorCustomDimensionEntry> model, ResourceInfo resource, Class<?> type) {
        super(id, model, resource, type);
    }

    @Override
    protected void initComponents() {
        PropertyModel nameModel = new PropertyModel((Object)this.getModel(), "keyNoPrefixed");
        this.nameInput = new TextField("customDimName", (IModel)nameModel);
        this.add(new Component[]{this.nameInput});
        AjaxSubmitLink removeButton = new AjaxSubmitLink("removeButton"){

            protected void onAfterSubmit(AjaxRequestTarget target, Form<?> form) {
                super.onAfterSubmit(target, form);
                this.send((IEventSink)this.getWebPage(), Broadcast.BREADTH, new RemoveEvent(target, (VectorCustomDimensionEntry)VectorCustomDimensionEditor.this.getModelObject()));
            }
        };
        removeButton.setDefaultFormProcessing(false);
        this.add(new Component[]{removeButton});
    }

    @Override
    protected boolean resetDimensionDataOnDisabled() {
        return false;
    }

    @Override
    protected void convertInputExtensions(VectorCustomDimensionEntry info) {
        super.convertInputExtensions(info);
        this.nameInput.processInput();
        info.setKeyNoPrefixed((String)this.nameInput.getModelObject());
    }

    @Override
    protected VectorCustomDimensionEntry infoOf() {
        return new VectorCustomDimensionEntry();
    }

    @Override
    protected VectorCustomDimensionEntry infoOf(VectorCustomDimensionEntry info) {
        return new VectorCustomDimensionEntry(info);
    }

    @Override
    protected void initializeEndAttributesValues(List<String> endAttributes) {
    }

    public static class RemoveEvent {
        private final AjaxRequestTarget target;
        private final VectorCustomDimensionEntry entry;

        public RemoveEvent(AjaxRequestTarget target, VectorCustomDimensionEntry entry) {
            this.target = target;
            this.entry = entry;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }

        public VectorCustomDimensionEntry getEntry() {
            return this.entry;
        }
    }
}

