/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.data.layer.CoverageViewEditPage;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.data.resource.ResourceConfigurationPanel;
import org.geoserver.web.data.store.panel.CheckBoxParamPanel;
import org.geoserver.web.data.store.panel.ColorPickerPanel;
import org.geoserver.web.data.store.panel.DropDownChoiceParamPanel;
import org.geoserver.web.data.store.panel.TextParamPanel;
import org.geoserver.web.util.MapModel;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;

public class CoverageResourceConfigurationPanel
extends ResourceConfigurationPanel {
    Map<String, DefaultParameterDescriptor> parameterDescriptorMap;

    public CoverageResourceConfigurationPanel(String panelId, final IModel<CoverageInfo> model) {
        super(panelId, model);
        this.initParameterDescriptors();
        CoverageInfo coverage = (CoverageInfo)this.getResourceInfo();
        Map parameters = coverage.getParameters();
        TreeSet<String> keySet = new TreeSet<String>(parameters.keySet());
        this.addMissingParameters(keySet, coverage);
        ArrayList<String> keys = new ArrayList<String>(keySet);
        PropertyModel paramsModel = new PropertyModel(model, "parameters");
        ListView<String> paramsList = new ListView<String>("parameters", keys, (IModel)paramsModel){
            final /* synthetic */ IModel val$paramsModel;
            {
                this.val$paramsModel = iModel;
                super(x0, x1);
            }

            protected void populateItem(ListItem item) {
                Component inputComponent = CoverageResourceConfigurationPanel.this.getInputComponent("parameterPanel", this.val$paramsModel, item.getDefaultModelObjectAsString());
                item.add(new Component[]{inputComponent});
            }
        };
        WebMarkupContainer coverageViewContainer = new WebMarkupContainer("editCoverageViewContainer");
        this.add(new Component[]{coverageViewContainer});
        CoverageView coverageView = (CoverageView)coverage.getMetadata().get(CoverageView.COVERAGE_VIEW, CoverageView.class);
        coverageViewContainer.add(new Component[]{new Link("editCoverageView"){

            public void onClick() {
                CoverageInfo coverageInfo = (CoverageInfo)model.getObject();
                try {
                    CoverageStoreInfo store = coverageInfo.getStore();
                    WorkspaceInfo workspace = store.getWorkspace();
                    this.setResponsePage((IRequestablePage)new CoverageViewEditPage(workspace.getName(), store.getName(), coverageInfo.getName(), coverageInfo, (ResourceConfigurationPage)this.getPage()));
                }
                catch (Exception e) {
                    ResourceConfigurationPanel.LOGGER.log(Level.SEVERE, "Failure opening the Virtual Coverage edit page", e);
                    this.error((Serializable)((Object)e.toString()));
                }
            }
        }});
        coverageViewContainer.setVisible(coverageView != null);
        paramsList.setReuseItems(true);
        this.add(new Component[]{paramsList});
        if (keys.isEmpty()) {
            this.setVisible(false);
        }
    }

    private void addMissingParameters(TreeSet<String> keySet, CoverageInfo coverage) {
        AbstractGridFormat format = coverage.getStore().getFormat();
        ParameterValueGroup readParameters = format.getReadParameters();
        List parameterValues = readParameters.values();
        List paramNames = parameterValues.stream().map(p -> p.getDescriptor()).filter(p -> p instanceof DefaultParameterDescriptor).map(p -> p.getName().getCode()).collect(Collectors.toList());
        keySet.addAll(paramNames);
    }

    private void initParameterDescriptors() {
        try {
            CoverageInfo coverage = (CoverageInfo)this.getResourceInfo();
            AbstractGridFormat format = coverage.getStore().getFormat();
            ParameterValueGroup readParameters = format.getReadParameters();
            List parameterValues = readParameters.values();
            this.parameterDescriptorMap = parameterValues.stream().map(p -> p.getDescriptor()).filter(p -> p instanceof DefaultParameterDescriptor).map(p -> (DefaultParameterDescriptor)p).collect(Collectors.toMap(p -> p.getName().getCode(), Function.identity()));
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Failed to initialize parameter descriptors, the UI will use generic text editors", e);
        }
    }

    private Component getInputComponent(String id, IModel paramsModel, String keyName) {
        ResourceModel labelModel = new ResourceModel(keyName, keyName);
        if (keyName.contains("Color")) {
            return new ColorPickerPanel(id, new MapModel<String>((IModel<? extends Map<String, ? extends Object>>)paramsModel, keyName), (IModel<String>)labelModel, false, new IValidator[0]);
        }
        DefaultParameterDescriptor descriptor = this.parameterDescriptorMap.get(keyName);
        if (descriptor != null) {
            Class valueClass = descriptor.getValueClass();
            if (valueClass.equals(Boolean.class)) {
                return new CheckBoxParamPanel(id, new MapModel<Boolean>((IModel<? extends Map<String, ? extends Object>>)paramsModel, keyName), (IModel)labelModel);
            }
            if (descriptor.getValueClass().isEnum()) {
                List values = Arrays.stream(descriptor.getValueClass().getEnumConstants()).map(v -> ((Enum)v).name()).collect(Collectors.toList());
                return new DropDownChoiceParamPanel(id, new MapModel<Serializable>((IModel<? extends Map<String, ? extends Object>>)paramsModel, keyName), (IModel<String>)labelModel, values, false);
            }
            Set validValues = descriptor.getValidValues();
            if (Serializable.class.isAssignableFrom(descriptor.getValueClass()) && validValues != null && !validValues.isEmpty()) {
                ArrayList values = new ArrayList(validValues);
                return new DropDownChoiceParamPanel(id, new MapModel<Serializable>((IModel<? extends Map<String, ? extends Object>>)paramsModel, keyName), (IModel<String>)labelModel, values, false);
            }
            TextParamPanel panel = new TextParamPanel(id, new MapModel((IModel<? extends Map<String, ? extends Object>>)paramsModel, keyName), (IModel<String>)labelModel, false, new IValidator[0]);
            if (Number.class.isAssignableFrom(valueClass)) {
                Number maximum;
                panel.getFormComponent().setType(valueClass);
                Number minimum = (Number)((Object)descriptor.getMinimumValue());
                if (minimum != null) {
                    panel.getFormComponent().add((IValidator)RangeValidator.minimum((Comparable)Double.valueOf(minimum.doubleValue())));
                }
                if ((maximum = (Number)((Object)descriptor.getMaximumValue())) != null && maximum instanceof Serializable) {
                    panel.getFormComponent().add((IValidator)RangeValidator.maximum((Comparable)Double.valueOf(maximum.doubleValue())));
                }
            }
            return panel;
        }
        return new TextParamPanel(id, new MapModel((IModel<? extends Map<String, ? extends Object>>)paramsModel, keyName), (IModel<String>)labelModel, false, new IValidator[0]);
    }
}

