/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Unit;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.ReuseIfModelsEqualStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.resource.ResourceConfigurationPanel;
import org.geoserver.web.wicket.DecimalListTextField;
import org.geoserver.web.wicket.DecimalTextField;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.measure.UnitFormat;
import org.geotools.measure.UnitFormatter;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.SampleDimensionType;
import si.uom.NonSI;
import si.uom.SI;

public class CoverageBandsConfigurationPanel
extends ResourceConfigurationPanel {
    static final Logger LOGGER = Logging.getLogger(CoverageBandsConfigurationPanel.class);
    private GeoServerTablePanel<CoverageDimensionInfo> bands = new GeoServerTablePanel<CoverageDimensionInfo>("bands", (GeoServerDataProvider)new CoverageDimensionsProvider(), true){

        @Override
        protected Component getComponentForProperty(String id, IModel<CoverageDimensionInfo> itemModel, GeoServerDataProvider.Property<CoverageDimensionInfo> property) {
            if ("band".equals(property.getName())) {
                Fragment f = new Fragment(id, "bandtext", (MarkupContainer)CoverageBandsConfigurationPanel.this);
                TextField text = new TextField("bandtext", property.getModel(itemModel));
                f.add(new Component[]{text});
                return f;
            }
            if ("nullValues".equals(property.getName())) {
                Fragment f = new Fragment(id, "nulltext", (MarkupContainer)CoverageBandsConfigurationPanel.this);
                DecimalListTextField text = new DecimalListTextField("nulltext", property.getModel(itemModel));
                f.add(new Component[]{text});
                return f;
            }
            if ("unit".equals(property.getName())) {
                Fragment f = new Fragment(id, "text", (MarkupContainer)CoverageBandsConfigurationPanel.this);
                Component text = CoverageBandsConfigurationPanel.this.buildUnitField("text", property.getModel(itemModel));
                f.add(new Component[]{text});
                return f;
            }
            if ("minRange".equals(property.getName())) {
                Fragment f = new Fragment(id, "minRange", (MarkupContainer)CoverageBandsConfigurationPanel.this);
                DecimalTextField min = new DecimalTextField("minRange", property.getModel(itemModel));
                f.add(new Component[]{min});
                return f;
            }
            if ("maxRange".equals(property.getName())) {
                Fragment f = new Fragment(id, "maxRange", (MarkupContainer)CoverageBandsConfigurationPanel.this);
                DecimalTextField max = new DecimalTextField("maxRange", property.getModel(itemModel));
                f.add(new Component[]{max});
                return f;
            }
            return null;
        }
    };

    public CoverageBandsConfigurationPanel(String id, IModel model) {
        super(id, model);
        this.bands.setFilterVisible(false);
        this.bands.setSortable(false);
        this.bands.setPageable(false);
        this.bands.setOutputMarkupId(true);
        this.bands.setItemReuseStrategy(ReuseIfModelsEqualStrategy.getInstance());
        this.bands.setFilterable(false);
        this.bands.setSelectable(false);
        this.add(new Component[]{this.bands});
        GeoServerAjaxFormLink reload = new GeoServerAjaxFormLink("reload"){

            protected void onClick(AjaxRequestTarget target, Form form) {
                try {
                    CoverageBandsConfigurationPanel.this.reloadBands();
                    target.add(new Component[]{CoverageBandsConfigurationPanel.this.bands});
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Failure updating the bands list", e);
                    this.error((Serializable)((Object)e.toString()));
                }
            }
        };
        this.add(new Component[]{reload});
    }

    private void reloadBands() throws Exception {
        GeoServerApplication app = (GeoServerApplication)this.getApplication();
        CoverageInfo ci = (CoverageInfo)this.getResourceInfo();
        Catalog catalog = app.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(catalog);
        cb.reloadDimensions(ci);
    }

    protected Component buildUnitField(String id, IModel<String> model) {
        return new AutoCompleteTextField<String>(id, model){

            protected Iterator<String> getChoices(String input) {
                if (Strings.isEmpty((CharSequence)input)) {
                    List emptyList = Collections.emptyList();
                    return emptyList.iterator();
                }
                ArrayList units = new ArrayList();
                units.addAll(SI.getInstance().getUnits());
                units.addAll(NonSI.getInstance().getUnits());
                ArrayList<String> unitNames = new ArrayList<String>();
                unitNames.add("W.m-2.Sr-1");
                UnitFormatter format = UnitFormat.getInstance();
                for (Unit unit : units) {
                    unitNames.add(format.format(unit));
                }
                ArrayList<String> choices = new ArrayList<String>();
                for (String name : unitNames) {
                    if (!name.toLowerCase().startsWith(input.toLowerCase())) continue;
                    choices.add(name);
                }
                return choices.iterator();
            }
        };
    }

    class CoverageDimensionsProvider
    extends GeoServerDataProvider<CoverageDimensionInfo> {
        CoverageDimensionsProvider() {
        }

        @Override
        protected List<GeoServerDataProvider.Property<CoverageDimensionInfo>> getProperties() {
            ArrayList<GeoServerDataProvider.Property<CoverageDimensionInfo>> result = new ArrayList<GeoServerDataProvider.Property<CoverageDimensionInfo>>();
            result.add(new GeoServerDataProvider.BeanProperty("band", "name"));
            result.add(new GeoServerDataProvider.AbstractProperty<CoverageDimensionInfo>("dimensionType"){

                @Override
                public Object getPropertyValue(CoverageDimensionInfo item) {
                    SampleDimensionType type = item.getDimensionType();
                    if (type == null) {
                        return "-";
                    }
                    String name = type.name();
                    try {
                        String key = CoverageBandsConfigurationPanel.class.getSimpleName() + "." + name;
                        ParamResourceModel rm = new ParamResourceModel(key, null, new Object[0]);
                        return rm.getString();
                    }
                    catch (Exception e) {
                        return name;
                    }
                }
            });
            result.add(new GeoServerDataProvider.AbstractProperty<CoverageDimensionInfo>("nullValues"){

                @Override
                public Object getPropertyValue(final CoverageDimensionInfo item) {
                    return new IModel<List<Double>>(){

                        public void detach() {
                        }

                        public List<Double> getObject() {
                            return item.getNullValues();
                        }

                        public void setObject(List<Double> object) {
                            List values = item.getNullValues();
                            values.clear();
                            values.addAll(object);
                        }
                    };
                }
            });
            result.add(new GeoServerDataProvider.AbstractProperty<CoverageDimensionInfo>("minRange"){

                @Override
                public Object getPropertyValue(final CoverageDimensionInfo item) {
                    return new IModel<Double>(){

                        public void detach() {
                        }

                        public Double getObject() {
                            if (item.getRange() == null) {
                                return null;
                            }
                            return item.getRange().getMinimum(true);
                        }

                        public void setObject(Double min) {
                            if (min != null) {
                                NumberRange range = item.getRange();
                                NumberRange newRange = NumberRange.create((double)min, (double)(range != null ? range.getMaximum() : min.doubleValue()));
                                item.setRange(newRange);
                            }
                        }
                    };
                }
            });
            result.add(new GeoServerDataProvider.AbstractProperty<CoverageDimensionInfo>("maxRange"){

                @Override
                public Object getPropertyValue(final CoverageDimensionInfo item) {
                    return new IModel<Double>(){

                        public void detach() {
                        }

                        public Double getObject() {
                            if (item.getRange() == null) {
                                return null;
                            }
                            return item.getRange().getMaximum();
                        }

                        public void setObject(Double max) {
                            if (max != null) {
                                NumberRange range = item.getRange();
                                NumberRange newRange = NumberRange.create((double)(range != null ? range.getMinimum() : max.doubleValue()), (double)max);
                                item.setRange(newRange);
                            }
                        }
                    };
                }
            });
            result.add(new GeoServerDataProvider.BeanProperty("unit", "unit"));
            return result;
        }

        @Override
        protected List<CoverageDimensionInfo> getItems() {
            CoverageInfo ci = (CoverageInfo)CoverageBandsConfigurationPanel.this.getDefaultModelObject();
            if (ci.getDimensions() != null) {
                return ci.getDimensions();
            }
            return Collections.emptyList();
        }
    }
}

