/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import com.google.common.collect.ImmutableList;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AbstractAutoCompleteTextRenderer;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

class ClassTextField
extends AutoCompleteTextField<Class> {
    private static final List<Class> BINDINGS = (List)Arrays.asList(String.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Time.class, Date.class, Timestamp.class, Geometry.class, Point.class, MultiPoint.class, LineString.class, MultiLineString.class, Polygon.class, MultiPolygon.class).stream().sorted(Comparator.comparing(Class::getSimpleName)).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    private static final Map<String, Class> NAME_TO_CLASS = BINDINGS.stream().collect(Collectors.toMap(c -> c.getSimpleName(), c -> c));
    private static final Map<Class, String> CLASS_TO_NAME = BINDINGS.stream().collect(Collectors.toMap(c -> c, c -> c.getSimpleName()));

    public ClassTextField(String id, IModel<Class> model) {
        super("type", model, (IAutoCompleteRenderer)new ClassNameRenderer());
    }

    protected Iterator<Class> getChoices(String s) {
        return BINDINGS.iterator();
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        return new ClassNameConverter();
    }

    private static String getClassName(Class c) {
        String name = CLASS_TO_NAME.get(c);
        if (name == null) {
            return c.getName();
        }
        return name;
    }

    private static class ClassNameRenderer
    extends AbstractAutoCompleteTextRenderer<Class> {
        private ClassNameRenderer() {
        }

        protected String getTextValue(Class c) {
            return ClassTextField.getClassName(c);
        }
    }

    private static class ClassNameConverter
    implements IConverter<Class> {
        private ClassNameConverter() {
        }

        public Class convertToObject(String s, Locale locale) throws ConversionException {
            Class<?> result = (Class<?>)NAME_TO_CLASS.get(s);
            if (result == null) {
                try {
                    result = Class.forName(s);
                }
                catch (ClassNotFoundException e) {
                    throw new ConversionException((Throwable)e);
                }
            }
            return result;
        }

        public String convertToString(Class c, Locale locale) {
            return ClassTextField.getClassName(c);
        }
    }
}

