/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.validator.PatternValidator;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.resource.DataLinkEditor;
import org.geoserver.web.data.resource.MetadataLinkEditor;
import org.geoserver.web.data.resource.ResourceConfigurationPanel;
import org.geoserver.web.data.resource.TitleAndAbstractPanel;
import org.geoserver.web.wicket.CRSPanel;
import org.geoserver.web.wicket.EnvelopePanel;
import org.geoserver.web.wicket.FeedbackMessageCleaner;
import org.geoserver.web.wicket.KeywordsEditor;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.web.wicket.SRSToCRSModel;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.util.DataStoreUtils;

public class BasicResourceConfig
extends ResourceConfigurationPanel {
    private static final long serialVersionUID = -552158739086379566L;
    public static final String URN_OGC_PREFIX = "urn:ogc:def:crs:EPSG::";
    public static final String EPSG_PREFIX = "EPSG:";
    DropDownChoice<ProjectionPolicy> projectionPolicy;
    CRSPanel declaredCRS;

    public BasicResourceConfig(String id, IModel<ResourceInfo> model) {
        super(id, model);
        CRSPanel nativeCRS;
        this.add(new Component[]{new Label("storeName", (Serializable)((Object)((ResourceInfo)model.getObject()).getStore().getName()))});
        this.add(new Component[]{new Label("nativeName", (Serializable)((Object)((ResourceInfo)model.getObject()).getNativeName()))});
        TextField name = new TextField("name");
        name.setRequired(true);
        this.add(new Component[]{name});
        this.add(new Component[]{new CheckBox("enabled")});
        this.add(new Component[]{new CheckBox("advertised")});
        this.add(new Component[]{new TitleAndAbstractPanel("titleAndAbstract", model, "titleMsg", "abstract", (MarkupContainer)this)});
        this.add(new Component[]{new KeywordsEditor("keywords", LiveCollectionModel.list(new PropertyModel(model, "keywords")))});
        this.add(new Component[]{new MetadataLinkEditor("metadataLinks", model)});
        this.add(new Component[]{new DataLinkEditor("dataLinks", model)});
        Form refForm = new Form("referencingForm");
        this.add(new Component[]{refForm});
        PropertyModel nativeBBoxModel = new PropertyModel(model, "nativeBoundingBox");
        EnvelopePanel nativeBBox = new EnvelopePanel("nativeBoundingBox", (IModel<ReferencedEnvelope>)nativeBBoxModel);
        nativeBBox.setOutputMarkupId(true);
        refForm.add(new Component[]{nativeBBox});
        AjaxSubmitLink nativeBoundsLink = this.computeNativeBoundsLink(refForm, nativeBBox);
        EnvelopePanel latLonPanel = new EnvelopePanel("latLonBoundingBox", (IModel<ReferencedEnvelope>)new PropertyModel(model, "latLonBoundingBox"));
        latLonPanel.setOutputMarkupId(true);
        latLonPanel.setRequired(true);
        refForm.add(new Component[]{latLonPanel});
        refForm.add(new Component[]{this.computeLatLonBoundsLink(refForm, nativeBBox, latLonPanel)});
        List<String> otherSRS = this.getOtherSRS((ResourceInfo)model.getObject());
        if (otherSRS.isEmpty()) {
            nativeCRS = new CRSPanel("nativeSRS", (IModel<CoordinateReferenceSystem>)new PropertyModel(model, "nativeCRS"));
            nativeCRS.setReadOnly(true);
        } else {
            nativeCRS = this.getSelectableNativeCRSPanel(model, otherSRS, nativeBBox, (Form<ResourceInfo>)refForm);
            nativeBoundsLink.setOutputMarkupId(true);
            nativeBoundsLink.setVisible(true);
        }
        refForm.add(new Component[]{nativeBoundsLink});
        refForm.add(new Component[]{nativeCRS});
        this.declaredCRS = new CRSPanel("declaredSRS", new SRSToCRSModel((IModel<String>)new PropertyModel(model, "sRS")));
        this.declaredCRS.setRequired(true);
        refForm.add(new Component[]{this.declaredCRS});
        refForm.add(new Component[]{this.computeBoundsFromSRS((Form<ResourceInfo>)refForm, nativeBBox)});
        this.projectionPolicy = new DropDownChoice("srsHandling", (IModel)new PropertyModel(model, "projectionPolicy"), Arrays.asList(ProjectionPolicy.values()), (IChoiceRenderer)new ProjectionPolicyRenderer());
        ResourceInfo ri = (ResourceInfo)model.getObject();
        if (((ResourceInfo)model.getObject()).getCRS() == null) {
            ri.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        }
        refForm.add(new Component[]{this.projectionPolicy});
        refForm.add((IFormValidator)new ReprojectionIsPossibleValidator((FormComponent<?>)nativeCRS, (FormComponent<?>)this.declaredCRS, (FormComponent<?>)this.projectionPolicy));
    }

    AjaxSubmitLink computeNativeBoundsLink(Form refForm, final EnvelopePanel nativeBBox) {
        return new AjaxSubmitLink("computeNative", refForm){
            private static final long serialVersionUID = 3106345307476297622L;

            public void onSubmit(AjaxRequestTarget target, Form form) {
                form.process(null);
                ResourceInfo resource = (ResourceInfo)BasicResourceConfig.this.getDefaultModelObject();
                try {
                    CatalogBuilder cb = new CatalogBuilder(GeoServerApplication.get().getCatalog());
                    ReferencedEnvelope bounds = cb.getNativeBounds(resource);
                    resource.setNativeBoundingBox(bounds);
                    nativeBBox.setModelObject(bounds);
                }
                catch (IOException e) {
                    ResourceConfigurationPanel.LOGGER.log(Level.SEVERE, "Error computing the native BBOX", e);
                    this.error((Serializable)((Object)("Error computing the native BBOX:" + e.getMessage())));
                }
                target.add(new Component[]{nativeBBox});
            }

            public boolean getDefaultFormProcessing() {
                return false;
            }
        };
    }

    AjaxSubmitLink computeBoundsFromSRS(Form<ResourceInfo> refForm, final EnvelopePanel nativeBoundsPanel) {
        return new AjaxSubmitLink("computeLatLonFromNativeSRS", refForm){
            private static final long serialVersionUID = 9211250161114770325L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                ResourceConfigurationPanel.LOGGER.log(Level.FINE, "Computing bounds from native CRS");
                ResourceInfo resource = (ResourceInfo)BasicResourceConfig.this.getDefaultModelObject();
                CatalogBuilder cb = new CatalogBuilder(GeoServerApplication.get().getCatalog());
                ReferencedEnvelope nativeBBox = cb.getBoundsFromCRS(resource);
                if (nativeBBox != null) {
                    nativeBoundsPanel.setModelObject(nativeBBox);
                }
                target.add(new Component[]{nativeBoundsPanel});
            }

            public boolean getDefaultFormProcessing() {
                return false;
            }
        };
    }

    AjaxSubmitLink computeLatLonBoundsLink(Form refForm, final EnvelopePanel nativeBBox, final EnvelopePanel latLonPanel) {
        return new AjaxSubmitLink("computeLatLon", refForm){
            private static final long serialVersionUID = -5981662004745936762L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                form.process(null);
                form.visitFormComponents(new FeedbackMessageCleaner(0));
                ReferencedEnvelope nativeBounds = (ReferencedEnvelope)nativeBBox.getModelObject();
                try {
                    if (nativeBounds == null) {
                        ResourceInfo resource = (ResourceInfo)BasicResourceConfig.this.getDefaultModelObject();
                        CatalogBuilder cb = new CatalogBuilder(GeoServerApplication.get().getCatalog());
                        nativeBounds = cb.getNativeBounds(resource);
                        resource.setNativeBoundingBox(nativeBounds);
                        nativeBBox.setModelObject(nativeBounds);
                        target.add(new Component[]{nativeBBox});
                    }
                    CatalogBuilder cb = new CatalogBuilder(GeoServerApplication.get().getCatalog());
                    latLonPanel.setModelObject(cb.getLatLonBounds(nativeBounds, BasicResourceConfig.this.declaredCRS.getCRS()));
                }
                catch (IOException e) {
                    ResourceConfigurationPanel.LOGGER.log(Level.SEVERE, "Error computing the geographic BBOX", e);
                    this.error((Serializable)((Object)("Error computing the geographic bounds:" + e.getMessage())));
                }
                target.add(new Component[]{latLonPanel});
            }

            public boolean getDefaultFormProcessing() {
                return false;
            }
        };
    }

    public boolean addOtherSRS(ResourceInfo resourceInfo) {
        List<String> otherSRS = this.getOtherSRS(resourceInfo);
        if (otherSRS != null && !otherSRS.isEmpty()) {
            resourceInfo.getMetadata().put("OTHER_SRS", (Serializable)((Object)String.join((CharSequence)",", otherSRS)));
            return true;
        }
        return false;
    }

    private String getActualNativeSRSCode(ResourceInfo resourceInfo) {
        try {
            CatalogBuilder cb = new CatalogBuilder(GeoServerApplication.get().getCatalog());
            cb.setStore(resourceInfo.getStore());
            return EPSG_PREFIX + CRS.lookupEpsgCode((CoordinateReferenceSystem)cb.getNativeCRS(resourceInfo), (boolean)false);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error getting actual Native SRS code for resource " + resourceInfo.getNativeName(), e);
            return "";
        }
    }

    private List<String> getOtherSRS(ResourceInfo resourceInfo) {
        List otherSRS = Collections.emptyList();
        if (resourceInfo instanceof FeatureTypeInfo) {
            otherSRS = DataStoreUtils.getOtherSRSFromWfsNg((FeatureTypeInfo)((FeatureTypeInfo)resourceInfo));
        } else if (resourceInfo instanceof WMSLayerInfo) {
            otherSRS = DataStoreUtils.getOtherSRSFromWMSStore((WMSLayerInfo)((WMSLayerInfo)resourceInfo));
        } else if (resourceInfo instanceof WMTSLayerInfo) {
            otherSRS = DataStoreUtils.getOtherSRSFromWMTSStore((WMTSLayerInfo)((WMTSLayerInfo)resourceInfo));
        }
        return otherSRS;
    }

    private CRSPanel getSelectableNativeCRSPanel(final IModel<ResourceInfo> model, List<String> otherSRS, final EnvelopePanel nativeBBox, final Form<ResourceInfo> refForm) {
        this.addOtherSRS((ResourceInfo)model.getObject());
        String actualSRS = this.getActualNativeSRSCode((ResourceInfo)model.getObject());
        if (!otherSRS.contains(actualSRS)) {
            otherSRS.add(this.getActualNativeSRSCode((ResourceInfo)model.getObject()));
        }
        CRSPanel nativeCRS = new CRSPanel("nativeSRS", (IModel)new PropertyModel(model, "nativeCRS"), otherSRS, !otherSRS.isEmpty()){
            private static final long serialVersionUID = -7725670382699858126L;

            @Override
            protected void onSRSUpdated(String srs, AjaxRequestTarget target) {
                super.onSRSUpdated(srs, target);
                try {
                    CoordinateReferenceSystem crs = CRS.decode((String)srs);
                    ReferencedEnvelope bounds = ((ResourceInfo)model.getObject()).getNativeBoundingBox().transform(crs, false);
                    nativeBBox.setModelObject(bounds);
                    ((ResourceInfo)model.getObject()).setSRS(srs);
                    ((ResourceInfo)model.getObject()).setNativeCRS(crs);
                    ((ResourceInfo)model.getObject()).setNativeBoundingBox(bounds);
                    target.add(new Component[]{nativeBBox});
                    refForm.get("computeNative").setVisible(this.isActualNative(crs, (ResourceInfo)model.getObject()));
                    refForm.add(new Component[]{refForm.get("computeNative")});
                    target.add(new Component[]{refForm});
                }
                catch (Exception e) {
                    ResourceConfigurationPanel.LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }

            private boolean isActualNative(CoordinateReferenceSystem crs, ResourceInfo resourceInfo) {
                try {
                    CatalogBuilder cb = new CatalogBuilder(GeoServerApplication.get().getCatalog());
                    cb.setStore(resourceInfo.getStore());
                    return CRS.equalsIgnoreMetadata((Object)crs, (Object)cb.getNativeCRS(resourceInfo));
                }
                catch (Exception e) {
                    ResourceConfigurationPanel.LOGGER.log(Level.SEVERE, "Error getting actual Native SRS code for resource " + resourceInfo.getNativeName(), e);
                    return false;
                }
            }
        };
        nativeCRS.setFindLinkVisible(true);
        return nativeCRS;
    }

    private static class ReprojectionIsPossibleValidator
    implements IFormValidator {
        private static final long serialVersionUID = -8006718598046409480L;
        private FormComponent<?>[] dependentFormComponents;
        private FormComponent<?> nativeCRS;
        private FormComponent<?> declaredCRS;
        private FormComponent<?> projectionPolicy;

        public ReprojectionIsPossibleValidator(FormComponent<?> nativeCRS, FormComponent<?> declaredCRS, FormComponent<?> projectionPolicy) {
            this.nativeCRS = nativeCRS;
            this.declaredCRS = declaredCRS;
            this.projectionPolicy = projectionPolicy;
            this.dependentFormComponents = new FormComponent[]{nativeCRS, declaredCRS, projectionPolicy};
        }

        public FormComponent<?>[] getDependentFormComponents() {
            return this.dependentFormComponents;
        }

        public void validate(Form<?> form) {
            CoordinateReferenceSystem nativeCrs = (CoordinateReferenceSystem)this.nativeCRS.getConvertedInput();
            CoordinateReferenceSystem declaredCrs = (CoordinateReferenceSystem)this.declaredCRS.getConvertedInput();
            ProjectionPolicy policy = (ProjectionPolicy)this.projectionPolicy.getConvertedInput();
            if (policy == ProjectionPolicy.REPROJECT_TO_DECLARED) {
                boolean lenient = true;
                try {
                    CRS.findMathTransform((CoordinateReferenceSystem)nativeCrs, (CoordinateReferenceSystem)declaredCrs, (boolean)true);
                }
                catch (FactoryException e) {
                    String msgKey = "BasicResourceConfig.noTransformFromNativeToDeclaredCRS";
                    String errMsg = e.getMessage();
                    String message = new ResourceModel(msgKey).getObject();
                    form.error(message, Collections.singletonMap("error", errMsg));
                }
            }
        }
    }

    static class ResourceNameValidator
    extends PatternValidator {
        private static final long serialVersionUID = 2160813837236916013L;

        public ResourceNameValidator() {
            super("[\\w][\\w.-]*");
        }
    }

    class ProjectionPolicyRenderer
    extends ChoiceRenderer<ProjectionPolicy> {
        private static final long serialVersionUID = -6593748590058977418L;

        ProjectionPolicyRenderer() {
        }

        public Object getDisplayValue(ProjectionPolicy object) {
            return new StringResourceModel(object.name(), (Component)BasicResourceConfig.this, null).getString();
        }

        public String getIdValue(ProjectionPolicy object, int index) {
            return object.name();
        }
    }
}

