/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.DefaultItemReuseStrategy;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.resource.ClassTextField;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.ImageAjaxLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.ReorderableTablePanel;
import org.geotools.util.logging.Logging;

class AttributeTypeInfoEditor
extends Panel {
    static final Logger LOGGER = Logging.getLogger(AttributeTypeInfoEditor.class);
    private static final GeoServerDataProvider.Property<AttributeTypeInfo> NAME = new GeoServerDataProvider.BeanProperty<AttributeTypeInfo>("name");
    private static final GeoServerDataProvider.Property<AttributeTypeInfo> BINDING = new GeoServerDataProvider.BeanProperty<AttributeTypeInfo>("binding");
    private static final GeoServerDataProvider.Property<AttributeTypeInfo> SOURCE = new GeoServerDataProvider.BeanProperty<AttributeTypeInfo>("source");
    private static final GeoServerDataProvider.Property<AttributeTypeInfo> NILLABLE = new GeoServerDataProvider.BeanProperty<AttributeTypeInfo>("nillable");
    private static final GeoServerDataProvider.PropertyPlaceholder<AttributeTypeInfo> REMOVE = new GeoServerDataProvider.PropertyPlaceholder("remove");
    private static final LoadableDetachableModel<List<GeoServerDataProvider.Property<AttributeTypeInfo>>> propertiesModel = new LoadableDetachableModel<List<GeoServerDataProvider.Property<AttributeTypeInfo>>>(){

        protected List<GeoServerDataProvider.Property<AttributeTypeInfo>> load() {
            return Arrays.asList(NAME, BINDING, SOURCE, NILLABLE, REMOVE);
        }
    };
    private final ReorderableTablePanel<AttributeTypeInfo> table;
    private final Component parent;

    public AttributeTypeInfoEditor(String id, IModel model, Component parent) {
        super(id, model);
        this.parent = parent;
        this.add(new Component[]{new AddAttributeLink()});
        this.add(new Component[]{new ResetLink()});
        List<AttributeTypeInfo> attributes = AttributeTypeInfoEditor.getAttributes(model, parent);
        this.table = new EditorTable(attributes, parent);
        this.table.setItemReuseStrategy((IItemReuseStrategy)new DefaultItemReuseStrategy());
        this.table.setPageable(false);
        this.table.setFilterable(false);
        this.add(new Component[]{this.table});
    }

    private static List<AttributeTypeInfo> getAttributes(IModel model, Component parent) {
        FeatureTypeInfo typeInfo = (FeatureTypeInfo)model.getObject();
        List attributes = typeInfo.getAttributes();
        if (attributes == null || attributes.isEmpty()) {
            return AttributeTypeInfoEditor.loadNativeAttributes(typeInfo, parent);
        }
        if (attributes.stream().anyMatch(a -> a.getBinding() == null)) {
            List<AttributeTypeInfo> nativeAttributes = AttributeTypeInfoEditor.loadNativeAttributes(typeInfo, parent);
            Map<String, Class> bindings = nativeAttributes.stream().collect(Collectors.toMap(a -> a.getName(), a -> a.getBinding()));
            for (AttributeTypeInfo at : attributes) {
                if (at.getBinding() != null) continue;
                at.setBinding(bindings.get(at.getName()));
            }
        }
        return new ArrayList<AttributeTypeInfo>(attributes);
    }

    static List<AttributeTypeInfo> loadNativeAttributes(FeatureTypeInfo typeInfo, Component component) {
        try {
            Catalog catalog = GeoServerApplication.get().getCatalog();
            ResourcePool resourcePool = catalog.getResourcePool();
            return resourcePool.loadAttributes(typeInfo);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Grabbing the attribute list failed", e);
            String error = new ParamResourceModel("attributeListingFailed", component, e.getMessage()).getString();
            component.getPage().error((Serializable)((Object)error));
            return Collections.emptyList();
        }
    }

    public Collection<? extends AttributeTypeInfo> getItems() {
        this.table.processInputs();
        return this.table.getItems();
    }

    private class ResetLink
    extends AjaxLink<LayerInfo> {
        public ResetLink() {
            super("resetAttributes");
        }

        public void onClick(AjaxRequestTarget target) {
            AttributeTypeInfoEditor.this.table.getItems().clear();
            FeatureTypeInfo typeInfo = (FeatureTypeInfo)AttributeTypeInfoEditor.this.getDefaultModelObject();
            AttributeTypeInfoEditor.this.table.getItems().addAll(AttributeTypeInfoEditor.loadNativeAttributes(typeInfo, AttributeTypeInfoEditor.this.parent));
            target.add(new Component[]{AttributeTypeInfoEditor.this.parent});
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            AjaxCallListener ajaxCallListener = new AjaxCallListener();
            String message = new ParamResourceModel("confirmReset", (Component)this, new Object[0]).getString();
            ajaxCallListener.onPrecondition((CharSequence)("return confirm('" + message + "');"));
            attributes.getAjaxCallListeners().add(ajaxCallListener);
        }
    }

    private class AddAttributeLink
    extends AjaxLink<LayerInfo> {
        public AddAttributeLink() {
            super("addAttribute");
        }

        public void onClick(AjaxRequestTarget target) {
            AttributeTypeInfo att = GeoServerApplication.get().getCatalog().getFactory().createAttribute();
            AttributeTypeInfoEditor.this.table.getItems().add(att);
            target.add(new Component[]{AttributeTypeInfoEditor.this.parent});
        }
    }

    private static class UpdateModelBehavior
    extends AjaxFormComponentUpdatingBehavior {
        public UpdateModelBehavior() {
            super("blur");
        }

        protected void onUpdate(AjaxRequestTarget ajaxRequestTarget) {
        }
    }

    private class EditorTable
    extends ReorderableTablePanel<AttributeTypeInfo> {
        private final Component targetComponent;

        public EditorTable(List<AttributeTypeInfo> attributes, Component targetComponent) {
            super("table", AttributeTypeInfo.class, attributes, propertiesModel);
            this.targetComponent = targetComponent;
        }

        @Override
        protected Component getComponentForProperty(String id, IModel<AttributeTypeInfo> itemModel, GeoServerDataProvider.Property<AttributeTypeInfo> property) {
            IModel<?> model = property.getModel(itemModel);
            if (property == NAME) {
                Fragment f = new Fragment(id, "text", this.getParent());
                TextField nameField = new TextField("text", model);
                nameField.add(new Behavior[]{new UpdateModelBehavior()});
                f.add(new Component[]{nameField});
                return f;
            }
            if (property == BINDING) {
                Fragment f = new Fragment(id, "type", this.getParent());
                ClassTextField type = new ClassTextField(id, model);
                f.add(new Component[]{type});
                return f;
            }
            if (property == SOURCE) {
                Fragment f = new Fragment(id, "area", this.getParent());
                TextArea source = new TextArea("area", model);
                source.add(new Behavior[]{new UpdateModelBehavior()});
                f.add(new Component[]{source});
                return f;
            }
            if (property == NILLABLE) {
                Fragment f = new Fragment(id, "check", this.getParent());
                CheckBox check = new CheckBox("check", model);
                f.add(new Component[]{check});
                return f;
            }
            if (property == REMOVE) {
                final AttributeTypeInfo entry = (AttributeTypeInfo)itemModel.getObject();
                PackageResourceReference icon = new PackageResourceReference(((Object)((Object)this)).getClass(), "../../img/icons/silk/delete.png");
                ImageAjaxLink<Object> link = new ImageAjaxLink<Object>(id, icon){

                    @Override
                    protected void onClick(AjaxRequestTarget target) {
                        EditorTable.this.getItems().remove(entry);
                        target.add(new Component[]{EditorTable.this.targetComponent});
                    }
                };
                return link;
            }
            return null;
        }
    }
}

