/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.layergroup.LayerGroupDetachableModel;
import org.geoserver.web.data.layergroup.LayerGroupProviderFilter;
import org.geoserver.web.wicket.GeoServerDataProvider;

public class LayerGroupProvider
extends GeoServerDataProvider<LayerGroupInfo> {
    private static final long serialVersionUID = 4806818198949114395L;
    public static GeoServerDataProvider.Property<LayerGroupInfo> NAME = new GeoServerDataProvider.BeanProperty<LayerGroupInfo>("name", "name");
    public static GeoServerDataProvider.Property<LayerGroupInfo> WORKSPACE = new GeoServerDataProvider.BeanProperty<LayerGroupInfo>("workspace", "workspace.name");
    static final GeoServerDataProvider.Property<LayerGroupInfo> MODIFIED_TIMESTAMP = new GeoServerDataProvider.BeanProperty<LayerGroupInfo>("datemodfied", "dateModified");
    static final GeoServerDataProvider.Property<LayerGroupInfo> CREATED_TIMESTAMP = new GeoServerDataProvider.BeanProperty<LayerGroupInfo>("datecreated", "dateCreated");
    public static GeoServerDataProvider.Property<LayerGroupInfo> ENABLED = new GeoServerDataProvider.AbstractProperty<LayerGroupInfo>("Enabled"){

        public Boolean getPropertyValue(LayerGroupInfo item) {
            return item.isEnabled();
        }
    };
    static List<GeoServerDataProvider.Property<LayerGroupInfo>> PROPERTIES = Arrays.asList(NAME, WORKSPACE, ENABLED);
    protected LayerGroupProviderFilter groupFilter = null;

    public LayerGroupProvider() {
    }

    public LayerGroupProvider(LayerGroupProviderFilter groupFilter) {
        this.groupFilter = groupFilter;
    }

    @Override
    protected List<LayerGroupInfo> getItems() {
        ArrayList<LayerGroupInfo> groups = this.getCatalog().getLayerGroups();
        if (this.groupFilter != null) {
            ArrayList<LayerGroupInfo> filtered = new ArrayList<LayerGroupInfo>(groups.size());
            for (LayerGroupInfo group : groups) {
                if (!this.groupFilter.accept(group)) continue;
                filtered.add(group);
            }
            groups = filtered;
        }
        return groups;
    }

    @Override
    protected List<GeoServerDataProvider.Property<LayerGroupInfo>> getProperties() {
        List<GeoServerDataProvider.Property<LayerGroupInfo>> modifiedPropertiesList = PROPERTIES.stream().map(c -> c).collect(Collectors.toList());
        if (GeoServerApplication.get().getGeoServer().getSettings().isShowCreatedTimeColumnsInAdminList()) {
            modifiedPropertiesList.add(CREATED_TIMESTAMP);
        }
        if (GeoServerApplication.get().getGeoServer().getSettings().isShowModifiedTimeColumnsInAdminList()) {
            modifiedPropertiesList.add(MODIFIED_TIMESTAMP);
        }
        return modifiedPropertiesList;
    }

    @Override
    public IModel<LayerGroupInfo> newModel(LayerGroupInfo object) {
        return new LayerGroupDetachableModel(object);
    }
}

