/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.DefaultItemReuseStrategy;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.data.layergroup.LayerGroupEntry;
import org.geoserver.web.data.layergroup.LayerGroupListPanel;
import org.geoserver.web.data.layergroup.LayerListPanel;
import org.geoserver.web.data.layergroup.StyleListPanel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.HelpLink;
import org.geoserver.web.wicket.ImageAjaxLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.ReorderableTablePanel;
import org.geoserver.web.wicket.SimpleAjaxLink;

public abstract class LayerGroupEntryPanel<T>
extends Panel {
    private static final long serialVersionUID = -5483938812185582866L;
    public static final GeoServerDataProvider.Property<LayerGroupEntry> LAYER_TYPE = new GeoServerDataProvider.PropertyPlaceholder<LayerGroupEntry>("layerType");
    public static final GeoServerDataProvider.Property<LayerGroupEntry> LAYER = new GeoServerDataProvider.PropertyPlaceholder<LayerGroupEntry>("layer");
    public static final GeoServerDataProvider.Property<LayerGroupEntry> DEFAULT_STYLE = new GeoServerDataProvider.PropertyPlaceholder<LayerGroupEntry>("defaultStyle");
    public static final GeoServerDataProvider.Property<LayerGroupEntry> STYLE = new GeoServerDataProvider.PropertyPlaceholder<LayerGroupEntry>("style");
    public static final GeoServerDataProvider.Property<LayerGroupEntry> REMOVE = new GeoServerDataProvider.PropertyPlaceholder<LayerGroupEntry>("remove");
    static final List<GeoServerDataProvider.Property<LayerGroupEntry>> PROPERTIES = Arrays.asList(LAYER_TYPE, LAYER, DEFAULT_STYLE, STYLE, REMOVE);
    ModalWindow popupWindow;
    GeoServerTablePanel<LayerGroupEntry> layerTable;
    List<LayerGroupEntry> items;
    GeoServerDialog dialog;

    public LayerGroupEntryPanel(String id, IModel<T> tModel, IModel<WorkspaceInfo> groupWorkspace) {
        super(id);
        this.initUI(this.getLayers(tModel.getObject()), this.getStyles(tModel.getObject()), groupWorkspace);
    }

    public LayerGroupEntryPanel(String id, IModel<T> tModel, IModel<WorkspaceInfo> groupWorkspace, boolean horizontalBtn, boolean bigLegendTitle) {
        super(id);
        this.initUI(this.getLayers(tModel.getObject()), this.getStyles(tModel.getObject()), groupWorkspace, bigLegendTitle);
    }

    public LayerGroupEntryPanel(String id, T t, IModel<WorkspaceInfo> groupWorkspace) {
        super(id);
        this.initUI(this.getLayers(t), this.getStyles(t), groupWorkspace);
    }

    public LayerGroupEntryPanel(String id, List<PublishedInfo> layers, List<StyleInfo> styles, IModel<WorkspaceInfo> groupWorkspace) {
        super(id);
        this.initUI(layers, styles, groupWorkspace);
    }

    private void initUI(List<PublishedInfo> layers, List<StyleInfo> styles, IModel<WorkspaceInfo> groupWorkspace) {
        this.initUI(layers, styles, groupWorkspace, true);
    }

    private void initUI(List<PublishedInfo> layers, List<StyleInfo> styles, IModel<WorkspaceInfo> groupWorkspace, boolean bigLegendTitle) {
        this.items = new ArrayList<LayerGroupEntry>();
        for (int i = 0; i < layers.size(); ++i) {
            PublishedInfo layer = layers.get(i);
            StyleInfo style = styles.get(i);
            this.items.add(new LayerGroupEntry(layer, style));
        }
        Component[] componentArray = new Component[1];
        this.popupWindow = new ModalWindow("popup");
        componentArray[0] = this.popupWindow;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray2[0] = this.dialog;
        this.add(componentArray2);
        this.add(new Component[]{this.panelTitle(bigLegendTitle)});
        LoadableDetachableModel<List<GeoServerDataProvider.Property<LayerGroupEntry>>> propertiesModel = new LoadableDetachableModel<List<GeoServerDataProvider.Property<LayerGroupEntry>>>(){

            protected List<GeoServerDataProvider.Property<LayerGroupEntry>> load() {
                return PROPERTIES;
            }
        };
        Component[] componentArray3 = new Component[1];
        this.layerTable = new ReorderableTablePanel<LayerGroupEntry>("layers", LayerGroupEntry.class, this.items, (IModel)propertiesModel){
            private static final long serialVersionUID = -3270471094618284639L;

            @Override
            protected Component getComponentForProperty(String id, IModel<LayerGroupEntry> itemModel, GeoServerDataProvider.Property<LayerGroupEntry> property) {
                if (property == LAYER_TYPE) {
                    return LayerGroupEntryPanel.this.typeLink(id, itemModel);
                }
                if (property == LAYER) {
                    return LayerGroupEntryPanel.this.layerLink(id, itemModel);
                }
                if (property == DEFAULT_STYLE) {
                    return LayerGroupEntryPanel.this.defaultStyleCheckbox(id, itemModel);
                }
                if (property == STYLE) {
                    return LayerGroupEntryPanel.this.styleLink(id, itemModel);
                }
                if (property == REMOVE) {
                    return LayerGroupEntryPanel.this.removeLink(id, itemModel);
                }
                return null;
            }
        }.setFilterable(false);
        componentArray3[0] = this.layerTable;
        this.add(componentArray3);
        this.layerTable.setItemReuseStrategy((IItemReuseStrategy)new DefaultItemReuseStrategy());
        this.layerTable.setOutputMarkupId(true);
        this.layerTable.setPageable(false);
        this.add(new Component[]{this.addLayer(groupWorkspace)});
        this.add(new Component[]{this.addLayerGroup(groupWorkspace)});
        this.add(new Component[]{this.addStyleGroup()});
        this.add(new Component[]{this.styleGroupHelp()});
    }

    private Fragment panelTitle(boolean legendTitle) {
        String id = legendTitle ? "bigLegend" : "smallLegend";
        Fragment fragment = new Fragment("panelTitle", id, (MarkupContainer)this);
        if (legendTitle) {
            fragment.add(new Component[]{new HelpLink("layersHelp").setDialog(this.dialog)});
        }
        return fragment;
    }

    private AjaxLink<LayerInfo> addLayer(final IModel<WorkspaceInfo> groupWorkspace) {
        return new AjaxLink<LayerInfo>("addLayer"){
            private static final long serialVersionUID = -6143440041597461787L;

            public void onClick(AjaxRequestTarget target) {
                LayerGroupEntryPanel.this.popupWindow.setInitialHeight(375);
                LayerGroupEntryPanel.this.popupWindow.setInitialWidth(525);
                LayerGroupEntryPanel.this.popupWindow.setTitle((IModel)new ParamResourceModel("chooseLayer", (Component)this, new Object[0]));
                LayerGroupEntryPanel.this.popupWindow.setContent((Component)new LayerListPanel(LayerGroupEntryPanel.this.popupWindow.getContentId(), (WorkspaceInfo)groupWorkspace.getObject()){
                    private static final long serialVersionUID = -47811496174289699L;

                    @Override
                    protected void handleLayer(LayerInfo layer, AjaxRequestTarget target) {
                        LayerGroupEntryPanel.this.popupWindow.close((IPartialPageRequestHandler)target);
                        LayerGroupEntryPanel.this.items.add(new LayerGroupEntry((PublishedInfo)layer, layer.getDefaultStyle()));
                        target.add(new Component[]{LayerGroupEntryPanel.this.layerTable});
                    }
                });
                LayerGroupEntryPanel.this.popupWindow.show((IPartialPageRequestHandler)target);
            }
        };
    }

    private AjaxLink<LayerGroupInfo> addLayerGroup(final IModel<WorkspaceInfo> groupWorkspace) {
        return new AjaxLink<LayerGroupInfo>("addLayerGroup"){
            private static final long serialVersionUID = -6600366636542152188L;

            public void onClick(AjaxRequestTarget target) {
                LayerGroupEntryPanel.this.popupWindow.setInitialHeight(375);
                LayerGroupEntryPanel.this.popupWindow.setInitialWidth(525);
                LayerGroupEntryPanel.this.popupWindow.setTitle((IModel)new ParamResourceModel("chooseLayerGroup", (Component)this, new Object[0]));
                LayerGroupEntryPanel.this.popupWindow.setContent((Component)new LayerGroupListPanel(LayerGroupEntryPanel.this.popupWindow.getContentId(), (WorkspaceInfo)groupWorkspace.getObject()){
                    private static final long serialVersionUID = 4052338807144204692L;

                    @Override
                    protected void handleLayerGroup(LayerGroupInfo layerGroup, AjaxRequestTarget target) {
                        LayerGroupEntryPanel.this.popupWindow.close((IPartialPageRequestHandler)target);
                        LayerGroupEntryPanel.this.items.add(new LayerGroupEntry((PublishedInfo)layerGroup, null));
                        target.add(new Component[]{LayerGroupEntryPanel.this.layerTable});
                    }
                });
                LayerGroupEntryPanel.this.popupWindow.show((IPartialPageRequestHandler)target);
            }
        };
    }

    private AjaxLink<LayerGroupInfo> addStyleGroup() {
        return new AjaxLink<LayerGroupInfo>("addStyleGroup"){

            public void onClick(AjaxRequestTarget target) {
                LayerGroupEntryPanel.this.popupWindow.setInitialHeight(375);
                LayerGroupEntryPanel.this.popupWindow.setInitialWidth(525);
                LayerGroupEntryPanel.this.popupWindow.setTitle((IModel)new ParamResourceModel("chooseStyleGroup", (Component)this, new Object[0]));
                LayerGroupEntryPanel.this.popupWindow.setContent((Component)new StyleListPanel(LayerGroupEntryPanel.this.popupWindow.getContentId(), new StyleListPanel.StyleListProvider()){

                    @Override
                    protected void handleStyle(StyleInfo style, AjaxRequestTarget target) {
                        LayerGroupEntryPanel.this.popupWindow.close((IPartialPageRequestHandler)target);
                        LayerGroupEntryPanel.this.items.add(new LayerGroupEntry(null, style));
                        target.add(new Component[]{LayerGroupEntryPanel.this.layerTable});
                    }
                });
                LayerGroupEntryPanel.this.popupWindow.show((IPartialPageRequestHandler)target);
            }
        };
    }

    private HelpLink styleGroupHelp() {
        return new HelpLink("styleGroupHelp").setDialog(this.dialog);
    }

    public List<LayerGroupEntry> getEntries() {
        return this.items;
    }

    Component typeLink(String id, IModel<LayerGroupEntry> itemModel) {
        LayerGroupEntry entry = (LayerGroupEntry)itemModel.getObject();
        return new Label(id, (Serializable)((Object)("<i>" + entry.getType().toString() + "</i>"))).setEscapeModelStrings(false);
    }

    Component layerLink(String id, IModel<LayerGroupEntry> itemModel) {
        LayerGroupEntry entry = (LayerGroupEntry)itemModel.getObject();
        return new Label(id, (Serializable)((Object)(entry.getLayer() == null ? "" : entry.getLayer().prefixedName())));
    }

    Component defaultStyleCheckbox(String id, IModel<LayerGroupEntry> itemModel) {
        final LayerGroupEntry entry = (LayerGroupEntry)itemModel.getObject();
        Fragment f = new Fragment(id, "defaultStyle", (MarkupContainer)this);
        CheckBox ds = new CheckBox("checkbox", (IModel)new Model((Serializable)Boolean.valueOf(entry.isDefaultStyle())));
        ds.add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 7700386104410665242L;

            protected void onUpdate(AjaxRequestTarget target) {
                Boolean useDefault = (Boolean)this.getComponent().getDefaultModelObject();
                entry.setDefaultStyle(useDefault);
                target.add(new Component[]{LayerGroupEntryPanel.this.layerTable});
            }
        }});
        f.add(new Component[]{ds});
        return f;
    }

    Component styleLink(String id, final IModel<LayerGroupEntry> itemModel) {
        LayerGroupInfo group;
        List groupStyles;
        LayerGroupEntry entry = (LayerGroupEntry)itemModel.getObject();
        String styleName = null;
        boolean defaultStyle = true;
        if (entry.getStyle() != null) {
            styleName = entry.getStyle().getName();
            defaultStyle = false;
        } else if (entry.getLayer() instanceof LayerInfo) {
            LayerInfo layer = (LayerInfo)entry.getLayer();
            if (layer.getDefaultStyle() != null) {
                styleName = layer.getDefaultStyle().getName();
            }
        } else if (entry.getLayer() instanceof LayerGroupInfo && (groupStyles = (group = (LayerGroupInfo)entry.getLayer()).getLayerGroupStyles()) != null && !groupStyles.isEmpty()) {
            defaultStyle = false;
        }
        SimpleAjaxLink<String> link = new SimpleAjaxLink<String>(id, (IModel)new Model((Serializable)((Object)styleName))){
            private static final long serialVersionUID = 4677068931971673637L;

            @Override
            public void onClick(AjaxRequestTarget target) {
                LayerGroupEntryPanel.this.popupWindow.setInitialHeight(375);
                LayerGroupEntryPanel.this.popupWindow.setInitialWidth(525);
                LayerGroupEntryPanel.this.popupWindow.setTitle((IModel)new ParamResourceModel("chooseStyle", (Component)this, new Object[0]));
                LayerGroupEntryPanel.this.popupWindow.setContent((Component)new StyleListPanel(LayerGroupEntryPanel.this.popupWindow.getContentId(), ((LayerGroupEntry)itemModel.getObject()).getLayer()){
                    private static final long serialVersionUID = -8463999379475701401L;

                    @Override
                    protected void handleStyle(StyleInfo style, AjaxRequestTarget target) {
                        LayerGroupEntryPanel.this.popupWindow.close((IPartialPageRequestHandler)target);
                        LayerGroupEntry entry = (LayerGroupEntry)itemModel.getObject();
                        entry.setStyle(style);
                        target.add(new Component[]{LayerGroupEntryPanel.this.layerTable});
                    }
                });
                LayerGroupEntryPanel.this.popupWindow.show((IPartialPageRequestHandler)target);
            }
        };
        link.getLink().setEnabled(!defaultStyle);
        return link;
    }

    Component removeLink(String id, IModel<LayerGroupEntry> itemModel) {
        final LayerGroupEntry entry = (LayerGroupEntry)itemModel.getObject();
        ImageAjaxLink<Object> link = new ImageAjaxLink<Object>(id, new PackageResourceReference(((Object)((Object)this)).getClass(), "../../img/icons/silk/delete.png")){
            private static final long serialVersionUID = 4050942811476326745L;

            @Override
            protected void onClick(AjaxRequestTarget target) {
                LayerGroupEntryPanel.this.items.remove(entry);
                target.add(new Component[]{LayerGroupEntryPanel.this.layerTable});
            }
        };
        link.getImage().add(new Behavior[]{new AttributeModifier("alt", (IModel)new ParamResourceModel("LayerGroupEditPage.th.remove", (Component)link, new Object[0]))});
        return link;
    }

    protected abstract List<PublishedInfo> getLayers(T var1);

    protected abstract List<StyleInfo> getStyles(T var1);
}

