/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.layer.AttributeDescription;
import org.geoserver.web.data.layer.AttributeEditPage;
import org.geoserver.web.data.layer.AttributeNewPage;
import org.geoserver.web.data.layer.AttributesProvider;
import org.geoserver.web.data.layer.NewLayerPage;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ImageAjaxLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class NewFeatureTypePage
extends GeoServerSecuredPage {
    public static final String DATASTORE = "storeName";
    public static final String WORKSPACE = "wsName";
    String name;
    Form<?> form;
    AttributesProvider attributesProvider;
    GeoServerTablePanel<AttributeDescription> attributeTable;
    String storeId;

    public NewFeatureTypePage(PageParameters params) {
        this(params.get(WORKSPACE).toOptionalString(), params.get(DATASTORE).toString());
    }

    public NewFeatureTypePage(String workspaceName, String storeName) {
        DataStoreInfo di = this.getCatalog().getDataStoreByName(workspaceName, storeName);
        if (di == null) {
            throw new IllegalArgumentException("Could not find a " + storeName + " store in the " + workspaceName + " workspace");
        }
        this.storeId = di.getId();
        this.form = new Form("form");
        this.form.setOutputMarkupId(true);
        this.add(new Component[]{this.form});
        this.form.add(new Component[]{new TextField("name", (IModel)new PropertyModel((Object)this, "name")).setRequired(true)});
        this.attributesProvider = new AttributesProvider();
        this.attributeTable = new GeoServerTablePanel<AttributeDescription>("attributes", (GeoServerDataProvider)this.attributesProvider, true){

            @Override
            protected Component getComponentForProperty(String id, IModel<AttributeDescription> itemModel, GeoServerDataProvider.Property<AttributeDescription> property) {
                AttributeDescription att = (AttributeDescription)itemModel.getObject();
                if (property == AttributesProvider.NAME) {
                    Fragment f = new Fragment(id, "nameFragment", (MarkupContainer)NewFeatureTypePage.this);
                    f.add(new Component[]{NewFeatureTypePage.this.editAttributeLink(itemModel)});
                    return f;
                }
                if (property == AttributesProvider.BINDING) {
                    return new Label(id, (Serializable)((Object)AttributeDescription.getLocalizedName(att.getBinding())));
                }
                if (property == AttributesProvider.CRS) {
                    if (att.getBinding() != null && Geometry.class.isAssignableFrom(att.getBinding())) {
                        try {
                            Integer epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)att.getCrs(), (boolean)false);
                            return new Label(id, (Serializable)((Object)("EPSG:" + epsgCode)));
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return new Label(id, (Serializable)((Object)""));
                }
                if (property == AttributesProvider.SIZE) {
                    if (att.getBinding() != null && String.class.equals(att.getBinding())) {
                        return new Label(id, (Serializable)((Object)String.valueOf(att.getSize())));
                    }
                    return new Label(id, (Serializable)((Object)""));
                }
                if (property == AttributesProvider.UPDOWN) {
                    return NewFeatureTypePage.this.upDownFragment(id, att);
                }
                return null;
            }
        };
        this.attributeTable.setSortable(false);
        this.attributeTable.setFilterable(false);
        this.attributeTable.getBottomPager().setVisible(false);
        this.form.add(new Component[]{this.attributeTable});
        SubmitLink saveLink = this.saveLink();
        this.form.add(new Component[]{saveLink});
        this.form.setDefaultButton((IFormSubmittingComponent)saveLink);
        this.form.add(new Component[]{this.cancelLink()});
        this.setHeaderPanel(this.headerPanel());
    }

    private SubmitLink saveLink() {
        return new SubmitLink("save"){

            public void onSubmit() {
                DataStore ds = null;
                DataStoreInfo dsInfo = null;
                try {
                    dsInfo = NewFeatureTypePage.this.getCatalog().getDataStore(NewFeatureTypePage.this.storeId);
                    ds = (DataStore)dsInfo.getDataStore(null);
                    if (Arrays.asList(ds.getTypeNames()).contains(NewFeatureTypePage.this.name)) {
                        this.error((Serializable)((Object)new ParamResourceModel("duplicateTypeName", (Component)this, dsInfo.getName(), NewFeatureTypePage.this.name).getString()));
                        return;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (NewFeatureTypePage.this.attributesProvider.getAttributes().size() == 0) {
                    this.error((Serializable)((Object)new ParamResourceModel("noAttributes", (Component)this, new Object[0]).getString()));
                    return;
                }
                try {
                    SimpleFeatureType featureType = NewFeatureTypePage.this.buildFeatureType();
                    ds.createSchema((FeatureType)featureType);
                    CatalogBuilder builder = new CatalogBuilder(NewFeatureTypePage.this.getCatalog());
                    builder.setStore((StoreInfo)dsInfo);
                    FeatureTypeInfo fti = builder.buildFeatureType(NewFeatureTypePage.this.getFeatureSource(ds));
                    LayerInfo layerInfo = builder.buildLayer(fti);
                    this.setResponsePage((IRequestablePage)new ResourceConfigurationPage(layerInfo, true));
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Failed to create feature type", e);
                    this.error((Serializable)((Object)new ParamResourceModel("creationFailure", (Component)this, e.getMessage()).getString()));
                }
            }
        };
    }

    FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(DataStore ds) throws IOException {
        try {
            return ds.getFeatureSource(this.name);
        }
        catch (IOException e) {
            try {
                return ds.getFeatureSource(this.name.toUpperCase());
            }
            catch (Exception ora) {
                throw e;
            }
        }
    }

    SimpleFeatureType buildFeatureType() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        for (AttributeDescription att : this.attributesProvider.getAttributes()) {
            if (att.getSize() > 0) {
                builder.length(att.getSize());
            }
            if (Geometry.class.isAssignableFrom(att.getBinding())) {
                builder.add(att.getName(), att.getBinding(), att.getCrs());
                continue;
            }
            builder.add(att.getName(), att.getBinding());
        }
        builder.setName(this.name);
        return builder.buildFeatureType();
    }

    private Link<Void> cancelLink() {
        return new Link<Void>("cancel"){

            public void onClick() {
                NewFeatureTypePage.this.doReturn(NewLayerPage.class);
            }
        };
    }

    Component editAttributeLink(final IModel<AttributeDescription> itemModel) {
        GeoServerAjaxFormLink link = new GeoServerAjaxFormLink("link"){

            @Override
            protected void onClick(AjaxRequestTarget target, Form<?> form) {
                AttributeDescription attribute = (AttributeDescription)itemModel.getObject();
                this.setResponsePage((IRequestablePage)new AttributeEditPage(attribute, NewFeatureTypePage.this));
            }
        };
        link.add(new Component[]{new Label("name", (IModel)new PropertyModel(itemModel, "name"))});
        return link;
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add(new Component[]{new GeoServerAjaxFormLink("addNew", this.form){

            @Override
            public void onClick(AjaxRequestTarget target, Form<?> form) {
                AttributeDescription attribute = new AttributeDescription();
                this.setResponsePage((IRequestablePage)new AttributeNewPage(attribute, NewFeatureTypePage.this));
            }
        }});
        header.add(new Component[]{new GeoServerAjaxFormLink("removeSelected", this.form){

            @Override
            public void onClick(AjaxRequestTarget target, Form<?> form) {
                NewFeatureTypePage.this.attributesProvider.removeAll(NewFeatureTypePage.this.attributeTable.getSelection());
                NewFeatureTypePage.this.attributeTable.clearSelection();
                target.add(new Component[]{form});
            }
        }});
        return header;
    }

    protected Component upDownFragment(String id, final AttributeDescription attribute) {
        Fragment upDown = new Fragment(id, "upDown", (MarkupContainer)this);
        if (this.attributesProvider.isFirst(attribute)) {
            upDown.add(new Component[]{new PlaceholderLink("up")});
        } else {
            ImageAjaxLink<Void> upLink = new ImageAjaxLink<Void>("up", new PackageResourceReference(((Object)((Object)this)).getClass(), "../../img/icons/silk/arrow_up.png")){

                @Override
                protected void onClick(AjaxRequestTarget target) {
                    NewFeatureTypePage.this.attributesProvider.moveUp(attribute);
                    target.add(new Component[]{NewFeatureTypePage.this.form});
                }
            };
            upDown.add(new Component[]{upLink});
        }
        if (this.attributesProvider.isLast(attribute)) {
            upDown.add(new Component[]{new PlaceholderLink("down")});
        } else {
            ImageAjaxLink<Void> downLink = new ImageAjaxLink<Void>("down", new PackageResourceReference(((Object)((Object)this)).getClass(), "../../img/icons/silk/arrow_down.png")){

                @Override
                protected void onClick(AjaxRequestTarget target) {
                    NewFeatureTypePage.this.attributesProvider.moveDown(attribute);
                    target.add(new Component[]{NewFeatureTypePage.this.form});
                }
            };
            upDown.add(new Component[]{downLink});
        }
        return upDown;
    }

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }

    class PlaceholderLink
    extends ImageAjaxLink<Void> {
        public PlaceholderLink(String id) {
            super(id, new PackageResourceReference(NewFeatureTypePage.class, "../../img/icons/blank.png"));
            this.setEnabled(false);
        }

        @Override
        protected void onClick(AjaxRequestTarget target) {
        }
    }
}

