/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.SelectionRemovalLink;
import org.geoserver.web.data.layer.LayerProvider;
import org.geoserver.web.data.layer.NewLayerPage;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.data.store.CoverageStoreEditPage;
import org.geoserver.web.data.store.DataAccessEditPage;
import org.geoserver.web.data.store.WMSStoreEditPage;
import org.geoserver.web.data.store.WMTSStoreEditPage;
import org.geoserver.web.wicket.DateTimeLabel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.SimpleBookmarkableLink;

public class LayerPage
extends GeoServerSecuredPage {
    LayerProvider provider = new LayerProvider();
    GeoServerTablePanel<LayerInfo> table;
    GeoServerDialog dialog;
    SelectionRemovalLink removal;

    public LayerPage() {
        final CatalogIconFactory icons = CatalogIconFactory.get();
        this.table = new GeoServerTablePanel<LayerInfo>("table", (GeoServerDataProvider)this.provider, true){

            @Override
            protected Component getComponentForProperty(String id, IModel<LayerInfo> itemModel, GeoServerDataProvider.Property<LayerInfo> property) {
                if (property == LayerProvider.TYPE) {
                    Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)LayerPage.this);
                    f.add(new Component[]{new Image("layerIcon", (ResourceReference)icons.getSpecificLayerIcon((LayerInfo)itemModel.getObject()), new ResourceReference[0])});
                    return f;
                }
                if (property == LayerProvider.STORE) {
                    return LayerPage.this.storeLink(id, (IModel<LayerInfo>)itemModel);
                }
                if (property == LayerProvider.NAME) {
                    return LayerPage.this.layerLink(id, (IModel<LayerInfo>)itemModel);
                }
                if (property == LayerProvider.ENABLED) {
                    LayerInfo layerInfo = (LayerInfo)itemModel.getObject();
                    boolean enabled = layerInfo.enabled();
                    PackageResourceReference icon = enabled ? icons.getEnabledIcon() : icons.getDisabledIcon();
                    Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)LayerPage.this);
                    f.add(new Component[]{new Image("layerIcon", (ResourceReference)icon, new ResourceReference[0])});
                    return f;
                }
                if (property == LayerProvider.SRS) {
                    return new Label(id, LayerProvider.SRS.getModel(itemModel));
                }
                if (property == LayerProvider.TITLE) {
                    return LayerPage.this.titleLink(id, (IModel<LayerInfo>)itemModel);
                }
                if (property == LayerProvider.MODIFIED_TIMESTAMP) {
                    return new DateTimeLabel(id, LayerProvider.MODIFIED_TIMESTAMP.getModel(itemModel));
                }
                if (property == LayerProvider.CREATED_TIMESTAMP) {
                    return new DateTimeLabel(id, LayerProvider.CREATED_TIMESTAMP.getModel(itemModel));
                }
                throw new IllegalArgumentException("Don't know a property named " + property.getName());
            }

            @Override
            protected void onSelectionUpdate(AjaxRequestTarget target) {
                LayerPage.this.removal.setEnabled(LayerPage.this.table.getSelection().size() > 0);
                target.add(new Component[]{LayerPage.this.removal});
            }
        };
        this.table.setOutputMarkupId(true);
        this.add(new Component[]{this.table});
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        this.setHeaderPanel(this.headerPanel());
    }

    private Component titleLink(String id, IModel<LayerInfo> itemModel) {
        IModel<?> layerNameModel = LayerProvider.NAME.getModel(itemModel);
        IModel<?> layerTitleModel = LayerProvider.TITLE.getModel(itemModel);
        String layerTitle = (String)layerTitleModel.getObject();
        String layerName = (String)layerNameModel.getObject();
        String wsName = this.getWorkspaceNameFromLayerInfo((LayerInfo)itemModel.getObject());
        IModel<?> linkModel = layerTitleModel;
        if (StringUtils.isEmpty((CharSequence)layerTitle)) {
            linkModel = layerNameModel;
        }
        return new SimpleBookmarkableLink(id, ResourceConfigurationPage.class, linkModel, "name", layerName, "wsName", wsName);
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add(new Component[]{new BookmarkablePageLink("addNew", NewLayerPage.class)});
        Component[] componentArray = new Component[1];
        this.removal = new SelectionRemovalLink("removeSelected", this.table, this.dialog);
        componentArray[0] = this.removal;
        header.add(componentArray);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(false);
        return header;
    }

    private Component layerLink(String id, IModel<LayerInfo> model) {
        IModel<?> layerNameModel = LayerProvider.NAME.getModel(model);
        String wsName = this.getWorkspaceNameFromLayerInfo((LayerInfo)model.getObject());
        String layerName = (String)layerNameModel.getObject();
        String linkTitle = wsName + ":" + layerName;
        return new SimpleBookmarkableLink(id, ResourceConfigurationPage.class, (IModel<?>)new Model((Serializable)((Object)linkTitle)), "name", layerName, "wsName", wsName);
    }

    private Component storeLink(String id, IModel<LayerInfo> model) {
        IModel<?> storeModel = LayerProvider.STORE.getModel(model);
        String wsName = this.getWorkspaceNameFromLayerInfo((LayerInfo)model.getObject());
        String storeName = (String)storeModel.getObject();
        LayerInfo layer = (LayerInfo)model.getObject();
        StoreInfo store = layer.getResource().getStore();
        if (store instanceof DataStoreInfo) {
            return new SimpleBookmarkableLink(id, DataAccessEditPage.class, storeModel, "storeName", storeName, "wsName", wsName);
        }
        if (store instanceof WMTSStoreInfo) {
            return new SimpleBookmarkableLink(id, WMTSStoreEditPage.class, storeModel, "storeName", storeName, "wsName", wsName);
        }
        if (store instanceof WMSStoreInfo) {
            return new SimpleBookmarkableLink(id, WMSStoreEditPage.class, storeModel, "storeName", storeName, "wsName", wsName);
        }
        return new SimpleBookmarkableLink(id, CoverageStoreEditPage.class, storeModel, "storeName", storeName, "wsName", wsName);
    }

    private String getWorkspaceNameFromLayerInfo(LayerInfo li) {
        return li.getResource().getStore().getWorkspace().getName();
    }

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }
}

