/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import it.geosolutions.jaiext.JAIExt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.EnumChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.ListMultipleChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.CoverageView;

public class CoverageViewEditor
extends FormComponentPanel<List<String>> {
    IModel<List<String>> coverages;
    IModel<List<CoverageView.CoverageBand>> outputBands;
    List<String> availableCoverages;
    List<CoverageView.CoverageBand> currentOutputBands;
    ListMultipleChoice<String> coveragesChoice;
    CoverageView.CompositionType compositionType;
    IModel<CoverageView.EnvelopeCompositionType> envelopeCompositionType;
    IModel<CoverageView.SelectedResolution> selectedResolution;
    IModel<String> resolutionReferenceCoverage;
    ListMultipleChoice<CoverageView.CoverageBand> outputBandsChoice;
    TextField<String> definition;
    DropDownChoice<CoverageView.CompositionType> compositionChoice;

    public CoverageViewEditor(String id, IModel<List<String>> inputCoverages, IModel<List<CoverageView.CoverageBand>> bands, IModel<CoverageView.EnvelopeCompositionType> envelopeCompositionType, IModel<CoverageView.SelectedResolution> selectedResolution, IModel<String> resolutionReferenceCoverage, List<String> availableCoverages) {
        super(id, inputCoverages);
        this.coverages = inputCoverages;
        this.outputBands = bands;
        this.envelopeCompositionType = envelopeCompositionType;
        this.selectedResolution = selectedResolution;
        this.resolutionReferenceCoverage = resolutionReferenceCoverage;
        this.availableCoverages = availableCoverages;
        this.coveragesChoice = new ListMultipleChoice("coveragesChoice", (IModel)new Model(), new ArrayList((Collection)this.coverages.getObject()), (IChoiceRenderer)new ChoiceRenderer<String>(){

            public Object getDisplayValue(String coverage) {
                return coverage;
            }
        });
        this.coveragesChoice.setOutputMarkupId(true);
        this.add(new Component[]{this.coveragesChoice});
        new ArrayList();
        this.outputBandsChoice = new ListMultipleChoice("outputBandsChoice", (IModel)new Model(), new ArrayList((Collection)this.outputBands.getObject()), (IChoiceRenderer)new ChoiceRenderer<CoverageView.CoverageBand>(){

            public Object getDisplayValue(CoverageView.CoverageBand vcb) {
                return vcb.getDefinition();
            }
        });
        this.outputBandsChoice.setOutputMarkupId(true);
        this.add(new Component[]{this.outputBandsChoice});
        this.currentOutputBands = new ArrayList<CoverageView.CoverageBand>(this.outputBandsChoice.getChoices());
        this.add(new Component[]{this.addBandButton()});
        this.definition = new TextField("definition", (IModel)new Model());
        this.definition.setOutputMarkupId(true);
        this.definition.setEnabled(false);
        this.compositionType = CoverageView.CompositionType.getDefault();
        this.compositionChoice = new DropDownChoice("compositionType", (IModel)new PropertyModel((Object)this, "compositionType"), Arrays.asList(CoverageView.CompositionType.BAND_SELECT), (IChoiceRenderer)new CompositionTypeRenderer());
        this.compositionChoice.setOutputMarkupId(true);
        this.compositionChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                CoverageViewEditor.this.compositionType = (CoverageView.CompositionType)CoverageViewEditor.this.compositionChoice.getModelObject();
            }
        }});
        WebMarkupContainer heterogeneousControlsContainer = new WebMarkupContainer("heterogeneousControlsContainer");
        heterogeneousControlsContainer.setOutputMarkupId(true);
        this.add(new Component[]{heterogeneousControlsContainer});
        WebMarkupContainer heterogeneousControls = new WebMarkupContainer("heterogeneousControls");
        heterogeneousControlsContainer.add(new Component[]{heterogeneousControls});
        heterogeneousControls.setVisible(JAIExt.isJAIExtOperation((String)"BandMerge"));
        DropDownChoice envelopePolicy = new DropDownChoice("envelopeCompositionType", Arrays.asList(CoverageView.EnvelopeCompositionType.values()));
        envelopePolicy.setModel(envelopeCompositionType);
        envelopePolicy.setChoiceRenderer((IChoiceRenderer)new EnumChoiceRenderer((Component)this));
        heterogeneousControls.add(new Component[]{envelopePolicy});
        DropDownChoice resolutionPolicy = new DropDownChoice("selectedResolution", Arrays.asList(CoverageView.SelectedResolution.values()));
        resolutionPolicy.setModel(selectedResolution);
        resolutionPolicy.setChoiceRenderer((IChoiceRenderer)new EnumChoiceRenderer((Component)this));
        heterogeneousControls.add(new Component[]{resolutionPolicy});
        this.add(new Component[]{this.addRemoveAllButton()});
        this.add(new Component[]{this.addRemoveButton()});
    }

    private AjaxButton addBandButton() {
        AjaxButton button = new AjaxButton("addBand"){

            public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                List selection = (List)CoverageViewEditor.this.coveragesChoice.getModelObject();
                CoverageViewEditor.this.compositionType = (CoverageView.CompositionType)CoverageViewEditor.this.compositionChoice.getModelObject();
                ArrayList<CoverageView.CoverageBand> bandsList = new ArrayList<CoverageView.CoverageBand>();
                int i = CoverageViewEditor.this.currentOutputBands.size();
                for (String coverage : selection) {
                    int bandIndexChar = coverage.indexOf("@");
                    String coverageName = coverage;
                    String bandIndex = null;
                    if (bandIndexChar != -1) {
                        coverageName = coverage.substring(0, bandIndexChar);
                        bandIndex = coverage.substring(bandIndexChar + 1);
                    }
                    CoverageView.CoverageBand band = new CoverageView.CoverageBand(Collections.singletonList(new CoverageView.InputCoverageBand(coverageName, bandIndex)), coverage, i++, CoverageViewEditor.this.compositionType);
                    bandsList.add(band);
                }
                CoverageViewEditor.this.currentOutputBands.addAll(bandsList);
                CoverageViewEditor.this.outputBandsChoice.setChoices(CoverageViewEditor.this.currentOutputBands);
                CoverageViewEditor.this.outputBandsChoice.modelChanged();
                CoverageViewEditor.this.coveragesChoice.setChoices(CoverageViewEditor.this.availableCoverages);
                CoverageViewEditor.this.coveragesChoice.modelChanged();
                target.add(new Component[]{CoverageViewEditor.this.coveragesChoice});
                target.add(new Component[]{CoverageViewEditor.this.outputBandsChoice});
            }
        };
        return button;
    }

    private AjaxButton addRemoveAllButton() {
        AjaxButton button = new AjaxButton("removeAllBands"){

            public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                List outputBands = (List)CoverageViewEditor.this.outputBandsChoice.getModelObject();
                outputBands.clear();
                CoverageViewEditor.this.currentOutputBands.clear();
                CoverageViewEditor.this.outputBandsChoice.setChoices(CoverageViewEditor.this.currentOutputBands);
                CoverageViewEditor.this.outputBandsChoice.modelChanged();
                target.add(new Component[]{CoverageViewEditor.this.outputBandsChoice});
            }
        };
        return button;
    }

    private AjaxButton addRemoveButton() {
        AjaxButton button = new AjaxButton("removeBands"){

            public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                List removedBands = (List)CoverageViewEditor.this.outputBandsChoice.getModel().getObject();
                for (Object band : removedBands) {
                    CoverageViewEditor.this.currentOutputBands.remove(band);
                }
                CoverageViewEditor.this.outputBandsChoice.setChoices(CoverageViewEditor.this.currentOutputBands);
                CoverageViewEditor.this.outputBandsChoice.modelChanged();
                target.add(new Component[]{CoverageViewEditor.this.outputBandsChoice});
            }
        };
        return button;
    }

    private class CompositionTypeRenderer
    extends ChoiceRenderer<CoverageView.CompositionType> {
        private CompositionTypeRenderer() {
        }

        public Object getDisplayValue(CoverageView.CompositionType object) {
            return object.displayValue();
        }

        public String getIdValue(CoverageView.CompositionType object, int index) {
            return object.toValue();
        }
    }
}

