/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs20.ParameterExpressionType;
import net.opengis.wfs20.StoredQueryDescriptionType;
import net.opengis.wfs20.StoredQueryListItemType;
import net.opengis.wfs20.TitleType;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geotools.data.DataAccess;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterMappingBlockValue;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterMappingDefaultValue;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterMappingExpressionValue;
import org.geotools.data.wfs.internal.v2_0.storedquery.StoredQueryConfiguration;
import org.geotools.util.decorate.Wrapper;
import org.geotools.util.logging.Logging;

public abstract class CascadedWFSStoredQueryAbstractPage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = 3805287974674434336L;
    static final Logger LOGGER = Logging.getLogger(CascadedWFSStoredQueryAbstractPage.class);
    public static final String DATASTORE = "storeName";
    public static final String WORKSPACE = "wsName";
    String storeId;
    GeoServerTablePanel<StoredQueryParameterAttribute> parameters;
    StoredQueryParameterAttributeProvider parameterProvider;
    public static GeoServerDataProvider.Property<StoredQueryParameterAttribute> ATTR_NAME = new GeoServerDataProvider.BeanProperty<StoredQueryParameterAttribute>("parameterName", "parameterName");
    public static GeoServerDataProvider.Property<StoredQueryParameterAttribute> ATTR_TITLE = new GeoServerDataProvider.BeanProperty<StoredQueryParameterAttribute>("title", "title");
    public static GeoServerDataProvider.Property<StoredQueryParameterAttribute> ATTR_TYPE = new GeoServerDataProvider.BeanProperty<StoredQueryParameterAttribute>("type", "type");
    public static GeoServerDataProvider.Property<StoredQueryParameterAttribute> ATTR_MAPTYPE = new GeoServerDataProvider.BeanProperty<StoredQueryParameterAttribute>("mappingType", "mappingType");
    public static GeoServerDataProvider.Property<StoredQueryParameterAttribute> ATTR_VALUE = new GeoServerDataProvider.BeanProperty<StoredQueryParameterAttribute>("value", "value");

    public CascadedWFSStoredQueryAbstractPage(PageParameters params) throws IOException {
        this(params.get(WORKSPACE).toOptionalString(), params.get(DATASTORE).toString(), null);
    }

    public CascadedWFSStoredQueryAbstractPage(String workspaceName, String storeName, String typeName) throws IOException {
        this.storeId = ((DataStoreInfo)this.getCatalog().getStoreByName(workspaceName, storeName, DataStoreInfo.class)).getId();
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)this));
        form.add(new Component[]{this.getStoredQueryNameComponent()});
        this.parameterProvider = new StoredQueryParameterAttributeProvider();
        this.parameters = new GeoServerTablePanel<StoredQueryParameterAttribute>("parameters", (GeoServerDataProvider)this.parameterProvider){
            private static final long serialVersionUID = 8282438267732625198L;

            @Override
            protected Component getComponentForProperty(String id, IModel<StoredQueryParameterAttribute> itemModel, GeoServerDataProvider.Property<StoredQueryParameterAttribute> property) {
                if (property == ATTR_MAPTYPE) {
                    Fragment f = new Fragment(id, "parameterMappingType", (MarkupContainer)CascadedWFSStoredQueryAbstractPage.this);
                    ArrayList<ParameterMappingType> choices = new ArrayList<ParameterMappingType>();
                    for (ParameterMappingType pmt : ParameterMappingType.values()) {
                        choices.add(pmt);
                    }
                    DropDownChoice choice = new DropDownChoice("dropdown", (IModel)new PropertyModel(itemModel, "mappingType"), choices, (IChoiceRenderer)new ParameterMappingTypeRenderer());
                    f.add(new Component[]{choice});
                    return f;
                }
                if (property == ATTR_VALUE) {
                    Fragment f = new Fragment(id, "parameterMappingValue", (MarkupContainer)CascadedWFSStoredQueryAbstractPage.this);
                    TextField textField = new TextField("text", (IModel)new PropertyModel(itemModel, "value"));
                    f.add(new Component[]{textField});
                    return f;
                }
                return null;
            }
        };
        this.parameters.setFilterVisible(false);
        this.parameters.setSortable(false);
        this.parameters.setPageable(false);
        this.parameters.setOutputMarkupId(true);
        form.add(new Component[]{this.parameters});
        this.add(new Component[]{form});
        form.add(new Component[]{new SubmitLink("save"){
            private static final long serialVersionUID = 2540349398885832870L;

            public void onSubmit() {
                CascadedWFSStoredQueryAbstractPage.this.onSave();
            }
        }});
        form.add(new Component[]{new Link<Void>("cancel"){
            private static final long serialVersionUID = 451678049485016709L;

            public void onClick() {
                CascadedWFSStoredQueryAbstractPage.this.onCancel();
            }
        }});
    }

    static StoredQueryConfiguration createStoredQueryConfiguration(List<StoredQueryParameterAttribute> items, String storedQueryId) {
        StoredQueryConfiguration ret = new StoredQueryConfiguration();
        ret.setStoredQueryId(storedQueryId);
        for (StoredQueryParameterAttribute i : items) {
            ParameterMappingBlockValue mapping;
            String name = i.getParameterName();
            switch (i.getMappingType()) {
                case BLOCKED: {
                    mapping = new ParameterMappingBlockValue(name);
                    break;
                }
                case DEFAULT: {
                    mapping = new ParameterMappingDefaultValue(name, false, i.getValue());
                    break;
                }
                case STATIC: {
                    mapping = new ParameterMappingDefaultValue(name, true, i.getValue());
                    break;
                }
                case EXPRESSION_CQL: {
                    mapping = new ParameterMappingExpressionValue(name, "CQL", i.getValue());
                    break;
                }
                default: {
                    mapping = null;
                }
            }
            if (mapping == null) continue;
            ret.getStoredQueryParameterMappings().add(mapping);
        }
        return ret;
    }

    protected List<StoredQueryListItemType> listStoredQueries() {
        try {
            WFSDataStore contentStore = this.getContentDataStore();
            return contentStore.getStoredQueryListResponse().getStoredQuery();
        }
        catch (IOException ie) {
            throw new RuntimeException("Uanble to list stored queries", ie);
        }
    }

    protected WFSDataStore getContentDataStore() throws IOException {
        DataStoreInfo store = (DataStoreInfo)this.getCatalog().getStore(this.storeId, DataStoreInfo.class);
        DataAccess da = store.getDataStore(null);
        if (da instanceof Wrapper) {
            try {
                da = (DataAccess)((Wrapper)da).unwrap(DataAccess.class);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
        }
        return (WFSDataStore)da;
    }

    public static String createStoredQueryTitle(StoredQueryListItemType object) {
        StringBuilder ret = new StringBuilder();
        TitleType title = null;
        for (TitleType t : object.getTitle()) {
            if (title == null) {
                title = t;
                continue;
            }
            if (title.getValue() != null && title.getValue().length() != 0) continue;
            title = t;
        }
        if (title != null) {
            ret.append(title.getValue()).append(" (").append(object.getId()).append(")");
        } else {
            ret.append(object.getId());
        }
        return ret.toString();
    }

    public StoredQueryParameterAttribute createStoredQueryParameterAttribute(String storedQueryId, ParameterExpressionType pet) {
        StoredQueryParameterAttribute ret = new StoredQueryParameterAttribute();
        ret.setParameterName(pet.getName());
        ret.setType(pet.getType());
        StringBuilder title = new StringBuilder();
        for (TitleType t : pet.getTitle()) {
            if (t.getValue() == null || t.getValue().length() <= 0) continue;
            title.append(t.getValue());
            break;
        }
        ret.setTitle(title.toString());
        this.populateStoredQueryParameterAttribute(storedQueryId, pet, ret);
        return ret;
    }

    public abstract void populateStoredQueryParameterAttribute(String var1, ParameterExpressionType var2, StoredQueryParameterAttribute var3);

    protected abstract Component getStoredQueryNameComponent();

    protected abstract void onSave();

    protected abstract void onCancel();

    public class StoredQueryParameterAttributeProvider
    extends GeoServerDataProvider<StoredQueryParameterAttribute> {
        private static final long serialVersionUID = 5295091510256421604L;
        private List<StoredQueryParameterAttribute> items = new ArrayList<StoredQueryParameterAttribute>();

        public void refreshItems(String storedQueryId) {
            this.items.clear();
            if (storedQueryId != null) {
                StoredQueryDescriptionType desc;
                try {
                    WFSDataStore contentStore = CascadedWFSStoredQueryAbstractPage.this.getContentDataStore();
                    desc = contentStore.getStoredQueryDescriptionType(storedQueryId);
                }
                catch (IOException ie) {
                    throw new RuntimeException("Unable to describe stored query", ie);
                }
                for (ParameterExpressionType pet : desc.getParameter()) {
                    this.items.add(CascadedWFSStoredQueryAbstractPage.this.createStoredQueryParameterAttribute(storedQueryId, pet));
                }
            }
        }

        @Override
        protected List<StoredQueryParameterAttribute> getItems() {
            return this.items;
        }

        @Override
        protected List<GeoServerDataProvider.Property<StoredQueryParameterAttribute>> getProperties() {
            return Arrays.asList(ATTR_NAME, ATTR_TITLE, ATTR_TYPE, ATTR_MAPTYPE, ATTR_VALUE);
        }
    }

    public class ParameterMappingTypeRenderer
    extends ChoiceRenderer<ParameterMappingType> {
        private static final long serialVersionUID = 1875427995762137069L;

        public Object getDisplayValue(ParameterMappingType object) {
            return new StringResourceModel("ParameterMappingType." + object.toString(), (Component)CascadedWFSStoredQueryAbstractPage.this, null).getString();
        }

        public String getIdValue(ParameterMappingType object, int index) {
            return object.toString();
        }
    }

    public static enum ParameterMappingType {
        NONE,
        STATIC,
        DEFAULT,
        EXPRESSION_CQL,
        BLOCKED;

    }

    public class StoredQueryParameterAttribute
    implements Serializable {
        private static final long serialVersionUID = -9213562985695412130L;
        private String parameterName;
        private String title;
        private QName type;
        private ParameterMappingType mappingType;
        private String value;

        public void setTitle(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public void setType(QName type) {
            this.type = type;
        }

        public QName getType() {
            return this.type;
        }

        public void setMappingType(ParameterMappingType mappingType) {
            this.mappingType = mappingType;
        }

        public ParameterMappingType getMappingType() {
            return this.mappingType;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public int hashCode() {
            int prime = 37;
            int result = 1;
            result = 37 * result + (this.parameterName == null ? 0 : this.parameterName.hashCode());
            result = 37 * result + (this.title == null ? 0 : this.title.hashCode());
            result = 37 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 37 * result + (this.mappingType == null ? 0 : this.mappingType.hashCode());
            result = 37 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        private boolean nullSafeCompare(Object a, Object b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null && b != null) {
                return false;
            }
            return a.equals(b);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StoredQueryParameterAttribute other = (StoredQueryParameterAttribute)obj;
            if (!this.nullSafeCompare(this.parameterName, other.parameterName)) {
                return false;
            }
            if (!this.nullSafeCompare(this.title, other.title)) {
                return false;
            }
            if (!this.nullSafeCompare(this.type, other.type)) {
                return false;
            }
            if (!this.nullSafeCompare((Object)this.mappingType, (Object)other.mappingType)) {
                return false;
            }
            return this.nullSafeCompare(this.value, other.value);
        }

        public String toString() {
            StringBuilder ret = new StringBuilder();
            ret.append(this.getParameterName()).append(": ").append("title=").append(this.title).append(", ").append("type=").append(this.type).append(", ").append("mappingType=").append((Object)this.mappingType).append(", ").append("value=").append(this.value);
            return ret.toString();
        }
    }
}

