/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.importer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.web.data.importer.LayerResource;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geotools.feature.NameImpl;
import org.opengis.feature.type.Name;

public class WMTSLayerProvider
extends GeoServerDataProvider<LayerResource> {
    public static final GeoServerDataProvider.Property<LayerResource> STATUS = new GeoServerDataProvider.BeanProperty<LayerResource>("status", "status");
    public static final GeoServerDataProvider.Property<LayerResource> NAME = new GeoServerDataProvider.BeanProperty<LayerResource>("name", "localName");
    public static final GeoServerDataProvider.Property<LayerResource> ACTION = new GeoServerDataProvider.PropertyPlaceholder<LayerResource>("action");
    public static final List<GeoServerDataProvider.Property<LayerResource>> PROPERTIES = Arrays.asList(NAME, ACTION, STATUS);
    String storeId;
    List<LayerResource> items;

    @Override
    protected List<LayerResource> getItems() {
        if (this.items == null) {
            if (this.storeId == null) {
                return new ArrayList<LayerResource>();
            }
            try {
                StoreInfo store = this.getCatalog().getStore(this.storeId, StoreInfo.class);
                HashMap<String, LayerResource> resources = new HashMap<String, LayerResource>();
                WMTSStoreInfo wmtsInfo = (WMTSStoreInfo)store;
                CatalogBuilder builder = new CatalogBuilder(this.getCatalog());
                builder.setStore(store);
                List layers = wmtsInfo.getWebMapTileServer(null).getCapabilities().getLayerList();
                for (Object l : layers) {
                    if (l.getName() == null) continue;
                    resources.put(l.getName(), new LayerResource((Name)new NameImpl(l.getName())));
                }
                List configuredTypes = this.getCatalog().getResourcesByStore(store, ResourceInfo.class);
                for (ResourceInfo type : configuredTypes) {
                    LayerResource resource = (LayerResource)resources.get(type.getNativeName());
                    if (resource == null) continue;
                    resource.setStatus(LayerResource.LayerStatus.PUBLISHED);
                }
                ArrayList result = new ArrayList(resources.values());
                Collections.sort(result);
                this.items = result;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not list layers for this WMTS store, an error occurred retrieving them: " + e.getMessage(), e);
            }
        }
        return this.items;
    }

    public void updateLayerOrder() {
        Collections.sort(this.items);
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    @Override
    protected List<GeoServerDataProvider.Property<LayerResource>> getProperties() {
        return PROPERTIES;
    }
}

