/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.ConfirmRemovalPanel;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;

public class SelectionRemovalLink
extends AjaxLink<Void> {
    GeoServerTablePanel<? extends CatalogInfo> catalogObjects;
    GeoServerDialog dialog;

    public SelectionRemovalLink(String id, GeoServerTablePanel<? extends CatalogInfo> catalogObjects, GeoServerDialog dialog) {
        super(id);
        this.catalogObjects = catalogObjects;
        this.dialog = dialog;
    }

    public void onClick(AjaxRequestTarget target) {
        final List<? extends CatalogInfo> selection = this.catalogObjects.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        this.dialog.setTitle((IModel<String>)new ParamResourceModel("confirmRemoval", (Component)this, new Object[0]));
        this.dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){

            @Override
            protected Component getContents(String id) {
                return new ConfirmRemovalPanel(id, selection){

                    @Override
                    protected StringResourceModel canRemove(CatalogInfo info) {
                        return SelectionRemovalLink.this.canRemove(info);
                    }
                };
            }

            @Override
            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                Catalog catalog = GeoServerApplication.get().getCatalog();
                CascadeDeleteVisitor visitor = new CascadeDeleteVisitor(catalog);
                for (CatalogInfo ci : selection) {
                    ci.accept((CatalogVisitor)visitor);
                }
                SelectionRemovalLink.this.catalogObjects.clearSelection();
                return true;
            }

            @Override
            public void onClose(AjaxRequestTarget target) {
                if (SelectionRemovalLink.this.catalogObjects.getSelection().size() == 0) {
                    SelectionRemovalLink.this.setEnabled(false);
                    target.add(new Component[]{SelectionRemovalLink.this});
                    target.add(new Component[]{SelectionRemovalLink.this.catalogObjects});
                }
            }
        });
    }

    protected StringResourceModel canRemove(CatalogInfo info) {
        return null;
    }
}

