/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ModuleStatus;
import org.geoserver.platform.ModuleStatusImpl;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.admin.AbstractStatusPage;

public class ModuleStatusPanel
extends Panel {
    private static final long serialVersionUID = 3892224318224575781L;
    final CatalogIconFactory icons = CatalogIconFactory.get();
    ModalWindow popup;
    AjaxLink msgLink;

    public ModuleStatusPanel(String id, AbstractStatusPage parent) {
        super(id);
        this.initUI();
    }

    public void initUI() {
        WebMarkupContainer wmc = new WebMarkupContainer("listViewContainer");
        wmc.setOutputMarkupId(true);
        this.add(new Component[]{wmc});
        this.popup = new ModalWindow("popup");
        this.add(new Component[]{this.popup});
        List applicationStatus = GeoServerExtensions.extensions(ModuleStatus.class).stream().map(ModuleStatusImpl::new).sorted(Comparator.comparing(ModuleStatus::getName)).collect(Collectors.toList());
        ListView<ModuleStatus> moduleView = new ListView<ModuleStatus>("modules", applicationStatus){
            private static final long serialVersionUID = 235576083712961710L;

            protected void populateItem(final ListItem<ModuleStatus> item) {
                item.add(new Component[]{new Label("module", (IModel)new PropertyModel((Object)item.getModel(), "module"))});
                item.add(new Component[]{ModuleStatusPanel.this.getIcons("available", ((ModuleStatus)item.getModelObject()).isAvailable())});
                item.add(new Component[]{ModuleStatusPanel.this.getIcons("enabled", ((ModuleStatus)item.getModelObject()).isEnabled())});
                item.add(new Component[]{new Label("component", (IModel)new Model((Serializable)((Object)((ModuleStatus)item.getModelObject()).getComponent().orElse(""))))});
                item.add(new Component[]{new Label("version", (IModel)new Model((Serializable)((Object)((ModuleStatus)item.getModelObject()).getVersion().orElse(""))))});
                ModuleStatusPanel.this.msgLink = new AjaxLink("msg"){

                    public void onClick(AjaxRequestTarget target) {
                        ModuleStatusPanel.this.popup.setInitialHeight(325);
                        ModuleStatusPanel.this.popup.setInitialWidth(525);
                        ModuleStatusPanel.this.popup.setContent((Component)new MessagePanel(ModuleStatusPanel.this.popup.getContentId(), (ListItem<ModuleStatus>)item));
                        ModuleStatusPanel.this.popup.setTitle("Module Info");
                        ModuleStatusPanel.this.popup.show((IPartialPageRequestHandler)target);
                    }
                };
                ModuleStatusPanel.this.msgLink.setEnabled(true);
                ModuleStatusPanel.this.msgLink.add(new Component[]{new Label("nameLink", (IModel)new PropertyModel((Object)item.getModel(), "name"))});
                item.add(new Component[]{ModuleStatusPanel.this.msgLink});
            }
        };
        wmc.add(new Component[]{moduleView});
    }

    final Fragment getIcons(String id, boolean status) {
        PackageResourceReference icon = status ? this.icons.getEnabledIcon() : this.icons.getDisabledIcon();
        Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)this);
        f.add(new Component[]{new Image("statusIcon", (ResourceReference)icon, new ResourceReference[0])});
        return f;
    }

    class MessagePanel
    extends Panel {
        private static final long serialVersionUID = -3200098674603724915L;

        public MessagePanel(String id, ListItem<ModuleStatus> item) {
            super(id);
            Label name = new Label("name", (IModel)new PropertyModel((Object)item.getModel(), "name"));
            Label module = new Label("module", (IModel)new PropertyModel((Object)item.getModel(), "module"));
            Label component = new Label("component", (IModel)new Model((Serializable)((Object)((ModuleStatus)item.getModelObject()).getComponent().orElse(""))));
            Label version = new Label("version", (IModel)new Model((Serializable)((Object)((ModuleStatus)item.getModelObject()).getVersion().orElse(""))));
            MultiLineLabel msgLabel = new MultiLineLabel("msg", ((ModuleStatus)item.getModelObject()).getMessage().orElse(""));
            this.add(new Component[]{name});
            this.add(new Component[]{module});
            this.add(new Component[]{component});
            this.add(new Component[]{version});
            this.add(new Component[]{msgLabel});
        }
    }
}

