/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import com.sun.media.imageioimpl.common.PackageUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.JAIEXTInfo;
import org.geoserver.config.JAIInfo;
import org.geoserver.web.GeoserverAjaxSubmitLink;
import org.geoserver.web.admin.JAIEXTPanel;
import org.geoserver.web.admin.ServerAdminPage;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.PercentageTextField;
import org.geotools.image.ImageWorker;

public class JAIPage
extends ServerAdminPage {
    private static final long serialVersionUID = -1184717232184497578L;
    private final IModel<GeoServer> geoServerModel = this.getGeoServerModel();
    private final IModel<JAIInfo> jaiModel = this.getJAIModel();

    public JAIPage() {
        Form form = new Form("form", (IModel)new CompoundPropertyModel(this.jaiModel));
        this.add(new Component[]{form});
        RangeValidator percentageValidator = RangeValidator.range((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0));
        PercentageTextField memoryCapacity = new PercentageTextField("memoryCapacity");
        memoryCapacity.add((IValidator)percentageValidator);
        form.add(new Component[]{memoryCapacity});
        PercentageTextField memoryThreshold = new PercentageTextField("memoryThreshold");
        memoryThreshold.add((IValidator)percentageValidator);
        form.add(new Component[]{memoryThreshold});
        TextField tileThreads = new TextField("tileThreads");
        tileThreads.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{tileThreads});
        TextField tilePriority = new TextField("tilePriority");
        tilePriority.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{tilePriority});
        form.add(new Component[]{new CheckBox("recycling")});
        form.add(new Component[]{new CheckBox("jpegAcceleration")});
        this.addPngEncoderEditor((Form<JAIInfo>)form);
        CheckBox checkBoxMosaic = new CheckBox("allowNativeMosaic");
        CheckBox checkBoxWarp = new CheckBox("allowNativeWarp");
        JAIInfo info = (JAIInfo)this.jaiModel.getObject();
        JAIEXTInfo je = null;
        boolean isJAIExtEnabled = ImageWorker.isJaiExtEnabled();
        if (isJAIExtEnabled) {
            je = info.getJAIEXTInfo();
        }
        boolean mosaicEnabled = je != null && !je.getJAIEXTOperations().contains("Mosaic");
        boolean warpEnabled = je != null && !je.getJAIEXTOperations().contains("Warp");
        checkBoxMosaic.setEnabled(mosaicEnabled);
        checkBoxWarp.setEnabled(warpEnabled);
        form.add(new Component[]{checkBoxMosaic});
        form.add(new Component[]{checkBoxWarp});
        JAIEXTPanel jaiExtPanel = new JAIEXTPanel("jaiext", this.jaiModel);
        if (!isJAIExtEnabled) {
            jaiExtPanel.setVisible(false);
        }
        form.add(new Component[]{jaiExtPanel});
        Button submit = new Button("submit"){
            private static final long serialVersionUID = -2842881187264147131L;

            public void onSubmit() {
                JAIPage.this.save(true);
            }
        };
        form.add(new Component[]{submit});
        form.add(new Component[]{this.applyLink(form)});
        Button cancel = new Button("cancel"){
            private static final long serialVersionUID = 7917847596581898225L;

            public void onSubmit() {
                JAIPage.this.doReturn();
            }
        };
        form.add(new Component[]{cancel});
    }

    private void save(boolean doReturn) {
        GeoServer gs = (GeoServer)this.geoServerModel.getObject();
        GeoServerInfo global = gs.getGlobal();
        global.setJAI((JAIInfo)this.jaiModel.getObject());
        gs.save(global);
        if (doReturn) {
            this.doReturn();
        }
    }

    private GeoserverAjaxSubmitLink applyLink(Form form) {
        return new GeoserverAjaxSubmitLink("apply", form, this){

            protected void onError(AjaxRequestTarget target, Form form) {
                super.onError(target, form);
                target.add(new Component[]{form});
            }

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target, Form<?> form) {
                try {
                    JAIPage.this.save(false);
                }
                catch (IllegalArgumentException e) {
                    form.error((Serializable)((Object)e.getMessage()));
                    target.add(new Component[]{form});
                }
            }
        };
    }

    private void addPngEncoderEditor(Form<JAIInfo> form) {
        ArrayList<JAIInfo.PngEncoderType> encoders = new ArrayList<JAIInfo.PngEncoderType>(Arrays.asList(JAIInfo.PngEncoderType.values()));
        if (!PackageUtil.isCodecLibAvailable()) {
            encoders.remove(JAIInfo.PngEncoderType.NATIVE);
        }
        DropDownChoice editor = new DropDownChoice("pngEncoderType", encoders, (IChoiceRenderer)new ChoiceRenderer<JAIInfo.PngEncoderType>(){
            private static final long serialVersionUID = 1L;

            public Object getDisplayValue(JAIInfo.PngEncoderType type) {
                return new ParamResourceModel("pngEncoder." + type.name(), (Component)JAIPage.this, new Object[0]).getString();
            }

            public String getIdValue(JAIInfo.PngEncoderType type, int index) {
                return type.name();
            }
        });
        form.add(new Component[]{editor});
        if (!encoders.contains(editor.getModelObject())) {
            editor.setModelObject((Object)JAIInfo.PngEncoderType.PNGJ);
        }
    }
}

