/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.ListChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.config.SettingsInfo;
import org.geoserver.logging.LoggingUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.LockProvider;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoserverAjaxSubmitLink;
import org.geoserver.web.admin.ServerAdminPage;
import org.geoserver.web.data.resource.LocalesDropdown;
import org.geoserver.web.data.settings.SettingsPluginPanelInfo;
import org.geoserver.web.util.MetadataMapModel;
import org.geoserver.web.wicket.LocalizedChoiceRenderer;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.Select2DropDownChoice;
import org.springframework.context.ApplicationContext;

public class GlobalSettingsPage
extends ServerAdminPage {
    private static final long serialVersionUID = 4716657682337915996L;
    public static final ArrayList<String> AVAILABLE_CHARSETS = new ArrayList<String>(Charset.availableCharsets().keySet());
    private final IModel<GeoServerInfo> globalInfoModel = this.getGlobalInfoModel();
    private final IModel<LoggingInfo> loggingInfoModel = this.getLoggingInfoModel();

    public GlobalSettingsPage() {
        CompoundPropertyModel globalModel = new CompoundPropertyModel(this.globalInfoModel);
        PropertyModel settingsModel = new PropertyModel((Object)globalModel, "settings");
        PropertyModel metadataModel = new PropertyModel(this.globalInfoModel, "metadata");
        Form form = new Form("form", (IModel)globalModel);
        this.add(new Component[]{form});
        form.add(new Component[]{new CheckBox("verbose", (IModel)new PropertyModel((Object)settingsModel, "verbose"))});
        form.add(new Component[]{new CheckBox("verboseExceptions", (IModel)new PropertyModel((Object)settingsModel, "verboseExceptions"))});
        form.add(new Component[]{new CheckBox("globalServices")});
        form.add(new Component[]{new TextField("numDecimals", (IModel)new PropertyModel((Object)settingsModel, "numDecimals")).add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)))});
        form.add(new Component[]{new Select2DropDownChoice<String>("charset", (IModel<String>)new PropertyModel((Object)settingsModel, "charset"), (List<String>)AVAILABLE_CHARSETS)});
        form.add(new Component[]{new Select2DropDownChoice<ResourceErrorHandling>("resourceErrorHandling", Arrays.asList(ResourceErrorHandling.values()), (IChoiceRenderer<ResourceErrorHandling>)new ResourceErrorHandlingRenderer())});
        form.add(new Component[]{new TextField("proxyBaseUrl", (IModel)new PropertyModel((Object)settingsModel, "proxyBaseUrl"))});
        form.add(new Component[]{new CheckBox("useHeadersProxyURL")});
        this.logLevelsAppend((Form<GeoServerInfo>)form, this.loggingInfoModel);
        form.add(new Component[]{new CheckBox("stdOutLogging", (IModel)new PropertyModel(this.loggingInfoModel, "stdOutLogging"))});
        form.add(new Component[]{new TextField("loggingLocation", (IModel)new PropertyModel(this.loggingInfoModel, "location"))});
        TextField xmlPostRequestLogBufferSize = new TextField("xmlPostRequestLogBufferSize", (IModel)new PropertyModel(this.globalInfoModel, "xmlPostRequestLogBufferSize"));
        xmlPostRequestLogBufferSize.add(new Behavior[]{RangeValidator.minimum((Comparable)Integer.valueOf(0))});
        form.add(new Component[]{xmlPostRequestLogBufferSize});
        final CheckBox logBodiesCheckBox = new CheckBox("requestLoggingBodies", new MetadataMapModel((IModel<MetadataMap>)metadataModel, "logBodiesEnabled", Boolean.class));
        form.add(new Component[]{logBodiesCheckBox});
        final CheckBox logHeadersCheckBox = new CheckBox("requestLoggingHeaders", new MetadataMapModel((IModel<MetadataMap>)metadataModel, "logHeadersEnabled", Boolean.class));
        final WebMarkupContainer wmc = new WebMarkupContainer("requestLoggingSub");
        wmc.setOutputMarkupId(true);
        wmc.add(new Component[]{logBodiesCheckBox});
        wmc.add(new Component[]{logHeadersCheckBox});
        wmc.add(new Component[]{xmlPostRequestLogBufferSize});
        final MetadataMapModel<Boolean> requestCheckModel = new MetadataMapModel<Boolean>((IModel)metadataModel, "logRequestsEnabled", Boolean.class){

            @Override
            public void setObject(Boolean object) {
                super.setObject(object);
            }
        };
        wmc.setEnabled(Boolean.TRUE.equals(requestCheckModel.getObject()));
        form.add(new Component[]{wmc});
        AjaxCheckBox requestCheckBox = new AjaxCheckBox("requestLogging", requestCheckModel){

            protected void onUpdate(AjaxRequestTarget target) {
                wmc.setEnabled(Boolean.TRUE.equals(requestCheckModel.getObject()));
                logBodiesCheckBox.getModel().setObject((Object)false);
                logHeadersCheckBox.getModel().setObject((Object)false);
                target.add(new Component[]{wmc});
            }
        };
        form.add(new Component[]{requestCheckBox});
        form.add(new Component[]{new CheckBox("xmlExternalEntitiesEnabled")});
        form.add(new Component[]{new TextField("featureTypeCacheSize").add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)))});
        PropertyModel lockProviderModel = new PropertyModel(this.globalInfoModel, "lockProviderName");
        ApplicationContext applicationContext = GeoServerApplication.get().getApplicationContext();
        ArrayList<String> providers = new ArrayList<String>(Arrays.asList(applicationContext.getBeanNamesForType(LockProvider.class)));
        providers.remove("lockProvider");
        Collections.sort(providers);
        Select2DropDownChoice<String> lockProviderChoice = new Select2DropDownChoice<String>("lockProvider", (IModel<String>)lockProviderModel, (List<String>)providers, (IChoiceRenderer<String>)new LocalizedChoiceRenderer((Component)this));
        form.add(new Component[]{lockProviderChoice});
        PropertyModel webUIModeModel = new PropertyModel(this.globalInfoModel, "webUIMode");
        if (webUIModeModel.getObject() == null) {
            webUIModeModel.setObject((Object)GeoServerInfo.WebUIMode.DEFAULT);
        }
        Select2DropDownChoice<GeoServerInfo.WebUIMode> webUIModeChoice = new Select2DropDownChoice<GeoServerInfo.WebUIMode>("webUIMode", (IModel<GeoServerInfo.WebUIMode>)webUIModeModel, Arrays.asList(GeoServerInfo.WebUIMode.values()));
        form.add(new Component[]{webUIModeChoice});
        form.add(new Component[]{new CheckBox("allowStoredQueriesPerWorkspace", (IModel)new PropertyModel(this.globalInfoModel, "allowStoredQueriesPerWorkspace"))});
        ListView<SettingsPluginPanelInfo> extensions = SettingsPluginPanelInfo.createExtensions("extensions", (IModel<SettingsInfo>)settingsModel, this.getGeoServerApplication());
        form.add(new Component[]{extensions});
        form.add(new Component[]{new CheckBox("showCreatedTimeCols", (IModel)new PropertyModel((Object)settingsModel, "showCreatedTimeColumnsInAdminList"))});
        form.add(new Component[]{new CheckBox("showModifiedTimeCols", (IModel)new PropertyModel((Object)settingsModel, "showModifiedTimeColumnsInAdminList"))});
        form.add(new Component[]{new LocalesDropdown("defaultLocale", (IModel<Locale>)new PropertyModel((Object)settingsModel, "defaultLocale"))});
        Button submit = new Button("submit"){

            public void onSubmit() {
                GlobalSettingsPage.this.onSave(true);
            }
        };
        form.add(new Component[]{submit});
        form.add(new Component[]{this.applyLink(form)});
        Button cancel = new Button("cancel"){

            public void onSubmit() {
                GlobalSettingsPage.this.doReturn();
            }
        };
        form.add(new Component[]{cancel});
    }

    private GeoserverAjaxSubmitLink applyLink(Form form) {
        return new GeoserverAjaxSubmitLink("apply", form, this){

            protected void onError(AjaxRequestTarget target, Form form) {
                super.onError(target, form);
                target.add(new Component[]{form});
            }

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target, Form<?> form) {
                try {
                    GlobalSettingsPage.this.onSave(false);
                }
                catch (IllegalArgumentException e) {
                    form.error((Serializable)((Object)e.getMessage()));
                    target.add(new Component[]{form});
                }
            }
        };
    }

    public void onSave(boolean doReturn) {
        GeoServer gs = this.getGeoServer();
        gs.save((GeoServerInfo)this.globalInfoModel.getObject());
        gs.save((LoggingInfo)this.loggingInfoModel.getObject());
        if (doReturn) {
            this.doReturn();
        }
    }

    private void logLevelsAppend(Form<GeoServerInfo> form, IModel<LoggingInfo> loggingInfoModel) {
        String level;
        GeoServerResourceLoader loader = GeoServerApplication.get().getBeanOfType(GeoServerResourceLoader.class);
        List<Object> logProfiles = null;
        try {
            Resource logsDirectory = loader.get("logs");
            if (logsDirectory.getType() == Resource.Type.DIRECTORY) {
                logProfiles = new ArrayList();
                List xmlFiles = Resources.list((Resource)logsDirectory, obj -> obj.name().toLowerCase().endsWith("_logging.xml"));
                for (Resource res : xmlFiles) {
                    logProfiles.add(Paths.sidecar((String)res.name(), null));
                }
                List list = Resources.list((Resource)logsDirectory, obj -> obj.name().toLowerCase().endsWith("_logging.properties"));
                for (Resource res : list) {
                    logProfiles.add(res.name());
                }
                Collections.sort(logProfiles, String.CASE_INSENSITIVE_ORDER);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not load the list of log configurations from the data directory", e);
        }
        if (logProfiles == null || logProfiles.isEmpty()) {
            logProfiles = Arrays.asList(LoggingUtils.STANDARD_LOGGING_CONFIGURATIONS);
        }
        if ((level = ((LoggingInfo)loggingInfoModel.getObject()).getLevel()) != null && !logProfiles.contains(level)) {
            for (String string : logProfiles) {
                if (string.startsWith(level)) {
                    ((LoggingInfo)loggingInfoModel.getObject()).setLevel(string);
                    break;
                }
                if (!string.startsWith(Paths.sidecar((String)level, null))) continue;
                ((LoggingInfo)loggingInfoModel.getObject()).setLevel(string);
                break;
            }
        }
        form.add(new Component[]{new ListChoice("log4jConfigFile", (IModel)new PropertyModel(loggingInfoModel, "level"), logProfiles)});
    }

    class ResourceErrorHandlingRenderer
    extends ChoiceRenderer<ResourceErrorHandling> {
        private static final long serialVersionUID = 4183327535180465575L;

        ResourceErrorHandlingRenderer() {
        }

        public Object getDisplayValue(ResourceErrorHandling object) {
            return new ParamResourceModel(object.name(), (Component)GlobalSettingsPage.this, new Object[0]).getString();
        }

        public String getIdValue(ResourceErrorHandling object, int index) {
            return object.name();
        }

        public ResourceErrorHandling getObject(String id, IModel<? extends List<? extends ResourceErrorHandling>> choices) {
            return id == null || "".equals(id) ? null : ResourceErrorHandling.valueOf((String)id);
        }
    }
}

