/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.tabs.AjaxTabbedPanel;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.extensions.markup.html.tabs.PanelCachingTab;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.admin.ModuleStatusPanel;
import org.geoserver.web.admin.ServerAdminPage;
import org.geoserver.web.admin.StatusPanel;
import org.geoserver.web.system.status.JVMConsolePanel;
import org.geoserver.web.system.status.SystemStatusMonitorPanel;

public abstract class AbstractStatusPage
extends ServerAdminPage {
    private static final long serialVersionUID = -6228795354577370186L;
    protected AjaxTabbedPanel<ITab> tabbedPanel;

    public AbstractStatusPage() {
        this.initUI();
    }

    protected void initUI() {
        ArrayList<PanelCachingTab> tabs = new ArrayList<PanelCachingTab>();
        PanelCachingTab statusTab = new PanelCachingTab((ITab)new AbstractTab((IModel)new Model((Serializable)((Object)"Status"))){
            private static final long serialVersionUID = 9062803783143908814L;

            public Panel getPanel(String id) {
                return new StatusPanel(id, AbstractStatusPage.this);
            }
        });
        PanelCachingTab moduleStatusTab = new PanelCachingTab((ITab)new AbstractTab((IModel)new Model((Serializable)((Object)"Modules"))){
            private static final long serialVersionUID = -5301288750339244612L;

            public Panel getPanel(String id) {
                return new ModuleStatusPanel(id, AbstractStatusPage.this);
            }
        });
        PanelCachingTab systemStatusTab = new PanelCachingTab((ITab)new AbstractTab((IModel)new StringResourceModel("MonitoringPanel.title")){
            private static final long serialVersionUID = -5301288750339244612L;

            public Panel getPanel(String id) {
                return new SystemStatusMonitorPanel(id);
            }
        });
        PanelCachingTab jvmConsoleTab = new PanelCachingTab((ITab)new AbstractTab((IModel)new StringResourceModel("JVMConsolePanel.title")){
            private static final long serialVersionUID = -542587671248411767L;

            public Panel getPanel(String id) {
                return new JVMConsolePanel(id);
            }
        });
        tabs.add(statusTab);
        tabs.add(moduleStatusTab);
        tabs.add(systemStatusTab);
        tabs.add(jvmConsoleTab);
        GeoServerExtensions.extensions(TabDefinition.class).forEach(tabDefinition -> {
            String title = new ResourceModel(tabDefinition.getTitleKey()).getObject();
            PanelCachingTab tab = new PanelCachingTab((ITab)new AbstractTab((IModel)new Model((Serializable)((Object)title)), (TabDefinition)tabDefinition){
                private static final long serialVersionUID = -5301288750339244612L;
                final /* synthetic */ TabDefinition val$tabDefinition;
                {
                    this.val$tabDefinition = tabDefinition;
                    super(x0);
                }

                public Panel getPanel(String panelId) {
                    return this.val$tabDefinition.createPanel(panelId, (Page)AbstractStatusPage.this);
                }
            });
            tabs.add(tab);
        });
        AjaxTabbedPanel tabbedPanel = new AjaxTabbedPanel("tabs", tabs);
        tabbedPanel.get("panel").add(new Behavior[]{new Behavior(){

            public boolean getStatelessHint(Component component) {
                return false;
            }
        }});
        this.add(new Component[]{tabbedPanel});
    }

    @Override
    protected boolean isAuthenticatedAsAdmin() {
        return super.isAuthenticatedAsAdmin();
    }

    @Override
    protected Catalog getCatalog() {
        return super.getCatalog();
    }

    @Override
    protected GeoServerApplication getGeoServerApplication() {
        return super.getGeoServerApplication();
    }

    @Override
    protected GeoServer getGeoServer() {
        return super.getGeoServerApplication().getGeoServer();
    }

    public static interface TabDefinition {
        public String getTitleKey();

        public Panel createPanel(String var1, Page var2);
    }
}

