/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geoserver.web.AdminComponentAuthorizer;
import org.geoserver.web.GeoServerApplication;
import org.springframework.security.core.Authentication;

public class WorkspaceAdminComponentAuthorizer
extends AdminComponentAuthorizer {
    @Override
    public boolean isAccessAllowed(Class<?> componentClass, Authentication authentication) {
        if (super.isAccessAllowed(componentClass, authentication)) {
            return true;
        }
        if (authentication == null || !authentication.isAuthenticated()) {
            return false;
        }
        return this.isWorkspaceAdmin(authentication);
    }

    boolean isWorkspaceAdmin(Authentication authentication) {
        Catalog catalog = this.getSecurityManager().getCatalog();
        SecureCatalogImpl secureCatalog = GeoServerApplication.get().getBeanOfType(SecureCatalogImpl.class);
        ResourceAccessManager manager = secureCatalog.getResourceAccessManager();
        if (manager != null) {
            for (WorkspaceInfo workspace : catalog.getWorkspaces()) {
                WorkspaceAccessLimits accessLimits = manager.getAccessLimits(authentication, workspace);
                if (accessLimits == null || !accessLimits.isAdminable()) continue;
                return true;
            }
        }
        return false;
    }
}

