/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.geoserver.web.ServiceDescription;
import org.geoserver.web.ServiceLinkDescription;
import org.geotools.util.logging.Logging;

public class ServicesPanel
extends Panel {
    private static final long serialVersionUID = 5536322717819915862L;

    public ServicesPanel(String id, List<ServiceDescription> services, List<ServiceLinkDescription> links, final boolean admin) {
        super(id);
        Set<ServiceDescription> serviceSet = this.processServiceLinks(services, links);
        ArrayList<ServiceDescription> serviceList = new ArrayList<ServiceDescription>(serviceSet);
        Collections.sort(serviceList);
        class ServiceListView
        extends ListView<ServiceDescription> {
            public ServiceListView(String id, List<ServiceDescription> list) {
                super(id, list);
            }

            protected void populateItem(ListItem<ServiceDescription> listItem) {
                ServiceDescription service = (ServiceDescription)listItem.getModelObject();
                Locale locale = this.getLocale();
                boolean enabled = service.isAdmin() ? admin : true;
                listItem.add(new Component[]{new Label("title", (Serializable)((Object)service.getTitle().toString(locale))).setEnabled(enabled)});
                listItem.add(new Component[]{new Label("description", (Serializable)((Object)service.getDescription().toString(locale))).setEnabled(enabled)});
                ArrayList<ServiceLinkDescription> links = new ArrayList<ServiceLinkDescription>();
                if (enabled) {
                    links.addAll(service.getLinks());
                    Collections.sort(links);
                }
                class ServiceLinkListView
                extends ListView<ServiceLinkDescription> {
                    public ServiceLinkListView(String id, List<ServiceLinkDescription> list) {
                        super(id, list);
                    }

                    protected void populateItem(ListItem<ServiceLinkDescription> listItem) {
                        ServiceLinkDescription link = (ServiceLinkDescription)listItem.getModelObject();
                        ExternalLink externalLink = new ExternalLink("serviceLink", link.getLink());
                        externalLink.add(new Component[]{new Label("serviceProtocol", (Serializable)((Object)link.getProtocol()))});
                        externalLink.add(new Component[]{new Label("serviceVersion", (Serializable)((Object)link.getVersion().toString()))});
                        listItem.add(new Component[]{externalLink});
                    }
                }
                listItem.add(new Component[]{new ServiceLinkListView("links", links)});
                listItem.setVisible(service.isAvailable() && enabled);
            }
        }
        this.add(new Component[]{new ServiceListView("serviceDescriptions", serviceList)});
    }

    Set<ServiceDescription> processServiceLinks(List<ServiceDescription> services, List<ServiceLinkDescription> links) {
        String serviceName;
        HashMap<String, ServiceDescription> serviceMap = new HashMap<String, ServiceDescription>();
        for (ServiceDescription service : services) {
            serviceName = service.getServiceType();
            serviceMap.put(serviceName, service);
            service.getLinks().clear();
        }
        for (ServiceLinkDescription link : links) {
            serviceName = link.getServiceType();
            if (serviceMap.containsKey(serviceName)) {
                ServiceDescription service = (ServiceDescription)serviceMap.get(serviceName);
                service.getLinks().add(link);
                continue;
            }
            Logger LOGGER = Logging.getLogger(ServicesPanel.class);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Service '" + serviceName + "' created without description to display " + link);
            }
            ServiceDescription service = new ServiceDescription(serviceName);
            serviceMap.put(serviceName, service);
            service.getLinks().add(link);
        }
        return new HashSet<ServiceDescription>(serviceMap.values());
    }
}

