/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.Serializable;
import java.util.Objects;
import org.geotools.util.Version;

public class ServiceLinkDescription
implements Serializable,
Comparable<ServiceLinkDescription> {
    private static final long serialVersionUID = -5600492358023139816L;
    private final String serviceType;
    private final String protocol;
    private final Version version;
    private final String link;
    private final String workspace;
    private final String layer;

    public ServiceLinkDescription(String serviceType, Version version, String link, String workspace, String layer) {
        this(serviceType, version, link, workspace, layer, null);
    }

    public ServiceLinkDescription(String serviceType, Version version, String link, String workspace, String layer, String protocol) {
        this.serviceType = serviceType;
        this.version = version;
        this.link = link;
        this.workspace = workspace;
        this.layer = layer;
        this.protocol = protocol != null ? protocol : this.serviceType;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getLink() {
        return this.link;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String getLayer() {
        return this.layer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceLinkDescription)) {
            return false;
        }
        ServiceLinkDescription that = (ServiceLinkDescription)o;
        return Objects.equals(this.workspace, that.workspace) && Objects.equals(this.layer, that.layer) && this.serviceType.equals(that.serviceType) && this.version.equals((Object)that.version) && Objects.equals(this.link, that.link) && this.protocol.equals(that.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.workspace, this.layer, this.serviceType, this.version, this.link, this.protocol);
    }

    @Override
    public int compareTo(ServiceLinkDescription o) {
        int compareProtocol = this.protocol.compareTo(o.protocol);
        int compareVersion = -this.version.compareTo(o.getVersion());
        return compareProtocol != 0 ? compareProtocol : compareVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ServiceLinkDescription{");
        sb.append("service='").append(this.serviceType).append('\'');
        sb.append(", version=").append((CharSequence)this.version);
        sb.append(", protocol='").append(this.protocol).append('\'');
        sb.append(", workspace='").append(this.workspace).append('\'');
        sb.append(", layer='").append(this.layer).append('\'');
        sb.append(", link='").append(this.link).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

