/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.Component;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Service;
import org.geoserver.web.CapabilitiesHomePageLinkProvider;
import org.geoserver.web.CapabilitiesHomePagePanel;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.ServiceDescription;
import org.geoserver.web.ServiceDescriptionProvider;
import org.geoserver.web.ServiceLinkDescription;

public class ServiceInfoCapabilitiesProvider
implements CapabilitiesHomePageLinkProvider {
    @Override
    public Component getCapabilitiesComponent(String id) {
        Set<String> skip = this.skipServiceDescriptionProviders();
        ArrayList<CapabilitiesHomePagePanel.CapsInfo> serviceInfoLinks = new ArrayList<CapabilitiesHomePagePanel.CapsInfo>();
        for (Service service : GeoServerExtensions.extensions(Service.class)) {
            CapabilitiesHomePagePanel.CapsInfo ci;
            String capsLink;
            String serviceId = service.getId();
            if (skip.contains(serviceId.toLowerCase())) continue;
            if (service.getCustomCapabilitiesLink() != null) {
                capsLink = service.getCustomCapabilitiesLink();
                ci = new CapabilitiesHomePagePanel.CapsInfo(serviceId, service.getVersion(), capsLink);
                serviceInfoLinks.add(ci);
                continue;
            }
            if (!service.getOperations().contains("GetCapabilities")) continue;
            capsLink = "../ows?service=" + serviceId + "&version=" + service.getVersion().toString() + "&request=GetCapabilities";
            ci = new CapabilitiesHomePagePanel.CapsInfo(serviceId, service.getVersion(), capsLink);
            serviceInfoLinks.add(ci);
        }
        if (serviceInfoLinks.isEmpty()) {
            return null;
        }
        return new CapabilitiesHomePagePanel(id, serviceInfoLinks);
    }

    protected Set<String> skipServiceDescriptionProviders() {
        GeoServer geoServer = GeoServerApplication.get().getGeoServer();
        HashSet<String> skip = new HashSet<String>();
        ArrayList workspaceList = new ArrayList();
        workspaceList.add(null);
        if (!geoServer.getGlobal().isGlobalServices().booleanValue()) {
            workspaceList.addAll(geoServer.getCatalog().getWorkspaces());
        }
        for (WorkspaceInfo workspaceInfo : workspaceList) {
            for (ServiceDescriptionProvider provider : GeoServerExtensions.extensions(ServiceDescriptionProvider.class)) {
                for (ServiceDescription service : provider.getServices(workspaceInfo, null)) {
                    skip.add(service.getServiceType().toLowerCase());
                }
                for (ServiceLinkDescription link : provider.getServiceLinks(workspaceInfo, null)) {
                    skip.add(link.getServiceType().toLowerCase());
                    skip.add(link.getProtocol().toLowerCase());
                }
            }
        }
        return skip;
    }
}

