/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.util.Collections;
import java.util.List;
import org.apache.wicket.util.string.Strings;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ServiceResourceProvider;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Service;
import org.geoserver.security.DisabledServiceResourceFilter;
import org.geoserver.util.InternationalStringUtils;
import org.geoserver.web.ServiceDescription;
import org.geoserver.web.ServiceLinkDescription;
import org.geotools.util.GrowableInternationalString;
import org.opengis.util.InternationalString;

public abstract class ServiceDescriptionProvider {
    public List<ServiceDescription> getServices(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        return Collections.emptyList();
    }

    public List<ServiceLinkDescription> getServiceLinks(WorkspaceInfo workspace, PublishedInfo layer) {
        return Collections.emptyList();
    }

    protected boolean isAvailable(String serviceType, ServiceInfo info, PublishedInfo layerInfo) {
        if (layerInfo != null && !layerInfo.isEnabled()) {
            return false;
        }
        if (layerInfo instanceof LayerInfo) {
            ResourceInfo resourceInfo = ((LayerInfo)layerInfo).getResource();
            ServiceResourceProvider provider = (ServiceResourceProvider)GeoServerExtensions.bean(ServiceResourceProvider.class);
            List layerServices = provider.getServicesForResource(resourceInfo);
            List disabledServices = DisabledServiceResourceFilter.disabledServices((ResourceInfo)resourceInfo);
            layerServices.removeAll(disabledServices);
            return layerServices.contains(serviceType);
        }
        return info.isEnabled();
    }

    protected ServiceDescription description(String serviceType, ServiceInfo info, WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        boolean available = this.isAvailable(serviceType, info, layerInfo);
        GrowableInternationalString title = InternationalStringUtils.growable((InternationalString)info.getInternationalTitle(), (String)(Strings.isEmpty((CharSequence)info.getTitle()) ? info.getName() : info.getTitle()));
        GrowableInternationalString description = InternationalStringUtils.growable((InternationalString)info.getInternationalAbstract(), (String)(Strings.isEmpty((CharSequence)info.getAbstract()) ? null : info.getAbstract()));
        return new ServiceDescription(serviceType, (InternationalString)title, (InternationalString)description, available, false, workspaceInfo != null ? workspaceInfo.getName() : null, layerInfo != null ? layerInfo.getName() : null);
    }

    protected String getVersionParameterName(Service service) {
        return "version";
    }

    protected String getCapabilitiesURL(WorkspaceInfo workspace, PublishedInfo layer, Service service) {
        String serviceId = service.getId();
        String serviceVersion = service.getVersion().toString();
        String query = "service=" + serviceId.toUpperCase() + "&" + this.getVersionParameterName(service) + "=" + serviceVersion + "&request=GetCapabilities";
        if (workspace != null && layer != null) {
            return "../" + workspace.getName() + "/" + layer.getName() + "/ows?" + query;
        }
        if (workspace == null && layer != null) {
            String prefixed = layer.prefixedName();
            if (prefixed.contains(":")) {
                String prefix = prefixed.substring(0, prefixed.indexOf(":"));
                return "../" + prefix + "/" + layer.getName() + "/ows?" + query;
            }
            return "../" + layer.getName() + "/ows?" + query;
        }
        if (workspace != null && layer == null) {
            return "../" + workspace.getName() + "/ows?" + query;
        }
        return "../ows?" + query;
    }
}

