/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.geoserver.web.ServiceLinkDescription;
import org.geotools.text.Text;
import org.opengis.util.InternationalString;

public class ServiceDescription
implements Serializable,
Comparable<ServiceDescription> {
    private static final long serialVersionUID = -7406652617944177247L;
    private final String workspace;
    private final String layer;
    private final String serviceType;
    private final InternationalString title;
    private final InternationalString description;
    private final boolean available;
    private final boolean admin;
    private static List<String> OGC_SERVICE_ORDER = Collections.unmodifiableList(Arrays.asList("WMS", "WMTS", "WFS", "WCS", "WPS"));
    Set<ServiceLinkDescription> links = new HashSet<ServiceLinkDescription>();

    public ServiceDescription(String serviceType) {
        this(serviceType, null, null);
    }

    public ServiceDescription(String serviceType, InternationalString title, InternationalString description) {
        this(serviceType, title, description, true, false, null, null);
    }

    public ServiceDescription(String serviceType, InternationalString title, InternationalString description, String workspace) {
        this(serviceType, title, description, true, false, workspace, null);
    }

    public ServiceDescription(String serviceType, InternationalString title, InternationalString description, boolean available, boolean admin, String workspace, String layer) {
        this.serviceType = serviceType;
        this.workspace = workspace;
        this.layer = layer;
        this.available = available;
        this.admin = admin;
        this.title = title != null ? title : Text.text((String)this.serviceType);
        this.description = description != null ? description : Text.text((String)"");
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public InternationalString getTitle() {
        return this.title;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String getLayer() {
        return this.layer;
    }

    public Set<ServiceLinkDescription> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceDescription)) {
            return false;
        }
        ServiceDescription that = (ServiceDescription)o;
        return Objects.equals(this.workspace, that.workspace) && Objects.equals(this.layer, that.layer) && this.serviceType.equals(that.serviceType);
    }

    public int hashCode() {
        return Objects.hash(this.workspace, this.layer, this.serviceType);
    }

    @Override
    public int compareTo(ServiceDescription other) {
        int serviceOrder = OGC_SERVICE_ORDER.indexOf(this.serviceType);
        int serviceOrderOther = OGC_SERVICE_ORDER.indexOf(other.serviceType);
        if (serviceOrder == -1 && serviceOrderOther != -1) {
            return 1;
        }
        if (serviceOrder != -1 && serviceOrderOther == -1) {
            return -1;
        }
        if (serviceOrder != -1 && serviceOrderOther != -1) {
            return Integer.compare(serviceOrder, serviceOrderOther);
        }
        return this.serviceType.compareTo(other.serviceType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ServiceDescription{");
        sb.append("service='").append(this.serviceType).append('\'');
        sb.append(", available=").append(this.available);
        sb.append(", workspace='").append(this.workspace).append('\'');
        sb.append(", layer='").append(this.layer).append('\'');
        sb.append(", links=").append(this.links.size());
        sb.append('}');
        return sb.toString();
    }
}

