/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IFormSubmitter;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.FormComponentFeedbackBorder;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.web.GrowableStringModel;
import org.geoserver.web.data.resource.LocalesDropdown;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.util.GrowableInternationalString;

public abstract class InternationalStringPanel<C extends AbstractTextComponent<String>>
extends FormComponentPanel<GrowableInternationalString> {
    GrowableStringModel growableModel;
    GeoServerTablePanel<GrowableStringModel.InternationalStringEntry> tablePanel;
    C nonInternationalComponent;
    InternationalEntriesProvider provider;
    static final String CHECKBOX_SUFFIX = "_i18nCheckbox";
    GeoServerAjaxFormLink geoServerAjaxFormLink;

    public InternationalStringPanel(String id, IModel<GrowableInternationalString> model, C nonInternationalComponent, WebMarkupContainer checkBoxContainer) {
        super(id, model);
        this.setObjectIfMissing(model, nonInternationalComponent);
        this.nonInternationalComponent = nonInternationalComponent;
        this.nonInternationalComponent.setOutputMarkupId(true);
        this.nonInternationalComponent.setOutputMarkupPlaceholderTag(true);
        this.initUI(new GrowableStringModel(model), checkBoxContainer);
        this.setOutputMarkupId(true);
        this.setOutputMarkupId(true);
    }

    private void setObjectIfMissing(IModel<GrowableInternationalString> model, C nonInternationalComponent) {
        GrowableInternationalString obj = (GrowableInternationalString)model.getObject();
        if (obj == null || obj.getLocales().isEmpty()) {
            if (nonInternationalComponent.getModelObject() != null) {
                model.setObject((Object)new GrowableInternationalString((String)nonInternationalComponent.getModelObject()));
            } else {
                model.setObject((Object)new GrowableInternationalString());
            }
        }
    }

    private void initUI(GrowableStringModel model, WebMarkupContainer checkBoxContainer) {
        this.growableModel = model;
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupPlaceholderTag(true);
        container.setOutputMarkupId(true);
        boolean i18nVisible = this.i18nVisible();
        this.nonInternationalComponent.setVisible(!i18nVisible);
        final AjaxCheckBox checkbox = new AjaxCheckBox(checkBoxContainer.getId() + CHECKBOX_SUFFIX, (IModel)new Model((Serializable)Boolean.valueOf(i18nVisible))){

            protected void onUpdate(AjaxRequestTarget ajaxRequestTarget) {
            }
        };
        AjaxFormSubmitBehavior checkboxSubmitter = new AjaxFormSubmitBehavior("change"){

            protected void onSubmit(AjaxRequestTarget target) {
                this.switchVisibility(target);
            }

            private void switchVisibility(AjaxRequestTarget target) {
                if (((Boolean)checkbox.getConvertedInput()).booleanValue()) {
                    container.setVisible(true);
                    InternationalStringPanel.this.nonInternationalComponent.setVisible(false);
                } else {
                    InternationalStringPanel.this.nonInternationalComponent.setVisible(true);
                    container.setVisible(false);
                }
                target.add(new Component[]{checkbox, container, InternationalStringPanel.this.nonInternationalComponent, InternationalStringPanel.this.tablePanel});
            }

            protected void onError(AjaxRequestTarget target) {
                this.switchVisibility(target);
            }
        };
        checkbox.add(new Behavior[]{checkboxSubmitter});
        checkBoxContainer.add(new Component[]{checkbox});
        container.setVisible(i18nVisible);
        Component[] componentArray = new Component[1];
        this.geoServerAjaxFormLink = new GeoServerAjaxFormLink("addNew"){
            private static final long serialVersionUID = -4136656891019857299L;

            @Override
            protected void onClick(AjaxRequestTarget target, Form<?> form) {
                InternationalStringPanel.this.provider.getItems().add(new GrowableStringModel.InternationalStringEntry());
                InternationalStringPanel.this.tablePanel.modelChanged();
                target.add(new Component[]{InternationalStringPanel.this.tablePanel});
            }
        };
        componentArray[0] = this.geoServerAjaxFormLink;
        container.add(componentArray);
        this.provider = new InternationalEntriesProvider();
        GeoServerTablePanel<GrowableStringModel.InternationalStringEntry> tablePanel = new GeoServerTablePanel<GrowableStringModel.InternationalStringEntry>("tablePanel", (GeoServerDataProvider)this.provider){

            @Override
            protected Component getComponentForProperty(String id, final IModel<GrowableStringModel.InternationalStringEntry> itemModel, GeoServerDataProvider.Property<GrowableStringModel.InternationalStringEntry> property) {
                if (property.getName().equals("locale")) {
                    Fragment localeFragment = new Fragment(id, "selectFragment", (MarkupContainer)InternationalStringPanel.this);
                    FormComponentFeedbackBorder localeBorder = new FormComponentFeedbackBorder("border");
                    localeFragment.add(new Component[]{localeBorder});
                    LocalesDropdown locales = new LocalesDropdown("select", (IModel<Locale>)new PropertyModel(itemModel, "locale"));
                    locales.setLabel((IModel)new ParamResourceModel("th.locale", (Component)InternationalStringPanel.this, new Object[0]));
                    localeBorder.add(new Component[]{locales});
                    locales.add(new LocaleValidator());
                    locales.setNullValid(true);
                    return localeFragment;
                }
                if (property.getName().equals("text")) {
                    String fragmentId;
                    Object field = InternationalStringPanel.this.getTextComponent("txt", (IModel<String>)new PropertyModel(itemModel, "text"));
                    if (field instanceof TextArea) {
                        fragmentId = "txtAreaFragment";
                    } else if (field instanceof TextField) {
                        fragmentId = "txtFragment";
                    } else {
                        throw new RuntimeException("The text component has to be either a TextField or a TextArea");
                    }
                    Fragment textFragment = new Fragment(id, fragmentId, (MarkupContainer)InternationalStringPanel.this);
                    FormComponentFeedbackBorder textBorder = new FormComponentFeedbackBorder("border");
                    textFragment.add(new Component[]{textBorder});
                    field.setLabel((IModel)new ParamResourceModel("th.text", (Component)InternationalStringPanel.this, new Object[0]));
                    textBorder.add(new Component[]{field});
                    field.setRequired(true);
                    return textFragment;
                }
                if ("remove".equals(property.getName())) {
                    Fragment removeFragment = new Fragment(id, "removeFragment", (MarkupContainer)InternationalStringPanel.this);
                    GeoServerAjaxFormLink removeLink = new GeoServerAjaxFormLink("remove"){

                        protected void onClick(AjaxRequestTarget target, Form form) {
                            GrowableStringModel.InternationalStringEntry entry = (GrowableStringModel.InternationalStringEntry)itemModel.getObject();
                            InternationalStringPanel.this.provider.getItems().remove(entry);
                            InternationalStringPanel.this.modelChanged();
                            target.add(new Component[]{InternationalStringPanel.this});
                        }
                    };
                    removeFragment.add(new Component[]{removeLink});
                    return removeFragment;
                }
                return null;
            }

            @Override
            public void processInputs() {
                this.visitChildren(FormComponent.class, (component, visit) -> {
                    ((FormComponent)component).convertInput();
                    ((FormComponent)component).processInput();
                });
            }
        };
        tablePanel.setSelectable(false);
        tablePanel.setFilterable(false);
        tablePanel.setPageable(false);
        Component[] componentArray2 = new Component[1];
        this.tablePanel = tablePanel;
        componentArray2[0] = this.tablePanel;
        container.add(componentArray2);
        this.add(new Component[]{container});
        this.tablePanel.setOutputMarkupId(true);
    }

    protected abstract C getTextComponent(String var1, IModel<String> var2);

    public void convertInput() {
        this.setConvertedInput(this.updateGrowableString());
    }

    private GrowableInternationalString updateGrowableString() {
        GrowableInternationalString growableString = new GrowableInternationalString();
        List<GrowableStringModel.InternationalStringEntry> items = this.provider.getItems();
        for (GrowableStringModel.InternationalStringEntry entry : items) {
            if (!this.canAddElement(items, entry)) continue;
            growableString.add(entry.getLocale(), entry.getText());
        }
        this.growableModel.setObject(growableString);
        return growableString;
    }

    private boolean canAddElement(List<GrowableStringModel.InternationalStringEntry> items, GrowableStringModel.InternationalStringEntry entry) {
        if (entry.getText() == null) {
            return false;
        }
        long count = items.stream().filter(l -> l.getLocale() == null).count();
        int lastElem = items.size() - 1;
        return entry.getLocale() != null || items.indexOf(entry) != lastElem || count <= 1L;
    }

    public void updateModel() {
        String errorMsg;
        if (this.isSaveSubmit()) {
            if (this.nonInternationalComponent.isVisible()) {
                this.growableModel.setObject(null);
                this.provider.setInternationalEntries(new ArrayList<GrowableStringModel.InternationalStringEntry>());
            } else {
                this.nonInternationalComponent.clearInput();
                this.nonInternationalComponent.setConvertedInput(null);
                this.nonInternationalComponent.setModelObject(null);
            }
            this.nonInternationalComponent.modelChanged();
        }
        if ((errorMsg = this.validateNullLocale()) != null) {
            this.getForm().error((Serializable)((Object)errorMsg));
            return;
        }
        this.updateGrowableString();
    }

    private boolean isSaveSubmit() {
        boolean result = false;
        IFormSubmitter submitBtn = this.getForm().findSubmittingButton();
        if (submitBtn != null && submitBtn instanceof Component) {
            Component submitLink = (Component)submitBtn;
            String id = submitLink.getId();
            result = id.equals("submit") || id.equals("save");
        }
        return result;
    }

    private boolean i18nVisible() {
        List<GrowableStringModel.InternationalStringEntry> entries = this.growableModel.getEntries();
        return !entries.isEmpty() && (entries.size() != 1 || entries.get(0).getLocale() != null);
    }

    private String duplicateLocaleMessage(Locale locale) {
        String lang = locale != null && locale.toLanguageTag() != null ? locale.toLanguageTag() : "empty";
        String message = new StringResourceModel("InternationalStringPanel.duplicatedLocale", (Component)this).getString() + " " + lang;
        return message;
    }

    private String validateNullLocale() {
        List<GrowableStringModel.InternationalStringEntry> entries = this.provider.getItems();
        long count = entries.stream().filter(i -> i != null && i.getLocale() == null).count();
        if (count > 1L) {
            return this.duplicateLocaleMessage(null);
        }
        return null;
    }

    private class LocaleValidator
    implements IValidator<Locale> {
        private LocaleValidator() {
        }

        public void validate(IValidatable<Locale> iValidatable) {
            boolean exisits;
            Locale locale = (Locale)iValidatable.getValue();
            List<GrowableStringModel.InternationalStringEntry> items = InternationalStringPanel.this.provider.getItems();
            long count = items.stream().filter(i -> i.getLocale() != null && i.getLocale().equals(locale)).count();
            boolean bl = exisits = count >= 1L && (iValidatable.getModel().getObject() == null || !((Locale)iValidatable.getModel().getObject()).equals(locale));
            if (locale != null && (exisits || count > 2L)) {
                ValidationError error = new ValidationError();
                error.setMessage(InternationalStringPanel.this.duplicateLocaleMessage(locale));
                iValidatable.error((IValidationError)error);
            }
        }
    }

    class InternationalEntriesProvider
    extends GeoServerDataProvider<GrowableStringModel.InternationalStringEntry> {
        List<GrowableStringModel.InternationalStringEntry> internationalEntries;

        @Override
        protected List<GeoServerDataProvider.Property<GrowableStringModel.InternationalStringEntry>> getProperties() {
            return Arrays.asList(new GeoServerDataProvider.BeanProperty("locale", "locale"), new GeoServerDataProvider.BeanProperty("text", "text"), new GeoServerDataProvider.BeanProperty("remove", "remove"));
        }

        @Override
        protected List<GrowableStringModel.InternationalStringEntry> getItems() {
            if (this.internationalEntries == null) {
                this.internationalEntries = new ArrayList<GrowableStringModel.InternationalStringEntry>(InternationalStringPanel.this.growableModel.getEntries());
            }
            return this.internationalEntries;
        }

        void setInternationalEntries(List<GrowableStringModel.InternationalStringEntry> entries) {
            this.internationalEntries = entries;
        }
    }
}

