/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.wicket.core.util.resource.locator.IResourceNameIterator;
import org.apache.wicket.core.util.resource.locator.ResourceNameIterator;
import org.apache.wicket.core.util.resource.locator.ResourceStreamLocator;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.geotools.util.logging.Logging;

public class GeoServerResourceStreamLocator
extends ResourceStreamLocator {
    public static Logger LOGGER = Logging.getLogger((String)"org.geoserver.web");
    static Pattern GS_PROPERTIES = Pattern.compile("GeoServerApplication.*.properties");
    static Pattern GS_LOCAL_I18N = Pattern.compile("org/geoserver/.*(\\.properties|\\.xml)]");
    static Map<String, List<String>> PREFIXES = new HashMap<String, List<String>>();

    public IResourceStream locate(Class<?> clazz, String path) {
        int i = path.lastIndexOf("/");
        if (i != -1) {
            String p = path.substring(i + 1);
            if (GS_PROPERTIES.matcher(p).matches()) {
                try {
                    Enumeration<URL> urls = ((Object)((Object)this)).getClass().getClassLoader().getResources(p);
                    Properties properties = new Properties();
                    while (urls.hasMoreElements()) {
                        URL url = urls.nextElement();
                        Charset charset = p.endsWith(".utf8.properties") ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1;
                        InputStream in = url.openStream();
                        Throwable throwable = null;
                        try {
                            InputStreamReader reader = new InputStreamReader(in, charset);
                            Throwable throwable2 = null;
                            try {
                                properties.load(reader);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        ((Reader)reader).close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                ((Reader)reader).close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (in == null) continue;
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            in.close();
                        }
                    }
                    final ByteArrayOutputStream out = new ByteArrayOutputStream();
                    properties.store(out, "");
                    return new AbstractResourceStream(){

                        public InputStream getInputStream() throws ResourceStreamNotFoundException {
                            return new ByteArrayInputStream(out.toByteArray());
                        }

                        public void close() throws IOException {
                            out.close();
                        }
                    };
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "", e);
                }
            } else {
                if (GS_LOCAL_I18N.matcher(path).matches()) {
                    return null;
                }
                if (path.matches("org/geoserver/.*" + clazz.getName() + ".*_.*.html")) {
                    return null;
                }
            }
        }
        return super.locate(clazz, path);
    }

    public IResourceNameIterator newResourceNameIterator(String path, Locale locale, String style, String variation, String extension, boolean strict) {
        Iterable extensions = null;
        if (path.startsWith("org/geoserver") || path.startsWith("org/apache/wicket")) {
            String ext = extension;
            if (ext == null) {
                ext = FilenameUtils.getExtension((String)path);
            }
            if (ext != null) {
                extensions = PREFIXES.get(ext);
            }
        }
        if (extensions != null) {
            path = FilenameUtils.getPathNoEndSeparator((String)path) + "/" + FilenameUtils.getBaseName((String)path);
            return new ResourceNameIterator(path, style, variation, null, extensions, false);
        }
        return super.newResourceNameIterator(path, locale, style, variation, extension, strict);
    }

    static {
        PREFIXES.put("html", Arrays.asList("html"));
        PREFIXES.put("css", Arrays.asList("css"));
        PREFIXES.put("png", Arrays.asList("png"));
        PREFIXES.put("js", Arrays.asList("js"));
        PREFIXES.put("ico", Arrays.asList("ico"));
    }
}

