/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import com.google.common.base.Stopwatch;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.wicket.Component;
import org.apache.wicket.Localizer;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.Strings;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.DefaultCatalogFacade;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.SettingsInfo;
import org.geoserver.util.InternationalStringUtils;
import org.geoserver.web.CapabilitiesHomePageLinkProvider;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.GeoServerHomePageContentProvider;
import org.geoserver.web.GeoServerUnlockablePage;
import org.geoserver.web.HomePageSelection;
import org.geoserver.web.ServiceDescription;
import org.geoserver.web.ServiceDescriptionProvider;
import org.geoserver.web.ServiceLinkDescription;
import org.geoserver.web.ServicesPanel;
import org.geoserver.web.data.layer.LayerPage;
import org.geoserver.web.data.layer.NewLayerPage;
import org.geoserver.web.data.layergroup.LayerGroupEditPage;
import org.geoserver.web.data.layergroup.LayerGroupPage;
import org.geoserver.web.data.store.NewDataPage;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.data.workspace.WorkspaceNewPage;
import org.geoserver.web.data.workspace.WorkspacePage;
import org.geotools.feature.NameImpl;
import org.geotools.util.GrowableInternationalString;
import org.opengis.feature.type.Name;
import org.opengis.util.InternationalString;

public class GeoServerHomePage
extends GeoServerBasePage
implements GeoServerUnlockablePage {
    transient HomePageSelection selection;
    private WorkspaceInfo workspaceInfo;
    private FormComponent<WorkspaceInfo> workspaceField;
    private PublishedInfo publishedInfo;
    private FormComponent<PublishedInfo> layerField;
    private String description;

    public GeoServerHomePage() {
        this.homeInit();
    }

    public GeoServerHomePage(PageParameters parameters) {
        super(parameters);
        this.homeInit();
        this.selection = null;
    }

    @Override
    protected void commonBaseInit() {
        this.initFromPageParameters(this.getPageParameters());
        this.selection = HomePageSelection.getHomePageSelection(this);
        super.commonBaseInit();
    }

    private void homeInit() {
        SettingsInfo settings;
        GeoServer gs = this.getGeoServer();
        boolean admin = this.getSession().isAdmin();
        ContactInfo contactInfo = gs.getSettings().getContact();
        if (this.workspaceInfo != null && (settings = gs.getSettings(this.workspaceInfo)) != null) {
            contactInfo = settings.getContact();
        }
        Form<GeoServerHomePage> form = this.selectionForm(true);
        this.add(new Component[]{form});
        Locale locale = this.getLocale();
        GrowableInternationalString welcome = InternationalStringUtils.growable((InternationalString)contactInfo.getInternationalWelcome(), (String)contactInfo.getWelcome());
        String welcomeText = welcome.toString(locale);
        Label welcomeMessage = new Label("welcome", (Serializable)((Object)welcomeText));
        welcomeMessage.setVisible(StringUtils.isNotBlank((CharSequence)welcomeText));
        this.add(new Component[]{welcomeMessage});
        this.add(new Component[]{this.belongsTo(contactInfo, locale)});
        this.add(new Component[]{this.footerMessage(contactInfo, locale)});
        this.add(new Component[]{this.footerContact(contactInfo, locale)});
        if (admin) {
            this.add(new Component[]{this.adminOverview()});
        } else {
            this.add(new Component[]{this.placeholderLabel("catalogLinks")});
        }
        this.add(new Component[]{this.additionalHomePageContent()});
        ArrayList<ServiceDescription> serviceDescriptions = new ArrayList<ServiceDescription>();
        ArrayList<ServiceLinkDescription> serviceLinks = new ArrayList<ServiceLinkDescription>();
        for (ServiceDescriptionProvider provider : this.getGeoServerApplication().getBeansOfType(ServiceDescriptionProvider.class)) {
            serviceDescriptions.addAll(provider.getServices(this.workspaceInfo, this.publishedInfo));
            serviceLinks.addAll(provider.getServiceLinks(this.workspaceInfo, this.publishedInfo));
        }
        ServicesPanel serviceList = new ServicesPanel("serviceList", serviceDescriptions, serviceLinks, admin);
        this.add(new Component[]{serviceList});
        if (serviceDescriptions.isEmpty() && serviceLinks.isEmpty()) {
            serviceList.setVisible(false);
        }
        Localizer localizer = GeoServerApplication.get().getResourceSettings().getLocalizer();
        final Label serviceCapabilitiesTitle = new Label("serviceCapabilities", (Serializable)((Object)localizer.getString("GeoServerHomePage.serviceCapabilities", (Component)this)));
        serviceCapabilitiesTitle.setVisible(false);
        this.add(new Component[]{serviceCapabilitiesTitle});
        IModel<List<CapabilitiesHomePageLinkProvider>> capsProviders = this.workspaceInfo == null && this.publishedInfo == null ? this.getContentProviders(CapabilitiesHomePageLinkProvider.class) : Model.ofList(new ArrayList());
        ListView<CapabilitiesHomePageLinkProvider> capsView = new ListView<CapabilitiesHomePageLinkProvider>("providedCaps", capsProviders){
            private static final long serialVersionUID = -4859682164111586340L;

            protected void populateItem(ListItem<CapabilitiesHomePageLinkProvider> item) {
                CapabilitiesHomePageLinkProvider provider = (CapabilitiesHomePageLinkProvider)item.getModelObject();
                Component capsList = null;
                if (!(provider instanceof ServiceDescriptionProvider) && (capsList = provider.getCapabilitiesComponent("capsList")) != null) {
                    serviceCapabilitiesTitle.setVisible(true);
                }
                if (capsList == null) {
                    capsList = GeoServerHomePage.this.placeholderLabel("capsList");
                }
                item.add(new Component[]{capsList});
            }
        };
        this.add(new Component[]{capsView});
        this.description = Optional.ofNullable(this.selection.getDescription()).orElse("");
    }

    void selectHomePage(String workspaceName, String layerName) {
        String workspaceSelection = this.toWorkspace(workspaceName, layerName);
        String layerSelection = this.toLayer(workspaceName, layerName);
        PageParameters pageParams = new PageParameters();
        if (!Strings.isEmpty((CharSequence)workspaceSelection)) {
            pageParams.add("workspace", (Object)workspaceSelection, 0, INamedParameters.Type.QUERY_STRING);
        }
        if (!Strings.isEmpty((CharSequence)layerSelection)) {
            pageParams.add("layer", (Object)layerSelection, 1, INamedParameters.Type.QUERY_STRING);
        }
        this.setResponsePage(GeoServerHomePage.class, pageParams);
    }

    String getWorkspaceFieldText() {
        String rawInput;
        if (this.workspaceField.getModelObject() != null) {
            return ((WorkspaceInfo)this.workspaceField.getModelObject()).getName();
        }
        if (this.workspaceField.hasRawInput() && StringUtils.isNotBlank((CharSequence)(rawInput = this.workspaceField.getRawInput()))) {
            return rawInput;
        }
        if (StringUtils.isNotBlank((CharSequence)this.workspaceField.getInput())) {
            return this.workspaceField.getInput();
        }
        return null;
    }

    private String getLayerFieldText() {
        String rawInput;
        if (this.layerField.getModelObject() != null) {
            return ((PublishedInfo)this.layerField.getModelObject()).prefixedName();
        }
        if (this.layerField.hasRawInput() && StringUtils.isNotBlank((CharSequence)(rawInput = this.layerField.getRawInput()))) {
            return rawInput;
        }
        if (StringUtils.isNotBlank((CharSequence)this.layerField.getInput())) {
            return this.layerField.getInput();
        }
        return null;
    }

    private Form<GeoServerHomePage> selectionForm(boolean ajax) {
        Form form = new Form("form");
        form.add(new Component[]{new Image("workspace.icon", (ResourceReference)new PackageResourceReference(GeoServerHomePage.class, "img/icons/silk/folder.png"), new ResourceReference[0])});
        form.add(new Component[]{new Image("layer.icon", (ResourceReference)new PackageResourceReference(GeoServerHomePage.class, "img/icons/silk/picture_empty.png"), new ResourceReference[0])});
        SubmitLink refresh = new SubmitLink("refresh"){

            public void onSubmit() {
                String workspaceName = GeoServerHomePage.this.getWorkspaceFieldText();
                String layerName = GeoServerHomePage.this.getLayerFieldText();
                GeoServerHomePage.this.selectHomePage(workspaceName, layerName);
            }
        };
        refresh.setVisible(false);
        form.add(new Component[]{refresh});
        form.setDefaultButton((IFormSubmittingComponent)refresh);
        this.workspaceField = this.selection.getWorkspaceField(form, "workspace");
        this.workspaceField.setRequired(false);
        if (ajax) {
            this.workspaceField.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = 5871428962450362668L;

                protected void onUpdate(AjaxRequestTarget target) {
                    String workspaceName = GeoServerHomePage.this.getWorkspaceFieldText();
                    GeoServerHomePage.this.selectHomePage(workspaceName, null);
                }
            }});
        }
        this.layerField = this.selection.getPublishedField(form, "layer");
        this.layerField.setRequired(false);
        if (ajax) {
            this.layerField.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = 5871428962450362669L;

                protected void onUpdate(AjaxRequestTarget target) {
                    String workspaceName = GeoServerHomePage.this.getWorkspaceFieldText();
                    String layerName = GeoServerHomePage.this.getLayerFieldText();
                    GeoServerHomePage.this.selectHomePage(workspaceName, layerName);
                }
            }});
        }
        return form;
    }

    private void initFromPageParameters(PageParameters pageParameters) {
        if (pageParameters == null || pageParameters.isEmpty()) {
            this.workspaceInfo = null;
            this.publishedInfo = null;
            return;
        }
        GeoServer gs = this.getGeoServer();
        String workspace = Optional.ofNullable(this.getPageParameters().get("workspace")).map(p -> p.toString()).orElse(null);
        String layer = Optional.ofNullable(this.getPageParameters().get("layer")).map(p -> p.toString()).orElse(null);
        if (layer != null) {
            workspace = this.toWorkspace(workspace, layer);
            layer = this.toLayer(workspace, layer);
        }
        if (workspace != null) {
            if (this.workspaceInfo != null && this.workspaceInfo.getName().equals(workspace)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Parameter workspace='" + workspace + "' home page previously configured for this workspace");
                }
            } else {
                this.workspaceInfo = gs.getCatalog().getWorkspaceByName(workspace);
                if (this.workspaceInfo == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        String error = "Parameter workspace='" + workspace + "' unable to locate a workspace of this name";
                        this.error((Serializable)((Object)error));
                        LOGGER.warning(error);
                    }
                } else if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Parameter workspace='" + workspace + "' located workspaceInfo used to filter page contents");
                }
            }
        } else {
            this.workspaceInfo = null;
            LOGGER.fine("Parameter workspace not supplied, list global services");
        }
        if (layer != null) {
            if (this.publishedInfo != null && this.publishedInfo.getName().equals(layer)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Parameter layer='" + layer + "' home page previously configured for this layer");
                }
            } else {
                this.publishedInfo = this.layerInfo(this.workspaceInfo, layer);
                if (this.publishedInfo != null) {
                    String prefixedName = this.publishedInfo.prefixedName();
                    if (prefixedName != null && prefixedName.contains(":")) {
                        String prefix = prefixedName.substring(0, prefixedName.indexOf(":"));
                        if (workspace == null || !workspace.equals(prefix)) {
                            LOGGER.fine("Parameter workspace='" + workspace + "' updated from found layer '" + prefixedName + "'");
                            if (this.publishedInfo instanceof LayerInfo) {
                                this.workspaceInfo = ((LayerInfo)this.publishedInfo).getResource().getStore().getWorkspace();
                            } else if (this.publishedInfo instanceof LayerGroupInfo) {
                                this.workspaceInfo = ((LayerGroupInfo)this.publishedInfo).getWorkspace();
                            }
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Updated workspaceInfo used to filter page contents");
                            }
                        }
                    }
                } else {
                    LOGGER.fine("Parameter layer='" + layer + "' unable to locate a layer or layer group of this name");
                }
            }
        } else {
            this.publishedInfo = null;
            LOGGER.fine("Parameter layer not supplied, list global or workspace services");
        }
    }

    @Override
    protected String getDescription() {
        return this.description;
    }

    private ListView<GeoServerHomePageContentProvider> additionalHomePageContent() {
        IModel<List<GeoServerHomePageContentProvider>> contentProviders = this.getContentProviders(GeoServerHomePageContentProvider.class);
        return new ListView<GeoServerHomePageContentProvider>("contributedContent", contentProviders){
            private static final long serialVersionUID = 3756653714268296207L;

            protected void populateItem(ListItem<GeoServerHomePageContentProvider> item) {
                GeoServerHomePageContentProvider provider = (GeoServerHomePageContentProvider)item.getModelObject();
                Component extraContent = provider.getPageBodyComponent("contentList");
                if (null == extraContent) {
                    extraContent = GeoServerHomePage.this.placeholderLabel("contentList");
                }
                item.add(new Component[]{extraContent});
            }
        };
    }

    private Label placeholderLabel(String wicketId) {
        Label placeHolder = new Label(wicketId);
        placeHolder.setVisible(false);
        return placeHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Fragment adminOverview() {
        Stopwatch sw = Stopwatch.createStarted();
        try {
            int wsCount;
            int storesCount;
            int groupCount;
            int layerCount;
            Fragment catalogLinks = new Fragment("catalogLinks", "catalogLinksFragment", (MarkupContainer)this);
            Catalog catalog = this.getCatalog();
            if (this.publishedInfo != null) {
                if (this.publishedInfo instanceof LayerInfo) {
                    layerCount = 1;
                    groupCount = 0;
                    storesCount = 1;
                    wsCount = 1;
                } else {
                    layerCount = 0;
                    groupCount = 1;
                    storesCount = 0;
                    wsCount = this.publishedInfo.prefixedName().contains(":") ? 1 : 0;
                }
            } else if (this.workspaceInfo != null) {
                layerCount = catalog.count(LayerInfo.class, Predicates.equal((String)"resource.namespace.prefix", (Object)this.workspaceInfo.getName()));
                groupCount = catalog.count(LayerGroupInfo.class, Predicates.equal((String)"workspace.name", (Object)this.workspaceInfo.getName()));
                storesCount = catalog.count(StoreInfo.class, Predicates.equal((String)"workspace.name", (Object)this.workspaceInfo.getName()));
                wsCount = 1;
            } else {
                layerCount = catalog.count(LayerInfo.class, Predicates.acceptAll());
                groupCount = catalog.count(LayerGroupInfo.class, Predicates.acceptAll());
                storesCount = catalog.count(StoreInfo.class, Predicates.acceptAll());
                wsCount = catalog.count(WorkspaceInfo.class, Predicates.acceptAll());
            }
            NumberFormat numberFormat = NumberFormat.getIntegerInstance(this.getLocale());
            numberFormat.setGroupingUsed(true);
            catalogLinks.add(new Component[]{new BookmarkablePageLink("layersLink", LayerPage.class).add(new Component[]{new Label("nlayers", (Serializable)((Object)numberFormat.format(layerCount)))})});
            catalogLinks.add(new Component[]{new BookmarkablePageLink("addLayerLink", NewLayerPage.class)});
            catalogLinks.add(new Component[]{new BookmarkablePageLink("groupsLink", LayerGroupPage.class).add(new Component[]{new Label("ngroups", (Serializable)((Object)numberFormat.format(groupCount)))})});
            catalogLinks.add(new Component[]{new BookmarkablePageLink("addGroupLink", LayerGroupEditPage.class)});
            catalogLinks.add(new Component[]{new BookmarkablePageLink("storesLink", StorePage.class).add(new Component[]{new Label("nstores", (Serializable)((Object)numberFormat.format(storesCount)))})});
            catalogLinks.add(new Component[]{new BookmarkablePageLink("addStoreLink", NewDataPage.class)});
            catalogLinks.add(new Component[]{new BookmarkablePageLink("workspacesLink", WorkspacePage.class).add(new Component[]{new Label("nworkspaces", (Serializable)((Object)numberFormat.format(wsCount)))})});
            catalogLinks.add(new Component[]{new BookmarkablePageLink("addWorkspaceLink", WorkspaceNewPage.class)});
            Fragment fragment = catalogLinks;
            return fragment;
        }
        finally {
            sw.stop();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Admin summary of catalog links took " + sw.elapsed().toMillis() + " ms");
            }
        }
    }

    private Label belongsTo(ContactInfo contactInfo, Locale locale) {
        GrowableInternationalString onlineResource = InternationalStringUtils.growable((InternationalString)contactInfo.getInternationalOnlineResource(), (String)InternationalStringUtils.firstNonBlank((String[])new String[]{contactInfo.getOnlineResource(), this.getGeoServer().getSettings().getOnlineResource()}));
        GrowableInternationalString organization = InternationalStringUtils.growable((InternationalString)contactInfo.getInternationalContactOrganization(), (String)contactInfo.getContactOrganization());
        if (organization == null || onlineResource == null) {
            return this.placeholderLabel("belongsTo");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("organization", StringEscapeUtils.escapeHtml4((String)organization.toString(locale)));
        params.put("onlineResource", StringEscapeUtils.escapeHtml4((String)onlineResource.toString(locale)));
        Label belongsToMessage = new Label("belongsTo", (IModel)new StringResourceModel("GeoServerHomePage.belongsTo", (Component)this, (IModel)new Model(params)));
        belongsToMessage.setEscapeModelStrings(false);
        return belongsToMessage;
    }

    private Label footerMessage(ContactInfo contactInfo, Locale locale) {
        String version = String.valueOf(new ResourceModel("version").getObject());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("version", version);
        Label footerMessage = new Label("footerMessage", (IModel)new StringResourceModel("GeoServerHomePage.footer", (Component)this, (IModel)new Model(params)));
        footerMessage.setEscapeModelStrings(false);
        return footerMessage;
    }

    private Label footerContact(ContactInfo contactInfo, Locale locale) {
        GrowableInternationalString contactEmailText = InternationalStringUtils.growable((InternationalString)contactInfo.getInternationalContactEmail(), (String)contactInfo.getContactEmail());
        String contactEmail = contactEmailText.toString(locale);
        if (Strings.isEmpty((CharSequence)contactEmail)) {
            return this.placeholderLabel("footerContact");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("contactEmail", StringEscapeUtils.escapeHtml4((String)contactEmail));
        Label message = new Label("footerContact", (IModel)new StringResourceModel("GeoServerHomePage.footerContact", (Component)this, (IModel)new Model(params)));
        message.setEscapeModelStrings(false);
        return message;
    }

    public WorkspaceInfo getWorkspaceInfo() {
        return this.workspaceInfo;
    }

    public void setWorkspaceInfo(WorkspaceInfo workspaceInfo) {
        this.workspaceInfo = workspaceInfo;
    }

    public PublishedInfo getPublishedInfo() {
        return this.publishedInfo;
    }

    public void setPublishedInfo(PublishedInfo layerInfo) {
        this.publishedInfo = layerInfo;
    }

    private <T> IModel<List<T>> getContentProviders(final Class<T> providerClass) {
        LoadableDetachableModel providersModel = new LoadableDetachableModel<List<T>>(){
            private static final long serialVersionUID = 3042209889224234562L;

            protected List<T> load() {
                GeoServerApplication app = GeoServerHomePage.this.getGeoServerApplication();
                List providers = app.getBeansOfType(providerClass);
                return providers;
            }
        };
        return providersModel;
    }

    protected PublishedInfo layerInfo(WorkspaceInfo workspaceInfo, String layerName) {
        if (layerName == null) {
            return null;
        }
        Catalog catalog = this.getGeoServer().getCatalog();
        if (workspaceInfo != null) {
            NamespaceInfo namespaceInfo = catalog.getNamespaceByPrefix(workspaceInfo.getName());
            LayerInfo layerInfo = catalog.getLayerByName((Name)new NameImpl(namespaceInfo.getURI(), layerName));
            if (layerInfo != null) {
                return layerInfo;
            }
            LayerGroupInfo groupInfo = catalog.getLayerGroupByName(workspaceInfo, layerName);
            return groupInfo;
        }
        LayerInfo layerInfo = catalog.getLayerByName(layerName);
        if (layerInfo != null) {
            return layerInfo;
        }
        LayerGroupInfo groupInfo = catalog.getLayerGroupByName(DefaultCatalogFacade.NO_WORKSPACE, layerName);
        if (groupInfo != null) {
            return groupInfo;
        }
        groupInfo = catalog.getLayerGroupByName(DefaultCatalogFacade.ANY_WORKSPACE, layerName);
        return groupInfo;
    }

    String toWorkspace(String workspaceName, String layerName) {
        if (!Strings.isEmpty((CharSequence)layerName) && layerName.contains(":")) {
            return layerName.substring(0, layerName.indexOf(":"));
        }
        if (!Strings.isEmpty((CharSequence)workspaceName)) {
            return workspaceName;
        }
        return "";
    }

    String toLayer(String workspaceName, String layerName) {
        if (!Strings.isEmpty((CharSequence)layerName)) {
            if (layerName.contains(":")) {
                return layerName.substring(layerName.indexOf(":") + 1);
            }
            return layerName;
        }
        return "";
    }
}

