/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.geotools.util.Version;

public class CapabilitiesHomePagePanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public CapabilitiesHomePagePanel(String id, List<CapsInfo> capsLinks) {
        super(id);
        capsLinks.sort(new Comparator<CapsInfo>(){

            @Override
            public int compare(CapsInfo o1, CapsInfo o2) {
                int serviceOrder = o1.getService().toUpperCase().compareTo(o2.getService().toUpperCase());
                int versionOrder = -o1.version.compareTo(o2.getVersion());
                return serviceOrder != 0 ? serviceOrder : versionOrder;
            }
        });
        ListView<CapsInfo> view = new ListView<CapsInfo>("services", capsLinks){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<CapsInfo> captItem) {
                CapsInfo capsInfo = (CapsInfo)captItem.getModelObject();
                Version version = capsInfo.getVersion();
                String capsLink = capsInfo.getCapsLink();
                ExternalLink link = new ExternalLink("link", capsLink);
                link.add(new Component[]{new Label("service", (Serializable)((Object)capsInfo.getService()))});
                link.add(new Component[]{new Label("version", (Serializable)((Object)version.toString()))});
                captItem.add(new Component[]{link});
            }
        };
        this.add(new Component[]{view});
    }

    public static class CapsInfo
    implements Serializable {
        String service;
        Version version;
        String capsLink;

        public CapsInfo(String service, Version version, String capsLink) {
            this.service = service;
            this.version = version;
            this.capsLink = capsLink;
        }

        public String getService() {
            return this.service;
        }

        public Version getVersion() {
            return this.version;
        }

        public String getCapsLink() {
            return this.capsLink;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CapsInfo)) {
                return false;
            }
            CapsInfo ci = (CapsInfo)o;
            return this.service.equals(ci.service) && this.version.equals((Object)ci.version) && this.capsLink.equals(ci.capsLink);
        }

        public int hashCode() {
            return Objects.hash(this.service, this.version, this.capsLink);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("CapsInfo{");
            sb.append("service='").append(this.service).append('\'');
            sb.append(", version=").append((CharSequence)this.version);
            sb.append(", capsLink='").append(this.capsLink).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

