/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wcs.bindings;

import javax.xml.namespace.QName;
import org.geotools.gml3.GML;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.wcs.WCS;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.opengis.temporal.Period;
import org.opengis.temporal.Position;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TimePeriodTypeBinding
extends AbstractComplexBinding {
    @Override
    public QName getTarget() {
        return WCS.TimePeriodType;
    }

    public Class getType() {
        return Period.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        DefaultInstant begining = new DefaultInstant((Position)node.getChild("beginPosition").getValue());
        DefaultInstant ending = new DefaultInstant((Position)node.getChild("endPosition").getValue());
        DefaultPeriod timePeriod = new DefaultPeriod(begining, ending);
        return timePeriod;
    }

    @Override
    public Element encode(Object object, Document document, Element value) throws Exception {
        Period timePeriod = (Period)object;
        if (timePeriod == null) {
            value.appendChild(document.createElementNS("http://www.opengis.net/gml", GML.Null.getLocalPart()));
        }
        return null;
    }

    @Override
    public Object getProperty(Object object, QName name) {
        Period timePeriod = (Period)object;
        if (timePeriod == null) {
            return null;
        }
        if (name.getLocalPart().equals("beginPosition")) {
            return timePeriod.getBeginning().getPosition();
        }
        if (name.getLocalPart().equals("endPosition")) {
            return timePeriod.getEnding().getPosition();
        }
        return null;
    }
}

