/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.utfgrid;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.CachedGridReaderLayer;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.map.AbstractMapOutputFormat;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geoserver.wms.utfgrid.PureVectorRenderer;
import org.geoserver.wms.utfgrid.UTFGridColorFunction;
import org.geoserver.wms.utfgrid.UTFGridEntries;
import org.geoserver.wms.utfgrid.UTFGridFeatureSource;
import org.geoserver.wms.utfgrid.UTFGridMap;
import org.geoserver.wms.utfgrid.UTFGridMapContent;
import org.geoserver.wms.utfgrid.UTFGridStyleVisitor;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.GridReaderLayer;
import org.geotools.map.Layer;
import org.geotools.map.RasterLayer;
import org.geotools.map.StyleLayer;
import org.geotools.ows.wms.map.WMSLayer;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.logging.Logging;

public class UTFGridMapOutputFormat
extends AbstractMapOutputFormat {
    static final Logger LOGGER = Logging.getLogger(UTFGridMapOutputFormat.class);
    static final String MIME_TYPE = "application/json;type=utfgrid";
    static final String OUTPUT_FORMAT_NAME = "utfgrid";
    static final int DEFAULT_UTFRESOLUTION = 4;
    private static MapProducerCapabilities CAPABILITIES = new MapProducerCapabilities(false, false, true);
    private WMS wms;

    public UTFGridMapOutputFormat(WMS wms) {
        super(MIME_TYPE, OUTPUT_FORMAT_NAME);
        this.wms = wms;
    }

    @Override
    public MapProducerCapabilities getCapabilities(String format) {
        return CAPABILITIES;
    }

    @Override
    public WebMap produceMap(WMSMapContent mapContent) throws ServiceException, IOException {
        RenderedImageMapOutputFormat of = new RenderedImageMapOutputFormat(this.wms){

            @Override
            protected StreamingRenderer buildRenderer() {
                return new PureVectorRenderer();
            }

            @Override
            protected RenderedImage prepareImage(int width, int height, IndexColorModel palette, boolean transparent) {
                return new BufferedImage(width, height, 1);
            }

            @Override
            protected void onBeforeRender(StreamingRenderer renderer) {
                renderer.getJava2DHints().put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                Map hints = renderer.getRendererHints();
                double dpi = RendererUtilities.getDpi((Map)hints);
                hints.put("dpi", dpi /= 4.0);
            }
        };
        UTFGridEntries entries = new UTFGridEntries();
        UTFGridMapContent utfGridMapContent = this.buildUTFGridMapContent(mapContent, entries);
        RenderedImageMap map = of.produceMap(utfGridMapContent);
        return new UTFGridMap(utfGridMapContent, map.getImage());
    }

    private UTFGridMapContent buildUTFGridMapContent(WMSMapContent original, UTFGridEntries entries) {
        UTFGridColorFunction colorFunction = new UTFGridColorFunction(entries);
        UTFGridMapContent result = new UTFGridMapContent(original, entries, 4);
        ArrayList<StyleLayer> utfLayers = new ArrayList<StyleLayer>();
        for (Layer layer : original.layers()) {
            if (!(layer instanceof StyleLayer)) continue;
            Object sl = (StyleLayer)layer;
            UTFGridStyleVisitor styleVisitor = new UTFGridStyleVisitor(colorFunction);
            layer.getStyle().accept((StyleVisitor)styleVisitor);
            Style copy = (Style)styleVisitor.getCopy();
            if (copy.featureTypeStyles().isEmpty() || styleVisitor.hasTransformations() && !styleVisitor.hasVectorTransformations() || layer instanceof RasterLayer && !styleVisitor.hasVectorTransformations()) continue;
            if (layer instanceof FeatureLayer) {
                FeatureLayer fl = new FeatureLayer(new UTFGridFeatureSource(layer.getFeatureSource(), null), copy);
                fl.setQuery(layer.getQuery());
                sl = fl;
            } else if (layer instanceof GridCoverageLayer) {
                GridCoverageLayer gc = (GridCoverageLayer)sl;
                sl = new GridCoverageLayer(gc.getCoverage(), copy);
            } else {
                CachedGridReaderLayer gr;
                if (layer instanceof WMSLayer) continue;
                if (layer instanceof CachedGridReaderLayer) {
                    gr = (CachedGridReaderLayer)((Object)sl);
                    sl = new CachedGridReaderLayer(gr.getReader(), copy);
                } else if (layer instanceof GridReaderLayer) {
                    gr = (GridReaderLayer)sl;
                    sl = new GridReaderLayer(gr.getReader(), copy);
                } else {
                    LOGGER.log(Level.WARNING, "Skipping unknown layer " + sl + " of type " + sl.getClass());
                    continue;
                }
            }
            utfLayers.add((StyleLayer)sl);
        }
        result.layers().addAll(utfLayers);
        return result;
    }
}

