/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.utfgrid;

import java.util.HashMap;
import java.util.Map;
import org.opengis.feature.Feature;

class UTFGridEntries {
    Map<String, UTFGridEntry> entryMap = new HashMap<String, UTFGridEntry>();
    int value = 1;

    UTFGridEntries() {
    }

    int getKeyForFeature(Feature feature) {
        String id = feature.getIdentifier().getID();
        UTFGridEntry entry = this.entryMap.get(id);
        if (entry == null) {
            entry = new UTFGridEntry(this.value++, feature);
            this.entryMap.put(id, entry);
        }
        return entry.getValue();
    }

    Map<Integer, UTFGridEntry> getEntryMap() {
        HashMap<Integer, UTFGridEntry> result = new HashMap<Integer, UTFGridEntry>();
        for (UTFGridEntry entry : this.entryMap.values()) {
            result.put(entry.getValue(), entry);
        }
        return result;
    }

    static class UTFGridEntry {
        int value;
        int key = -1;
        Feature feature;

        public UTFGridEntry(int value, Feature feature) {
            this.value = value;
            this.feature = feature;
        }

        public int getValue() {
            return this.value;
        }

        public Feature getFeature() {
            return this.feature;
        }

        public int getKey() {
            return this.key;
        }

        public void setKey(int key) {
            this.key = key;
        }
    }
}

