/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.geotools.map.Layer;
import org.geotools.renderer.RenderListener;
import org.opengis.feature.simple.SimpleFeature;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class RenderTimeStatistics
implements RenderListener {
    public static final String ID = "statistics";
    private List<Layer> layers = new LinkedList<Layer>();
    private Map<Integer, Long> startRenderingLayersTimes = new HashMap<Integer, Long>();
    private Map<Integer, Long> endRenderingLayersTimes = new HashMap<Integer, Long>();
    private Map<Integer, Long> renderingLayersTimes = new HashMap<Integer, Long>();
    private Long renderingLabelsTimes;
    private Long startRenderingLabelsTimes;
    private Long endRenderingLabelsTimes;
    private int index = 0;
    private List<Integer> renderingLayersIdxs = new ArrayList<Integer>();

    public void featureRenderer(SimpleFeature feature) {
    }

    public void errorOccurred(Exception e) {
    }

    public void layerStart(Layer layer) {
        this.layers.add(this.index, layer);
        this.startRenderingLayersTimes.put(this.index, System.currentTimeMillis());
        this.renderingLayersIdxs.add(this.index);
        ++this.index;
    }

    public void layerEnd(Layer layer) {
        Integer key = this.layers.indexOf(layer);
        this.endRenderingLayersTimes.put(key, System.currentTimeMillis());
    }

    public void labellingStart() {
        this.startRenderingLabelsTimes = System.currentTimeMillis();
    }

    public void labellingEnd() {
        this.endRenderingLabelsTimes = System.currentTimeMillis();
    }

    public void renderingComplete() {
        for (Integer idx : this.renderingLayersIdxs) {
            if (this.renderingLayersTimes.get(idx) != null) continue;
            Long startingTime = this.startRenderingLayersTimes.get(idx);
            Long endingTime = this.endRenderingLayersTimes.get(idx);
            this.renderingLayersTimes.put(idx, endingTime != null ? endingTime - startingTime : 0L);
        }
        this.renderingLabelsTimes = this.startRenderingLabelsTimes != null && this.endRenderingLabelsTimes != null ? this.endRenderingLabelsTimes - this.startRenderingLabelsTimes : 0L;
        this.addSelfAsRequestAttribute();
    }

    public Long getRenderingTime(Integer layerId) {
        return this.renderingLayersTimes.get(layerId);
    }

    public long getLabellingTime() {
        return this.renderingLabelsTimes;
    }

    public List<String> getLayerNames() {
        return this.layers.stream().map(l -> l.getTitle() != null ? l.getTitle() : "Layer" + (this.layers.indexOf(l) + 1)).collect(Collectors.toList());
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public void setLayers(List<Layer> layers) {
        this.layers = layers;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Long getRenderingLabelsTimes() {
        return this.renderingLabelsTimes;
    }

    public void setRenderingLabelsTimes(Long renderingLabelsTimes) {
        this.renderingLabelsTimes = renderingLabelsTimes;
    }

    public Map<Integer, Long> getRenderingLayersTimes() {
        return this.renderingLayersTimes;
    }

    public void setRenderingLayersTimes(Map<Integer, Long> renderingLayersTimes) {
        this.renderingLayersTimes = renderingLayersTimes;
    }

    public List<Integer> getRenderingLayersIdxs() {
        return this.renderingLayersIdxs;
    }

    private void addSelfAsRequestAttribute() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            requestAttributes.setAttribute(ID, (Object)this, 0);
        }
    }
}

