/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.GeoServerSLDVisitor;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.opengis.filter.Filter;

public class ProcessStandaloneSLDVisitor
extends GeoServerSLDVisitor {
    final WMS wms;
    final GetMapRequest request;
    final List<MapLayerInfo> layers;
    final List<Style> styles;
    MapLayerInfo currLayer = null;

    public ProcessStandaloneSLDVisitor(WMS wms, GetMapRequest request) {
        super(wms.getCatalog(), request.getCrs());
        this.wms = wms;
        this.request = request;
        this.layers = new ArrayList<MapLayerInfo>();
        this.styles = new ArrayList<Style>();
    }

    public void visit(StyledLayerDescriptor sld) {
        try {
            super.visit(sld);
            this.request.setLayers(this.layers);
            this.request.setStyles(this.styles);
        }
        catch (UncheckedIOException | IllegalStateException | UnsupportedOperationException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public PublishedInfo visitNamedLayerInternal(StyledLayer sl) {
        this.currLayer = null;
        String layerName = sl.getName();
        LayerGroupInfo groupInfo = this.wms.getLayerGroupByName(layerName);
        if (groupInfo == null) {
            LayerInfo layerInfo = this.wms.getLayerByName(layerName);
            if (layerInfo == null) {
                throw new ServiceException("Unknown layer: " + layerName);
            }
            this.currLayer = new MapLayerInfo(layerInfo);
            if (sl instanceof NamedLayer) {
                NamedLayer namedLayer = (NamedLayer)sl;
                this.currLayer.setLayerFeatureConstraints(namedLayer.getLayerFeatureConstraints());
            }
            return layerInfo;
        }
        return groupInfo;
    }

    public void visitUserLayerRemoteOWS(UserLayer ul) {
        this.currLayer = null;
        FeatureTypeConstraint[] featureConstraints = ul.getLayerFeatureConstraints();
        if (this.request.getFilter() == null) {
            this.request.setFilter(new ArrayList<Filter>());
        }
        for (FeatureTypeConstraint featureConstraint : featureConstraints) {
            Filter filter = featureConstraint.getFilter();
            if (filter == null) {
                filter = Filter.INCLUDE;
            }
            this.request.getFilter().add(filter);
        }
    }

    public void visitUserLayerInlineFeature(UserLayer ul) {
        this.currLayer = new MapLayerInfo((LayerInfo)this.info);
    }

    public StyleInfo visitNamedStyleInternal(NamedStyle namedStyle) {
        StyleInfo s = this.catalog.getStyleByName(namedStyle.getName());
        if (s == null) {
            String failMessage = "couldn't find style named '" + namedStyle.getName() + "'";
            if (this.currLayer.getType() == MapLayerInfo.TYPE_RASTER) {
                s = this.catalog.getStyleByName("raster");
                if (s == null) {
                    throw new ServiceException(failMessage + "  Also tried to use the generic raster style 'raster', but it wasn't available.");
                }
            } else {
                throw new ServiceException(failMessage);
            }
        }
        if (this.currLayer != null) {
            try {
                this.layers.add(this.currLayer);
                this.styles.add(s.getStyle());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return s;
    }

    public void visitUserStyleInternal(Style userStyle) {
        if (this.currLayer != null) {
            this.layers.add(this.currLayer);
            this.styles.add(userStyle);
        } else if (this.info != null && this.info instanceof LayerInfo) {
            this.layers.add(new MapLayerInfo((LayerInfo)this.info));
            this.styles.add(userStyle);
        }
    }
}

