/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureTypes;
import org.geotools.filter.ExpressionDOMParser;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.geotools.util.logging.Logging;
import org.geotools.xml.styling.SLDParser;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.util.GETMAPValidator;
import org.vfny.geoserver.util.SLDValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class GetMapXmlReader
extends XmlRequestReader {
    private static final Logger LOGGER = Logging.getLogger(GetMapXmlReader.class);
    private static final StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
    private WMS wms;

    public GetMapXmlReader(WMS wms) {
        super("http://www.opengis.net/ows", "GetMap");
        this.wms = wms;
    }

    public WMS getWMS() {
        return this.wms;
    }

    public Object read(Object request, Reader reader, Map kvp) throws Exception {
        GetMapRequest getMapRequest = new GetMapRequest();
        boolean validateSchema = kvp.containsKey("validateschema");
        try {
            this.parseGetMapXML(reader, getMapRequest, validateSchema);
        }
        catch (UnknownHostException unh) {
            throw new ServiceException("unknown host - " + unh.getLocalizedMessage() + " - if its in a !DOCTYPE, remove the !DOCTYPE tag.");
        }
        catch (SAXParseException se) {
            throw new ServiceException("line " + se.getLineNumber() + " column " + se.getColumnNumber() + " -- " + se.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        return getMapRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseGetMapXML(Reader xml, GetMapRequest getMapRequest, boolean validateSchema) throws Exception {
        File temp = null;
        try {
            NamedNodeMap atts;
            Node wmsVersion;
            if (validateSchema) {
                temp = File.createTempFile("getMapPost", "xml");
                try (FileOutputStream fos = new FileOutputStream(temp);
                     BufferedOutputStream out = new BufferedOutputStream(fos);){
                    int c;
                    while (-1 != (c = xml.read())) {
                        out.write(c);
                    }
                    out.flush();
                }
                finally {
                    xml.close();
                }
                xml = new BufferedReader(new FileReader(temp));
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setExpandEntityReferences(false);
            dbf.setValidating(false);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            EntityResolver entityResolver = this.wms.getCatalog().getResourcePool().getEntityResolver();
            if (entityResolver != null) {
                db.setEntityResolver(entityResolver);
            }
            InputSource input = new InputSource(xml);
            Document dom = db.parse(input);
            SLDParser sldParser = new SLDParser(styleFactory);
            Element rootNode = dom.getDocumentElement();
            Element nodeGetMap = rootNode;
            if (!this.nodeNameEqual(nodeGetMap, "getmap")) {
                if (this.nodeNameEqual(nodeGetMap, "StyledLayerDescriptor")) {
                    if (validateSchema) {
                        this.validateSchemaSLD(temp, getMapRequest);
                    }
                    this.handlePostGet(rootNode, sldParser, getMapRequest);
                    return;
                }
                throw new Exception("GetMap XML parser - start node isnt 'GetMap' or 'StyledLayerDescriptor' tag");
            }
            if (validateSchema) {
                this.validateSchemaGETMAP(temp, getMapRequest);
            }
            if ((wmsVersion = (atts = nodeGetMap.getAttributes()).getNamedItem("version")) == null) {
                throw new Exception("GetMap XML parser - couldnt find attribute 'version' in GetMap tag");
            }
            getMapRequest.setVersion(wmsVersion.getNodeValue());
            this.parseBBox(getMapRequest, nodeGetMap);
            StyledLayerDescriptor sld = sldParser.parseDescriptor(this.getNode(rootNode, "StyledLayerDescriptor"));
            this.processStyles(getMapRequest, sld);
            this.parseXMLOutput(nodeGetMap, getMapRequest);
            getMapRequest.setExceptions(this.getNodeValue(nodeGetMap, "Exceptions"));
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
    }

    private void handlePostGet(Node rootNode, SLDParser sldParser, GetMapRequest getMapRequest) throws Exception {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("reading request: ").append(getMapRequest).toString());
        }
        StyledLayerDescriptor sld = sldParser.parseDescriptor(rootNode);
        this.processStyles(getMapRequest, sld);
    }

    private void processStyles(GetMapRequest getMapRequest, StyledLayerDescriptor sld) throws Exception {
        StyledLayer[] styledLayers = sld.getStyledLayers();
        int slCount = styledLayers.length;
        if (slCount == 0) {
            throw new ServiceException("SLD document contains no layers");
        }
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
        ArrayList<Style> styles = new ArrayList<Style>();
        ArrayList<Filter> filters = new ArrayList<Filter>();
        StyledLayer sl = null;
        for (StyledLayer styledLayer : styledLayers) {
            MapLayerInfo currLayer;
            sl = styledLayer;
            String layerName = sl.getName();
            if (null == layerName) {
                throw new ServiceException("A UserLayer without layer name was passed");
            }
            if (sl instanceof UserLayer && ((UserLayer)sl).getInlineFeatureDatastore() != null) {
                UserLayer ul = (UserLayer)sl;
                DefaultGeographicCRS crs = getMapRequest.getCrs() == null ? DefaultGeographicCRS.WGS84 : getMapRequest.getCrs();
                currLayer = GetMapXmlReader.initializeInlineFeatureLayer(ul, (CoordinateReferenceSystem)crs);
                GetMapXmlReader.addStyles(this.wms, getMapRequest, currLayer, styledLayer, layers, styles, filters);
                continue;
            }
            LayerGroupInfo layerGroup = this.getWMS().getLayerGroupByName(layerName);
            if (layerGroup != null) {
                List layerGroupLayers = layerGroup.layers();
                List layerGroupStyles = layerGroup.getStyles();
                for (int j = 0; j < layerGroupStyles.size(); ++j) {
                    StyleInfo si = (StyleInfo)layerGroupStyles.get(j);
                    LayerInfo layer = (LayerInfo)layerGroupLayers.get(j);
                    currLayer = new MapLayerInfo(layer, layerGroup.getMetadata());
                    if (si != null) {
                        currLayer.setStyle(si.getStyle());
                    }
                    GetMapXmlReader.addStyles(this.wms, getMapRequest, currLayer, styledLayer, layers, styles, filters);
                }
                continue;
            }
            LayerInfo layerInfo = this.getWMS().getLayerByName(layerName);
            if (layerInfo == null) {
                throw new ServiceException("Layer not found: " + layerName);
            }
            currLayer = new MapLayerInfo(layerInfo);
            GetMapXmlReader.addStyles(this.wms, getMapRequest, currLayer, styledLayer, layers, styles, filters);
        }
        getMapRequest.setLayers(layers);
        getMapRequest.setStyles(styles);
        getMapRequest.setFilter(filters);
    }

    public static void addStyles(WMS wms, GetMapRequest request, MapLayerInfo currLayer, StyledLayer layer, List<MapLayerInfo> layers, List<Style> styles, List<Filter> filters) throws ServiceException, IOException {
        if (currLayer == null) {
            return;
        }
        Style[] layerStyles = null;
        FeatureTypeConstraint[] ftcs = null;
        if (layer instanceof NamedLayer) {
            ftcs = ((NamedLayer)layer).getLayerFeatureConstraints();
            layerStyles = ((NamedLayer)layer).getStyles();
            if (GetMapXmlReader.shouldUseLayerStyle(layerStyles, currLayer)) {
                layerStyles = new Style[]{currLayer.getStyle()};
            }
        } else if (layer instanceof UserLayer) {
            ftcs = ((UserLayer)layer).getLayerFeatureConstraints();
            layerStyles = ((UserLayer)layer).getUserStyles();
        }
        if (ftcs != null) {
            for (FeatureTypeConstraint featureTypeConstraint : ftcs) {
                boolean matches;
                FeatureTypeConstraint ftc = featureTypeConstraint;
                if (ftc.getFeatureTypeName() == null) continue;
                String ftc_name = ftc.getFeatureTypeName();
                try {
                    FeatureType currSchema = currLayer.getFeature().getFeatureType();
                    matches = currSchema.getName().getLocalPart().equalsIgnoreCase(ftc_name) || FeatureTypes.isDecendedFrom((FeatureType)currSchema, null, (String)ftc_name);
                }
                catch (Exception e) {
                    matches = false;
                }
                if (!matches || ftc.getFilter() == null) continue;
                filters.add(ftc.getFilter());
            }
        }
        if (layerStyles == null || layerStyles.length == 0) {
            layers.add(currLayer);
            styles.add(currLayer.getDefaultStyle());
            return;
        }
        for (FeatureTypeConstraint featureTypeConstraint : layerStyles) {
            if (featureTypeConstraint instanceof NamedStyle) {
                layers.add(currLayer);
                String styleName = featureTypeConstraint.getName();
                Style s = wms.getStyleByName(styleName);
                if (s == null) {
                    throw new ServiceException("couldnt find style named '" + styleName + "'");
                }
                styles.add(s);
                continue;
            }
            if (wms.isDynamicStylingDisabled()) {
                throw new ServiceException("Dynamic style usage is forbidden");
            }
            layers.add(currLayer);
            styles.add((Style)featureTypeConstraint);
        }
    }

    private static boolean shouldUseLayerStyle(Style[] layerStyles, MapLayerInfo currLayer) {
        boolean noSldLayerStyles = layerStyles == null || layerStyles.length == 0;
        boolean layerHasStyle = currLayer.getStyle() != null;
        boolean shouldUseLayerStyle = noSldLayerStyles && layerHasStyle;
        return shouldUseLayerStyle;
    }

    private static MapLayerInfo initializeInlineFeatureLayer(UserLayer ul, CoordinateReferenceSystem requestCrs) throws Exception {
        SimpleFeatureSource source;
        DataStore inlineDatastore = ul.getInlineFeatureDatastore();
        if (ul.getInlineFeatureType().getCoordinateReferenceSystem() == null) {
            LOGGER.warning("No CRS set on inline features default geometry.  Assuming the requestor has their inlinefeatures in the boundingbox CRS.");
            SimpleFeatureType currFt = ul.getInlineFeatureType();
            Query q = new Query(currFt.getTypeName(), (Filter)Filter.INCLUDE);
            FeatureReader ilReader = inlineDatastore.getFeatureReader(q, Transaction.AUTO_COMMIT);
            ForceCoordinateSystemFeatureReader reader = new ForceCoordinateSystemFeatureReader(ilReader, requestCrs);
            MemoryDataStore reTypedDS = new MemoryDataStore((FeatureReader)reader);
            source = reTypedDS.getFeatureSource(reTypedDS.getTypeNames()[0]);
        } else {
            source = inlineDatastore.getFeatureSource(inlineDatastore.getTypeNames()[0]);
        }
        MapLayerInfo mapLayer = new MapLayerInfo(source);
        return mapLayer;
    }

    private void parseBBox(GetMapRequest getMapRequest, Node nodeGetMap) throws Exception {
        Node bboxNode = this.getNode(nodeGetMap, "BoundingBox");
        if (bboxNode == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'BoundingBox' in GetMap tag");
        }
        List coordList = new ExpressionDOMParser(CommonFactoryFinder.getFilterFactory2()).coords(bboxNode);
        if (coordList.size() != 2) {
            throw new Exception("GetMap XML parser - node 'BoundingBox' in GetMap tag should have 2 coordinates in it");
        }
        Envelope env = new Envelope();
        for (Object o : coordList) {
            env.expandToInclude((Coordinate)o);
        }
        getMapRequest.setBbox(env);
        NamedNodeMap atts = bboxNode.getAttributes();
        Node srsNode = atts.getNamedItem("srsName");
        if (srsNode != null) {
            String srs = srsNode.getNodeValue();
            String epsgCode = srs.substring(srs.indexOf(35) + 1);
            epsgCode = "EPSG:" + epsgCode;
            try {
                CoordinateReferenceSystem mapcrs = CRS.decode((String)epsgCode);
                getMapRequest.setCrs(mapcrs);
                getMapRequest.setSRS(epsgCode);
            }
            catch (Exception e) {
                throw new ServiceException(e.getLocalizedMessage(), "InvalidSRS");
            }
        }
    }

    private void parseXMLOutput(Node nodeGetMap, GetMapRequest getMapRequest) throws Exception {
        Node sizeNode;
        String bgColor;
        String bufferValue;
        Node outputNode = this.getNode(nodeGetMap, "Output");
        if (outputNode == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Output' in GetMap tag");
        }
        String format = this.getNodeValue(outputNode, "Format");
        if (format == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Format' in GetMap/Output tag");
        }
        getMapRequest.setFormat(format);
        String trans = this.getNodeValue(outputNode, "Transparent");
        if (trans != null) {
            if (trans.equalsIgnoreCase("false") || trans.equalsIgnoreCase("0")) {
                getMapRequest.setTransparent(false);
            } else {
                getMapRequest.setTransparent(true);
            }
        }
        if ((bufferValue = this.getNodeValue(outputNode, "Buffer")) == null) {
            this.getNodeValue(outputNode, "Radius");
        }
        if (bufferValue != null) {
            getMapRequest.setBuffer(Integer.parseInt(bufferValue));
        }
        if ((bgColor = this.getNodeValue(outputNode, "BGcolor")) != null) {
            getMapRequest.setBgColor(Color.decode(bgColor));
        }
        if ((sizeNode = this.getNode(outputNode, "Size")) == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Size' in GetMap/Output tag");
        }
        String width = this.getNodeValue(sizeNode, "Width");
        if (width == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Width' in GetMap/Output/Size tag");
        }
        getMapRequest.setWidth(Integer.parseInt(width));
        String height = this.getNodeValue(sizeNode, "Height");
        if (height == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Height' in GetMap/Output/Size tag");
        }
        getMapRequest.setHeight(Integer.parseInt(height));
    }

    public Node getNode(Node parentNode, String wantedChildName) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (!childName.equalsIgnoreCase(wantedChildName)) continue;
            return child;
        }
        return null;
    }

    public String getNodeValue(Node parentNode, String wantedChildName) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (!childName.equalsIgnoreCase(wantedChildName)) continue;
            return child.getChildNodes().item(0).getNodeValue();
        }
        return null;
    }

    public boolean nodeNameEqual(Node n, String name) {
        if (n.getNodeName().equalsIgnoreCase(name)) {
            return true;
        }
        String nname = n.getNodeName();
        int idx = nname.indexOf(58);
        if (idx == -1) {
            return false;
        }
        return nname.substring(idx + 1).equalsIgnoreCase(name);
    }

    public void validateSchemaSLD(File f, GetMapRequest getMapRequest) throws Exception {
        SLDValidator validator = new SLDValidator();
        List errors = null;
        try {
            try (FileInputStream in = new FileInputStream(f);){
                errors = validator.validateSLD((InputStream)in);
            }
            if (!errors.isEmpty()) {
                in = new FileInputStream(f);
                var6_7 = null;
                try {
                    try {
                        throw new ServiceException(SLDValidator.getErrorMessage((InputStream)in, (List)errors));
                    }
                    catch (Throwable throwable) {
                        var6_7 = throwable;
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        if (var6_7 != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (Throwable throwable2) {
                                var6_7.addSuppressed(throwable2);
                            }
                        } else {
                            ((InputStream)in).close();
                        }
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException e) {
            String msg = new StringBuffer("Creating remote SLD url: ").append(e.getMessage()).toString();
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, msg, e);
            }
            throw new ServiceException((Throwable)e, msg, "parseSldParam");
        }
    }

    public void validateSchemaGETMAP(File f, GetMapRequest getMapRequest) throws Exception {
        GETMAPValidator validator = new GETMAPValidator();
        List errors = null;
        try {
            try (FileInputStream in = new FileInputStream(f);){
                errors = validator.validateGETMAP((InputStream)in);
            }
            if (!errors.isEmpty()) {
                in = new FileInputStream(f);
                var6_7 = null;
                try {
                    try {
                        throw new ServiceException(GETMAPValidator.getErrorMessage((InputStream)in, (List)errors));
                    }
                    catch (Throwable throwable) {
                        var6_7 = throwable;
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        if (var6_7 != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                var6_7.addSuppressed(throwable2);
                            }
                        } else {
                            in.close();
                        }
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException e) {
            String msg = new StringBuffer("Creating remote GETMAP url: ").append(e.getMessage()).toString();
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, msg, e);
            }
            throw new ServiceException((Throwable)e, msg, "GETMAP validator");
        }
    }

    public GetMapRequest createRequest() {
        GetMapRequest request = new GetMapRequest();
        return request;
    }
}

