/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.image.RenderedImage;
import java.util.stream.IntStream;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMS;

class Tally {
    static final int UNLIMITED = -1;
    private int maxMemory;
    private int usedMemory;

    public Tally(int maxMemory) {
        this.maxMemory = maxMemory;
        this.usedMemory = 0;
    }

    public Tally(WMS wms) {
        this.maxMemory = wms != null && wms.getMaxRequestMemory() > 0 ? wms.getMaxRequestMemory() * 1024 : -1;
    }

    public void addImage(RenderedImage image) {
        if (this.maxMemory != -1) {
            int imageSize = Tally.computeImageSize(image);
            if ((long)this.usedMemory + (long)imageSize > (long)this.maxMemory) {
                throw new ServiceException("Max legend graphic memory usage exceeded.", "MaxMemoryExceeded");
            }
            this.usedMemory += imageSize;
        }
    }

    public static int computeImageSize(RenderedImage image) {
        int pixelSize = IntStream.of(image.getSampleModel().getSampleSize()).sum() / 8;
        return image.getWidth() * image.getHeight() * pixelSize;
    }

    public Tally getRemaining() {
        return new Tally(this.maxMemory - this.usedMemory);
    }

    public Tally getFull() {
        return new Tally(this.maxMemory);
    }

    public int getMaxMemory() {
        return this.maxMemory;
    }

    public int getUsedMemory() {
        return this.usedMemory;
    }
}

