/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.legendgraphic.ImageList;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geoserver.wms.map.ImageUtils;
import org.geotools.styling.Rule;

public class LegendMerger {
    public static BufferedImage mergeRasterLegends(MergeOptions mergeOptions) {
        ImageList imageStack = mergeOptions.getImageStack();
        LegendUtils.LegendLayout layout = mergeOptions.getLayout();
        ImageList nodes = new ImageList(imageStack.getTally().getFull());
        for (RenderedImage renderedImage : imageStack) {
            nodes.add((BufferedImage)renderedImage);
        }
        BufferedImage finalLegend = null;
        if (layout == LegendUtils.LegendLayout.HORIZONTAL) {
            Row[] rows = LegendMerger.createRows(nodes, mergeOptions.getRowWidth(), mergeOptions.getRows());
            finalLegend = LegendMerger.buildFinalHLegend(rows, mergeOptions);
        } else if (layout == LegendUtils.LegendLayout.VERTICAL) {
            Column[] columns = LegendMerger.createColumns(nodes, mergeOptions.getColumnHeight(), mergeOptions.getColumns(), null, false);
            finalLegend = LegendMerger.buildFinalVLegend(columns, mergeOptions);
        }
        return finalLegend;
    }

    public static BufferedImage mergeLegends(Rule[] rules, GetLegendGraphicRequest req, MergeOptions mergeOptions) {
        ImageList imageStack = mergeOptions.getImageStack();
        int imgCount = imageStack.size();
        ImageList nodes = new ImageList(imageStack.getTally().getFull());
        if (!(imgCount != 1 || mergeOptions.isForceLabelsOn() && rules != null)) {
            return imageStack.get(0);
        }
        for (int i = 0; i < imgCount; ++i) {
            BufferedImage img = imageStack.get(i);
            if (rules != null && rules[i] != null) {
                BufferedImage label = LegendMerger.renderLabel(img, rules[i], req, mergeOptions);
                if (label != null) {
                    img = LegendMerger.joinBufferedImageHorizzontally(img, label, mergeOptions.getLabelFont(), mergeOptions.isAntialias(), mergeOptions.isTransparent(), mergeOptions.getBackgroundColor(), mergeOptions.getLabelMargin());
                }
                nodes.add(img);
                continue;
            }
            nodes.add(img);
        }
        LegendUtils.LegendLayout layout = mergeOptions.getLayout();
        BufferedImage finalLegend = null;
        if (layout == LegendUtils.LegendLayout.HORIZONTAL) {
            Row[] rows = LegendMerger.createRows(nodes, mergeOptions.getRowWidth(), mergeOptions.getRows());
            finalLegend = LegendMerger.buildFinalHLegend(rows, mergeOptions);
        } else if (layout == LegendUtils.LegendLayout.VERTICAL) {
            Column[] columns = LegendMerger.createColumns(nodes, mergeOptions.getColumnHeight(), mergeOptions.getColumns(), req, true);
            finalLegend = LegendMerger.buildFinalVLegend(columns, mergeOptions);
        }
        return finalLegend;
    }

    public static BufferedImage mergeGroups(Rule[] rules, MergeOptions mergeOptions) {
        ImageList imageStack = mergeOptions.getImageStack();
        int imgCount = imageStack.size();
        if (!(imgCount != 1 || mergeOptions.isForceLabelsOn() && rules != null)) {
            return imageStack.get(0);
        }
        ImageList nodes = new ImageList(imageStack.getTally().getFull());
        if (mergeOptions.isForceTitlesOff()) {
            for (BufferedImage img : imageStack) {
                nodes.add(img);
            }
        } else {
            for (int i = 0; i < imgCount; i += 2) {
                BufferedImage lbl = imageStack.get(i);
                BufferedImage img = imageStack.get(i + 1);
                img = LegendMerger.joinBufferedImageVertically(lbl, img, mergeOptions.getLabelFont(), mergeOptions.isAntialias(), mergeOptions.isTransparent(), mergeOptions.getBackgroundColor());
                nodes.add(img);
            }
        }
        LegendUtils.LegendLayout layout = mergeOptions.getLayout();
        BufferedImage finalLegend = null;
        if (layout == LegendUtils.LegendLayout.HORIZONTAL) {
            Row[] rows = LegendMerger.createRows(nodes, 0, 0);
            finalLegend = LegendMerger.buildFinalHLegend(rows, mergeOptions);
        }
        if (layout == LegendUtils.LegendLayout.VERTICAL) {
            Column[] columns = LegendMerger.createColumns(nodes, 0, 0, null, false);
            finalLegend = LegendMerger.buildFinalVLegend(columns, mergeOptions);
        }
        return finalLegend;
    }

    private static Column[] createColumns(ImageList nodes, int maxHeight, int maxColumns, GetLegendGraphicRequest req, boolean checkColor) {
        Column[] legendMatrix = new Column[]{};
        if (maxHeight > 0) {
            int cnLimit = maxColumns > 0 ? maxColumns : nodes.size();
            legendMatrix = new Column[cnLimit];
            legendMatrix[0] = new Column();
            int cn = 0;
            int columnHeight = 0;
            for (int i = 0; i < nodes.size(); ++i) {
                BufferedImage node = nodes.get(i);
                if (columnHeight <= maxHeight) {
                    legendMatrix[cn].addNode(node);
                    columnHeight += node.getHeight();
                    continue;
                }
                --i;
                if (++cn != cnLimit) {
                    columnHeight = 0;
                    legendMatrix[cn] = new Column();
                    continue;
                }
                break;
            }
        } else {
            int colNumber = maxColumns > 0 ? maxColumns : 1;
            legendMatrix = new Column[colNumber];
            legendMatrix[0] = new Column();
            int rowNumber = (int)Math.ceil((float)nodes.size() / (float)colNumber);
            int cn = 0;
            int rc = 0;
            boolean colourPresent = false;
            for (int i = 0; i < nodes.size(); ++i) {
                if (rc < rowNumber) {
                    if (checkColor) {
                        colourPresent = LegendMerger.checkColor(nodes.get(i), req);
                        if (!colourPresent) continue;
                        legendMatrix[cn].addNode(nodes.get(i));
                        ++rc;
                        continue;
                    }
                    legendMatrix[cn].addNode(nodes.get(i));
                    ++rc;
                    continue;
                }
                --i;
                rc = 0;
                legendMatrix[++cn] = new Column();
            }
        }
        return legendMatrix;
    }

    public static boolean checkColor(BufferedImage img, GetLegendGraphicRequest req) {
        int w = img.getWidth();
        int h = img.getHeight();
        boolean colourPresent = false;
        for (int j = 0; j < w; ++j) {
            for (int k = 0; k < h; ++k) {
                if (img.getRGB(j, k) == LegendUtils.getBackgroundColor(req).getRGB()) continue;
                colourPresent = true;
            }
        }
        return colourPresent;
    }

    private static Row[] createRows(ImageList nodes, int maxWidth, int maxRows) {
        Row[] legendMatrix = new Row[]{};
        if (maxWidth > 0) {
            int rnLimit = maxRows > 0 ? maxRows : nodes.size();
            legendMatrix = new Row[rnLimit];
            legendMatrix[0] = new Row();
            int rn = 0;
            int rowWidth = 0;
            for (int i = 0; i < nodes.size(); ++i) {
                BufferedImage node = nodes.get(i);
                if (rowWidth <= maxWidth) {
                    legendMatrix[rn].addNode(node);
                    rowWidth += node.getWidth();
                    continue;
                }
                --i;
                if (++rn != rnLimit) {
                    rowWidth = 0;
                    legendMatrix[rn] = new Row();
                    continue;
                }
                break;
            }
        } else {
            int rowNumber = maxRows > 0 ? maxRows : 1;
            legendMatrix = new Row[rowNumber];
            legendMatrix[0] = new Row();
            int colNumber = (int)Math.ceil((float)nodes.size() / (float)rowNumber);
            int rn = 0;
            int cc = 0;
            for (int i = 0; i < nodes.size(); ++i) {
                if (cc < colNumber) {
                    legendMatrix[rn].addNode(nodes.get(i));
                    ++cc;
                    continue;
                }
                --i;
                cc = 0;
                legendMatrix[++rn] = new Row();
            }
        }
        return legendMatrix;
    }

    private static BufferedImage buildFinalVLegend(Column[] columns, MergeOptions options) {
        int totalWidth = 0;
        int totalHeight = 0;
        for (Column c : columns) {
            if (c == null) continue;
            if (totalWidth > 0) {
                totalWidth += options.getDx();
            }
            totalWidth += c.getWidth();
            int h = c.getHeight() + (c.nodes.size() - 1) * options.getDy();
            totalHeight = Math.max(totalHeight, h);
        }
        totalWidth += options.getMargin() * 2;
        BufferedImage finalLegend = ImageUtils.createImage(totalWidth += 2, totalHeight += options.getMargin() * 2, null, options.isTransparent());
        HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
        Graphics2D finalGraphics = ImageUtils.prepareTransparency(options.isTransparent(), options.getBackgroundColor(), finalLegend, hintsMap);
        if (options.isAntialias()) {
            finalGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            finalGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        int vOffset = options.getMargin();
        int hOffset = options.getMargin();
        for (Column c : columns) {
            if (c == null) continue;
            for (BufferedImage n : c.getNodes()) {
                finalGraphics.drawImage((Image)n, hOffset, vOffset, null);
                vOffset = vOffset + n.getHeight() + options.getDy();
            }
            hOffset = hOffset + c.getWidth() + options.getDx();
            vOffset = options.getMargin();
        }
        finalGraphics.dispose();
        return finalLegend;
    }

    private static BufferedImage buildFinalHLegend(Row[] rows, MergeOptions options) {
        int totalWidth = 0;
        int totalHeight = 0;
        for (Row r : rows) {
            if (r == null) continue;
            if (totalHeight > 0) {
                totalHeight += options.getDy();
            }
            totalHeight += r.getHeight();
            int w = r.getWidth() + (r.nodes.size() - 1) * options.getDx();
            totalWidth = Math.max(totalWidth, w);
        }
        totalWidth += options.getMargin() * 2;
        BufferedImage finalLegend = ImageUtils.createImage(totalWidth += 2, totalHeight += options.getMargin() * 2, null, options.isTransparent());
        HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
        Graphics2D finalGraphics = ImageUtils.prepareTransparency(options.isTransparent(), options.getBackgroundColor(), finalLegend, hintsMap);
        if (options.isAntialias()) {
            finalGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            finalGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        int vOffset = options.getMargin();
        int hOffset = options.getMargin();
        for (Row r : rows) {
            if (r == null) continue;
            for (BufferedImage n : r.getNodes()) {
                finalGraphics.drawImage((Image)n, hOffset, vOffset, null);
                hOffset = hOffset + n.getWidth() + options.getDx();
            }
            vOffset = vOffset + r.getHeight() + options.getDy();
            hOffset = options.getMargin();
        }
        finalGraphics.dispose();
        return finalLegend;
    }

    private static BufferedImage joinBufferedImageHorizzontally(BufferedImage img, BufferedImage label, Font labelFont, boolean useAA, boolean transparent, Color backgroundColor, int labelXOffset) {
        int wid = img.getWidth() + label.getWidth() + labelXOffset;
        int height = Math.max(img.getHeight(), label.getHeight());
        BufferedImage newImage = ImageUtils.createImage(wid, height, null, transparent);
        HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
        Graphics2D g2 = ImageUtils.prepareTransparency(transparent, backgroundColor, newImage, hintsMap);
        g2.setFont(labelFont);
        if (useAA) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        int imgOffset = (int)Math.round((double)(height - img.getHeight()) / 2.0);
        int labelYOffset = (int)Math.round((double)(height - label.getHeight()) / 2.0);
        g2.drawImage(img, null, 0, imgOffset);
        g2.drawImage(label, null, img.getWidth() + labelXOffset, labelYOffset);
        g2.dispose();
        return newImage;
    }

    private static BufferedImage joinBufferedImageVertically(BufferedImage label, BufferedImage img, Font labelFont, boolean useAA, boolean transparent, Color backgroundColor) {
        int offset = 0;
        int height = img.getHeight() + label.getHeight() + offset;
        int wid = Math.max(img.getWidth(), label.getWidth()) + offset;
        BufferedImage newImage = ImageUtils.createImage(wid, height, null, transparent);
        HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
        Graphics2D g2 = ImageUtils.prepareTransparency(transparent, backgroundColor, newImage, hintsMap);
        g2.setFont(labelFont);
        if (useAA) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        g2.drawImage(label, null, 0, 0);
        g2.drawImage(img, null, 0, label.getHeight());
        g2.dispose();
        return newImage;
    }

    private static BufferedImage renderLabel(RenderedImage img, Rule rule, GetLegendGraphicRequest req, MergeOptions options) {
        String label;
        BufferedImage labelImg = null;
        if (!options.isForceLabelsOff() && rule != null && (label = LegendUtils.getRuleLabel(rule, req)) != null && label.length() > 0) {
            BufferedImage renderedLabel;
            labelImg = renderedLabel = LegendMerger.getRenderedLabel((BufferedImage)img, label, req);
        }
        return labelImg;
    }

    protected static BufferedImage getRenderedLabel(BufferedImage image, String label, GetLegendGraphicRequest req) {
        Graphics2D graphics = image.createGraphics();
        Font labelFont = LegendUtils.getLabelFont(req);
        boolean useAA = LegendUtils.isFontAntiAliasing(req);
        graphics.setFont(labelFont);
        if (useAA) {
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        return LegendUtils.renderLabel(label, graphics, req);
    }

    private static class Row {
        private int width;
        private int height;
        private List<BufferedImage> nodes = new ArrayList<BufferedImage>();

        private Row() {
        }

        public void addNode(BufferedImage img) {
            this.nodes.add(img);
            this.height = Math.max(this.height, img.getHeight());
            this.width += img.getWidth();
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public List<BufferedImage> getNodes() {
            return this.nodes;
        }
    }

    private static class Column {
        private int width;
        private int height;
        private List<BufferedImage> nodes = new ArrayList<BufferedImage>();

        private Column() {
        }

        public void addNode(BufferedImage img) {
            this.nodes.add(img);
            this.width = Math.max(this.width, img.getWidth());
            this.height += img.getHeight();
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public List<BufferedImage> getNodes() {
            return this.nodes;
        }
    }

    public static class MergeOptions {
        ImageList imageStack;
        int dx;
        int dy;
        int margin;
        int labelMargin;
        Color backgroundColor;
        boolean transparent;
        boolean antialias;
        LegendUtils.LegendLayout layout;
        int rowWidth;
        int rows;
        int columnHeight;
        int columns;
        Font labelFont;
        boolean forceLabelsOn;
        boolean forceLabelsOff;
        boolean forceTitlesOff;

        public MergeOptions(ImageList imageStack, int dx, int dy, int margin, int labelMargin, Color backgroundColor, boolean transparent, boolean antialias, LegendUtils.LegendLayout layout, int rowWidth, int rows, int columnHeight, int columns, Font labelFont, boolean forceLabelsOn, boolean forceLabelsOff, boolean forceTitlesOff) {
            this.imageStack = imageStack;
            this.dx = dx;
            this.dy = dy;
            this.margin = margin;
            this.labelMargin = labelMargin;
            this.backgroundColor = backgroundColor;
            this.transparent = transparent;
            this.antialias = antialias;
            this.layout = layout;
            this.rowWidth = rowWidth;
            this.rows = rows;
            this.columnHeight = columnHeight;
            this.columns = columns;
            this.labelFont = labelFont;
            this.forceLabelsOn = forceLabelsOn;
            this.forceLabelsOff = forceLabelsOff;
            this.forceTitlesOff = forceTitlesOff;
        }

        public MergeOptions(ImageList imageStack, int dx, int dy, int margin, int labelMargin, GetLegendGraphicRequest req, boolean forceLabelsOn, boolean forceLabelsOff, boolean forceTitlesOff) {
            this(imageStack, dx, dy, margin, labelMargin, LegendUtils.getBackgroundColor(req), req.isTransparent(), LegendUtils.isFontAntiAliasing(req), LegendUtils.getLayout(req), LegendUtils.getRowWidth(req), LegendUtils.getRows(req), LegendUtils.getColumnHeight(req), LegendUtils.getColumns(req), LegendUtils.getLabelFont(req), forceLabelsOn, forceLabelsOff, forceTitlesOff);
        }

        public ImageList getImageStack() {
            return this.imageStack;
        }

        public void setImageStack(ImageList imageStack) {
            this.imageStack = imageStack;
        }

        public int getDx() {
            return this.dx;
        }

        public void setDx(int dx) {
            this.dx = dx;
        }

        public int getDy() {
            return this.dy;
        }

        public void setDy(int dy) {
            this.dy = dy;
        }

        public int getMargin() {
            return this.margin;
        }

        public void setMargin(int margin) {
            this.margin = margin;
        }

        public Color getBackgroundColor() {
            return this.backgroundColor;
        }

        public void setBackgroundColor(Color backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        public boolean isTransparent() {
            return this.transparent;
        }

        public void setTransparent(boolean transparent) {
            this.transparent = transparent;
        }

        public boolean isAntialias() {
            return this.antialias;
        }

        public void setAntialias(boolean antialias) {
            this.antialias = antialias;
        }

        public LegendUtils.LegendLayout getLayout() {
            return this.layout;
        }

        public void setLayout(LegendUtils.LegendLayout layout) {
            this.layout = layout;
        }

        public int getRowWidth() {
            return this.rowWidth;
        }

        public void setRowWidth(int rowWidth) {
            this.rowWidth = rowWidth;
        }

        public int getRows() {
            return this.rows;
        }

        public void setRows(int rows) {
            this.rows = rows;
        }

        public int getColumnHeight() {
            return this.columnHeight;
        }

        public void setColumnHeight(int columnHeight) {
            this.columnHeight = columnHeight;
        }

        public int getColumns() {
            return this.columns;
        }

        public void setColumns(int columns) {
            this.columns = columns;
        }

        public Font getLabelFont() {
            return this.labelFont;
        }

        public void setLabelFont(Font labelFont) {
            this.labelFont = labelFont;
        }

        public boolean isForceLabelsOn() {
            return this.forceLabelsOn;
        }

        public void setForceLabelsOn(boolean forceLabelsOn) {
            this.forceLabelsOn = forceLabelsOn;
        }

        public boolean isForceLabelsOff() {
            return this.forceLabelsOff;
        }

        public void setForceLabelsOff(boolean forceLabelsOff) {
            this.forceLabelsOff = forceLabelsOff;
        }

        public boolean isForceTitlesOff() {
            return this.forceTitlesOff;
        }

        public void setForceTitlesOff(boolean forceTitlesOff) {
            this.forceTitlesOff = forceTitlesOff;
        }

        public int getLabelMargin() {
            return this.labelMargin;
        }

        public void setLabelMargin(int labelMargin) {
            this.labelMargin = labelMargin;
        }

        public static MergeOptions createFromRequest(ImageList imageStack, int dx, int dy, int margin, int labelMargin, GetLegendGraphicRequest req, boolean forceLabelsOn, boolean forceLabelsOff, boolean forceTitlesOff) {
            return new MergeOptions(imageStack, dx, dy, margin, labelMargin, req, forceLabelsOn, forceLabelsOff, forceTitlesOff);
        }
    }
}

