/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.measure.Unit;
import javax.swing.Icon;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.CascadedLegendRequest;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.icons.IconProperties;
import org.geoserver.wms.icons.IconPropertyExtractor;
import org.geoserver.wms.icons.MiniRule;
import org.geoserver.wms.legendgraphic.LegendGraphicBuilder;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.Description;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.ExternalMark;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.LineSymbolizerImpl;
import org.geotools.styling.Mark;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PointSymbolizerImpl;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.PolygonSymbolizerImpl;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.RasterSymbolizerImpl;
import org.geotools.styling.Rule;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.TextSymbolizerImpl;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.style.ContrastMethod;
import org.opengis.style.GraphicLegend;
import org.opengis.style.GraphicalSymbol;
import org.opengis.util.InternationalString;

public class JSONLegendGraphicBuilder
extends LegendGraphicBuilder {
    public static final String ANCHOR_POINT = "anchor-point";
    public static final String ANCHOR_Y = "anchor-y";
    public static final String ANCHOR_X = "anchor-x";
    public static final String DISPLACEMENT = "displacement";
    public static final String DISPLACEMENT_Y = "displacement-y";
    public static final String DISPLACEMENT_X = "displacement-x";
    public static final String ELSE_FILTER = "ElseFilter";
    public static final String VENDOR_OPTIONS = "vendor-options";
    public static final String COLORMAP_TYPE = "type";
    public static final String CONTRAST_ENHANCEMENT = "contrast-enhancement";
    public static final String HISTOGRAM = "histogram";
    public static final String EXPONENTIAL = "exponential";
    public static final String LOGARITHMIC = "logarithmic";
    public static final String NORMALIZE = "normalize";
    public static final String GRAY = "gray";
    public static final String BLUE = "blue";
    public static final String GREEN = "green";
    public static final String RED = "red";
    public static final String GAMMA_VALUE = "gamma-value";
    public static final String STROKE_LINEJOIN = "stroke-linejoin";
    public static final String ABSTRACT = "abstract";
    public static final String COLOR = "color";
    public static final String COLORMAP = "colormap";
    public static final String ENTRIES = "entries";
    public static final String EXTERNAL_GRAPHIC_TYPE = "external-graphic-type";
    public static final String EXTERNAL_GRAPHIC_URL = "external-graphic-url";
    public static final String FILL = "fill";
    public static final String FILL_OPACITY = "fill-opacity";
    public static final String FILTER = "filter";
    public static final String FONT_FAMILY = "font-family";
    public static final String FONT_SIZE = "font-size";
    public static final String FONT_STYLE = "font-style";
    public static final String FONT_WEIGHT = "font-weight";
    public static final String FONTS = "fonts";
    public static final String FORMAT = "format";
    public static final String GEOMETRY = "geometry";
    public static final String GRAPHIC_FILL = "graphic-fill";
    public static final String GRAPHIC_STROKE = "graphic-stroke";
    public static final String GRAPHICS = "graphics";
    public static final String HALO = "halo";
    public static final String ICON = "icon";
    public static final String LABEL = "label";
    public static final String LABEL_PLACEMENT = "label-placement";
    public static final String LAYER_NAME = "layerName";
    public static final String LEGEND = "Legend";
    public static final String LEGEND_GRAPHIC = "LegendGraphic";
    public static final String LINE = "Line";
    public static final String MARK = "mark";
    public static final String NAME = "name";
    public static final String OPACITY = "opacity";
    public static final String PERPENDICULAR_OFFSET = "perpendicular-offset";
    public static final String POINT = "Point";
    public static final String POLYGON = "Polygon";
    public static final String QUANTITY = "quantity";
    public static final String RADIUS = "radius";
    public static final String RASTER = "Raster";
    public static final String ROTATION = "rotation";
    public static final String RULES = "rules";
    public static final String SIZE = "size";
    public static final String STROKE = "stroke";
    public static final String STROKE_DASHARRAY = "stroke-dasharray";
    public static final String STROKE_DASHOFFSET = "stroke-dashoffset";
    public static final String STROKE_OPACITY = "stroke-opacity";
    public static final String STROKE_WIDTH = "stroke-width";
    public static final String SYMBOLIZERS = "symbolizers";
    public static final String TEXT = "Text";
    public static final String TITLE = "title";
    public static final String TYPE = "type";
    public static final String UOM = "uom";
    public static final String X_ANCHOR = "x-anchor";
    public static final String X_DISPLACEMENT = "x-displacement";
    public static final String Y_ANCHOR = "y-anchor";
    public static final String Y_DISPLACEMENT = "y-displacement";
    public static final String STROKE_LINECAP = "stroke-linecap";
    public static final String GRAPHIC = "graphic";
    static Map<Class<?>, String> symbolizerNames = new HashMap();
    private Feature feature;
    private List<List<MiniRule>> miniStyle;
    private String styleName = "";
    private String layerName = "";
    private String baseURL = "";
    private WMS wms;
    private String ruleName;
    private int symbolizerCount;

    public JSONObject buildLegendGraphic(GetLegendGraphicRequest request) {
        this.setup(request);
        this.wms = request.getWms();
        Locale locale = request.getLocale();
        JSONObject response = new JSONObject();
        for (GetLegendGraphicRequest.LegendRequest legend : this.layers) {
            Object cascadedLegend;
            JSONArray cascadedRules22;
            Rule[] applicableRules;
            FeatureType layer = legend.getFeatureType();
            Style gt2Style = legend.getStyle();
            if ((gt2Style = this.applyRenderingSelection(gt2Style)) == null) {
                throw new NullPointerException("request.getStyle()");
            }
            this.miniStyle = MiniRule.minify(gt2Style, true);
            this.layerName = legend.getLayerName().getLocalPart();
            this.baseURL = request.getBaseUrl();
            this.styleName = legend.getStyleName();
            this.ruleName = legend.getRule();
            gt2Style = this.resizeForDPI(request, gt2Style);
            FeatureTypeStyle[] ftStyles = gt2Style.featureTypeStyles().toArray(new FeatureTypeStyle[0]);
            double scaleDenominator = request.getScale();
            if (this.ruleName != null) {
                Rule rule = LegendUtils.getRule(ftStyles, this.ruleName);
                if (rule == null) {
                    throw new ServiceException("Specified style does not contains a rule named " + this.ruleName);
                }
                applicableRules = new Rule[]{rule};
            } else {
                applicableRules = LegendUtils.getApplicableRules(ftStyles, scaleDenominator);
            }
            ArrayList<JSONObject> jRules = new ArrayList<JSONObject>();
            if (legend instanceof CascadedLegendRequest && (cascadedRules22 = ((CascadedLegendRequest)(cascadedLegend = (CascadedLegendRequest)legend)).getCascadedJSONRules()) != null && !cascadedRules22.isEmpty()) {
                for (int i = 0; i < cascadedRules22.size(); ++i) {
                    jRules.add(cascadedRules22.getJSONObject(i));
                }
                this.layerName = ((GetLegendGraphicRequest.LegendRequest)cascadedLegend).getLayer();
                applicableRules = new Rule[]{};
            }
            cascadedLegend = applicableRules;
            int cascadedRules22 = ((Rule[])cascadedLegend).length;
            for (int i = 0; i < cascadedRules22; ++i) {
                Filter filter;
                InternationalString abs;
                InternationalString title;
                Object rule = cascadedLegend[i];
                this.ruleName = rule.getName();
                JSONObject jRule = new JSONObject();
                String name = rule.getName();
                if (name != null && !name.isEmpty()) {
                    jRule.element(NAME, (Object)name);
                }
                if ((title = rule.getDescription().getTitle()) != null) {
                    jRule.element(TITLE, (Object)title.toString(locale));
                }
                if ((abs = rule.getDescription().getAbstract()) != null) {
                    jRule.element(ABSTRACT, (Object)abs.toString(locale));
                }
                if ((filter = rule.getFilter()) != null) {
                    jRule.element(FILTER, (Object)("[" + ECQL.toCQL((Filter)filter) + "]"));
                }
                if (rule.isElseFilter()) {
                    jRule.element(ELSE_FILTER, (Object)"true");
                }
                JSONArray jSymbolizers = new JSONArray();
                this.feature = layer != null ? this.getSampleFeatureForRule(layer, null, (Rule)rule) : null;
                List symbolizers = rule.symbolizers();
                this.symbolizerCount = 0;
                for (Symbolizer symbolizer : symbolizers) {
                    JSONObject jSymb = new JSONObject();
                    JSONObject symb = this.processSymbolizer(symbolizer);
                    jSymb.element(symbolizerNames.get(symbolizer.getClass()), (Map)symb);
                    jSymbolizers.add((Object)jSymb);
                }
                GraphicLegend l = rule.getLegend();
                if (l != null) {
                    for (GraphicalSymbol g : l.graphicalSymbols()) {
                        String href = IconPropertyExtractor.extractProperties(gt2Style, (SimpleFeature)this.feature).href(request.getBaseUrl(), legend.getLayer(), legend.getStyleName());
                        JSONObject jGraphicSymb = this.processGraphicalSymbol(g, href);
                        jGraphicSymb.element("url", (Object)href);
                        jRule.element(LEGEND_GRAPHIC, (Map)jGraphicSymb);
                    }
                }
                if (!jSymbolizers.isEmpty()) {
                    jRule.element(SYMBOLIZERS, (Collection)jSymbolizers);
                }
                jRules.add(jRule);
            }
            if (jRules.isEmpty()) continue;
            JSONArray legends = new JSONArray();
            if (response.containsKey((Object)LEGEND)) {
                legends = response.getJSONArray(LEGEND);
            }
            JSONObject jLayer = new JSONObject();
            jLayer.element(LAYER_NAME, (Object)this.layerName);
            jLayer = this.getLayerTitle(jLayer, legend);
            jLayer.element(RULES, jRules);
            legends.add((Object)jLayer);
            response.element(LEGEND, (Collection)legends);
        }
        return response;
    }

    private JSONObject getLayerTitle(JSONObject in, GetLegendGraphicRequest.LegendRequest legend) {
        String title = legend.getTitle();
        return in.element(TITLE, (Object)title);
    }

    private String toJSONValue(Expression exp, Class<?> type) {
        FilterAttributeExtractor extractor = new FilterAttributeExtractor();
        exp.accept((ExpressionVisitor)extractor, null);
        if (extractor.isConstantExpression()) {
            Object value = exp.evaluate((Object)this.feature, type);
            if (value != null && type.equals(Color.class)) {
                Color c = (Color)value;
                return String.format("#%02X%02X%02X", c.getRed(), c.getGreen(), c.getBlue());
            }
            if (value != null && type.isAssignableFrom(Number.class)) {
                Number n = (Number)value;
                if (!Double.isNaN(n.doubleValue()) && !Double.isInfinite(n.doubleValue())) {
                    return n.toString();
                }
            } else if (value != null) {
                return value.toString();
            }
        }
        return "'[" + ECQL.toCQL((Expression)exp) + "]'";
    }

    private JSONObject processColorMap(ColorMap colorMap, JSONObject ret) {
        boolean first = true;
        JSONArray entries = new JSONArray();
        for (ColorMapEntry entry : colorMap.getColorMapEntries()) {
            JSONObject ent = new JSONObject();
            Double qty = (Double)entry.getQuantity().evaluate(null, Double.class);
            if (colorMap.getType() == 2 && first && qty < 0.0 && Double.isInfinite(qty)) continue;
            first = false;
            ent.element(LABEL, (Object)entry.getLabel());
            ent.element(QUANTITY, (Object)this.toJSONValue(entry.getQuantity(), Number.class));
            ent.element(COLOR, (Object)this.toJSONValue(entry.getColor(), Color.class));
            Expression opac = entry.getOpacity();
            if (opac != null) {
                ent.element(OPACITY, (Object)this.toJSONValue(opac, Double.class));
            }
            entries.add((Object)ent);
        }
        JSONObject cm = new JSONObject();
        if (entries.size() > 0) {
            cm.element(ENTRIES, (Collection)entries);
            int type = colorMap.getType();
            switch (type) {
                case 2: {
                    cm.element("type", (Object)"intervals");
                    break;
                }
                case 1: {
                    cm.element("type", (Object)"ramp");
                    break;
                }
                case 3: {
                    cm.element("type", (Object)"values");
                }
            }
            ret.element(COLORMAP, (Map)cm);
        }
        return ret;
    }

    private JSONObject processFill(JSONObject ret, Fill fill) {
        if (fill == null) {
            return ret;
        }
        boolean filled = false;
        if (fill.getGraphicFill() != null) {
            filled = true;
            JSONObject jGraphic = new JSONObject();
            jGraphic = this.processGraphic(jGraphic, fill.getGraphicFill());
            ret.element(GRAPHIC_FILL, (Map)jGraphic);
        }
        if (!filled) {
            ret.element(FILL, (Object)this.toJSONValue(fill.getColor(), Color.class));
            ret.element(FILL_OPACITY, (Object)this.toJSONValue(fill.getOpacity(), Number.class));
        }
        return ret;
    }

    private JSONObject processGraphic(JSONObject ret, Graphic graphic) {
        AnchorPoint anc;
        Displacement disp;
        Expression rotation;
        Expression opacity;
        String jSize;
        WorkspaceInfo ws;
        if (graphic == null) {
            return ret;
        }
        Catalog catalog = this.wms.getCatalog();
        StyleInfo styleByName = catalog.getStyleByName(this.styleName);
        String wsName = null;
        if (styleByName != null && (ws = styleByName.getWorkspace()) != null) {
            wsName = ws.getName();
        }
        ArrayList<List<MiniRule>> newStyle = new ArrayList<List<MiniRule>>();
        ArrayList<Integer> origRuleNo = new ArrayList<Integer>();
        int ruleCount = 0;
        for (List<MiniRule> m : this.miniStyle) {
            ArrayList<MiniRule> newRules = new ArrayList<MiniRule>(this.miniStyle.size());
            for (MiniRule r : m) {
                String string = r.getName();
                if (string != null && !string.equalsIgnoreCase(this.ruleName)) {
                    ++ruleCount;
                    continue;
                }
                MiniRule n = new MiniRule((Filter)Filter.INCLUDE, r.isElseFilter, r.symbolizers);
                newRules.add(n);
                origRuleNo.add(ruleCount);
                ++ruleCount;
            }
            newStyle.add(newRules);
        }
        IconProperties props = IconPropertyExtractor.extractProperties(newStyle, (SimpleFeature)this.feature);
        String iconUrl = props.href(this.baseURL, wsName, this.styleName);
        int index = iconUrl.indexOf(63);
        if (index >= 0) {
            String[] refs;
            String base = iconUrl.substring(0, index + 1);
            for (String s : refs = iconUrl.substring(index + 1).split("&")) {
                if (s.matches("(\\d\\.)\\d(\\.\\d[\\.\\w+]*=[\\d.]*)")) {
                    String ref = s.replaceAll("(\\d\\.)\\d(\\.\\d=)", "$1" + origRuleNo.get(0) + "$2");
                    String[] split = s.split("\\.");
                    int symCount = Integer.parseInt(split[2].replaceAll("=", ""));
                    if (this.symbolizerCount != symCount) continue;
                    base = base + ref + "&";
                    continue;
                }
                base = base + s + "&";
            }
            iconUrl = base.endsWith("&") ? base.substring(0, base.length() - 1) : base;
        }
        ret.element("url", (Object)iconUrl);
        JSONArray jGraphics = new JSONArray();
        List gSymbols = graphic.graphicalSymbols();
        for (GraphicalSymbol g : gSymbols) {
            JSONObject jGraphic = this.processGraphicalSymbol(g, iconUrl);
            jGraphics.add((Object)jGraphic);
        }
        Expression expression = graphic.getSize();
        if (expression != null && !(jSize = this.toJSONValue(expression, Number.class)).equalsIgnoreCase("'[\"\"]'")) {
            ret.element(SIZE, (Object)jSize);
        }
        if ((opacity = graphic.getOpacity()) != null) {
            ret.element(OPACITY, (Object)this.toJSONValue(opacity, Number.class));
        }
        if ((rotation = graphic.getRotation()) != null) {
            ret.element(ROTATION, (Object)this.toJSONValue(rotation, Number.class));
        }
        if ((disp = graphic.getDisplacement()) != null) {
            JSONObject displacement = new JSONObject();
            displacement.element(DISPLACEMENT_X, (Object)disp.getDisplacementX());
            displacement.element(DISPLACEMENT_Y, (Object)disp.getDisplacementY());
            ret.element(DISPLACEMENT, (Map)displacement);
        }
        if ((anc = graphic.getAnchorPoint()) != null) {
            JSONObject anchor = new JSONObject();
            anchor.element(ANCHOR_X, (Object)anc.getAnchorPointX());
            anchor.element(ANCHOR_Y, (Object)anc.getAnchorPointY());
            ret.element(ANCHOR_POINT, (Map)anchor);
        }
        ret.element(GRAPHICS, (Collection)jGraphics);
        ++this.symbolizerCount;
        return ret;
    }

    private JSONObject processGraphicalSymbol(GraphicalSymbol g, String iconUrl) {
        JSONObject jGraphic = new JSONObject();
        if (g instanceof Mark) {
            Mark m = (Mark)g;
            Expression wkn = m.getWellKnownName();
            if (wkn != null) {
                jGraphic.element(MARK, (Object)this.toJSONValue(wkn, String.class));
            }
            jGraphic = this.processFill(jGraphic, m.getFill());
            jGraphic = this.processStroke(jGraphic, m.getStroke());
            ExternalMark em = m.getExternalMark();
            if (em != null) {
                Icon icon;
                OnLineResource or = em.getOnlineResource();
                if (or != null) {
                    try {
                        URL url = or.getLinkage().toURL();
                        if (url.getProtocol().equals("file")) {
                            jGraphic.element(EXTERNAL_GRAPHIC_URL, (Object)iconUrl);
                        } else {
                            jGraphic.element(EXTERNAL_GRAPHIC_URL, (Object)url.toString());
                        }
                    }
                    catch (MalformedURLException e) {
                        this.LOGGER.log(Level.WARNING, "", e);
                    }
                }
                if ((icon = em.getInlineContent()) != null) {
                    jGraphic.element(ICON, (Object)icon.toString());
                }
                jGraphic.element(FORMAT, (Object)em.getFormat());
            }
        } else if (g instanceof ExternalGraphic) {
            ExternalGraphic eg = (ExternalGraphic)g;
            try {
                URL url = eg.getOnlineResource().getLinkage().toURL();
                if (url.getProtocol().equals("file")) {
                    jGraphic.element(EXTERNAL_GRAPHIC_URL, (Object)iconUrl);
                } else {
                    jGraphic.element(EXTERNAL_GRAPHIC_URL, (Object)url.toString());
                }
            }
            catch (MalformedURLException e) {
                this.LOGGER.log(Level.WARNING, "", e);
            }
            jGraphic.element(EXTERNAL_GRAPHIC_TYPE, (Object)eg.getFormat());
        }
        return jGraphic;
    }

    private JSONObject processLineSymbolizer(JSONObject ret, LineSymbolizer symbolizer) {
        ret = this.processStroke(ret, symbolizer.getStroke());
        if (symbolizer.getPerpendicularOffset() != null) {
            ret.element(PERPENDICULAR_OFFSET, (Object)this.toJSONValue(symbolizer.getPerpendicularOffset(), Number.class));
        }
        return ret;
    }

    private JSONObject processPointSymbolizer(JSONObject ret, PointSymbolizer symbolizer) {
        ret = this.processGraphic(ret, symbolizer.getGraphic());
        return ret;
    }

    private JSONObject processPolygonSymbolizer(JSONObject ret, PolygonSymbolizer symbolizer) {
        ret = this.processStroke(ret, symbolizer.getStroke());
        ret = this.processFill(ret, symbolizer.getFill());
        return ret;
    }

    private JSONObject processRasterSymbolizer(JSONObject ret, RasterSymbolizer symbolizer) {
        ret = this.processColorMap(symbolizer.getColorMap(), ret);
        Expression op = symbolizer.getOpacity();
        if (op != null) {
            ret.element(OPACITY, (Object)this.toJSONValue(op, Double.class));
        }
        ret = this.processChannelSelection(ret, symbolizer.getChannelSelection());
        ret = this.processContrastEnhancement(ret, symbolizer.getContrastEnhancement());
        return ret;
    }

    private JSONObject processContrastEnhancement(JSONObject ret, ContrastEnhancement contrastEnhancement) {
        if (contrastEnhancement != null) {
            ContrastMethod method;
            JSONObject ce = new JSONObject();
            Expression gammaValue = contrastEnhancement.getGammaValue();
            if (gammaValue != null) {
                ce.element(GAMMA_VALUE, (Object)this.toJSONValue(gammaValue, Number.class));
            }
            if (ContrastMethod.NORMALIZE == (method = contrastEnhancement.getMethod())) {
                ce.element(NORMALIZE, (Object)"true");
            } else if (ContrastMethod.HISTOGRAM == method) {
                ce.element(HISTOGRAM, (Object)"true");
            } else if (ContrastMethod.EXPONENTIAL == method) {
                ce.element(EXPONENTIAL, (Object)"true");
            } else if (ContrastMethod.LOGARITHMIC == method) {
                ce.element(LOGARITHMIC, (Object)"true");
            }
            ce = this.processVendorOptions(ce, contrastEnhancement.getOptions());
            if (!ce.isEmpty()) {
                ret.element(CONTRAST_ENHANCEMENT, (Map)ce);
            }
        }
        return ret;
    }

    private JSONObject processChannelSelection(JSONObject ret, ChannelSelection channelSelection) {
        if (channelSelection != null) {
            SelectedChannelType grayChannel;
            JSONObject chs = new JSONObject();
            SelectedChannelType[] rgbChannels = channelSelection.getRGBChannels();
            if (rgbChannels != null) {
                if (rgbChannels[0] != null) {
                    chs.element(RED, (Object)this.toJSONValue(rgbChannels[0].getChannelName(), String.class));
                }
                if (rgbChannels[1] != null) {
                    chs.element(GREEN, (Object)this.toJSONValue(rgbChannels[1].getChannelName(), String.class));
                }
                if (rgbChannels[2] != null) {
                    chs.element(BLUE, (Object)this.toJSONValue(rgbChannels[2].getChannelName(), String.class));
                }
            }
            if ((grayChannel = channelSelection.getGrayChannel()) != null) {
                chs.element(GRAY, (Object)this.toJSONValue(grayChannel.getChannelName(), String.class));
            }
        }
        return ret;
    }

    private JSONObject processStroke(JSONObject ret, Stroke stroke) {
        List dashArray;
        JSONObject jGraphic;
        if (stroke == null) {
            return ret;
        }
        boolean stroked = false;
        if (stroke.getGraphicStroke() != null) {
            stroked = true;
            jGraphic = new JSONObject();
            jGraphic = this.processGraphic(jGraphic, stroke.getGraphicStroke());
            ret.element(GRAPHIC_STROKE, (Map)jGraphic);
        }
        if (stroke.getGraphicFill() != null) {
            stroked = true;
            jGraphic = new JSONObject();
            jGraphic = this.processGraphic(jGraphic, stroke.getGraphicFill());
            ret.element(GRAPHIC_FILL, (Map)jGraphic);
        }
        if (!stroked) {
            ret.element(STROKE, stroke.getColor().evaluate((Object)this.feature));
            ret.element(STROKE_WIDTH, stroke.getWidth().evaluate((Object)this.feature));
        }
        if (stroke.getOpacity() != null) {
            ret.element(STROKE_OPACITY, (Object)this.toJSONValue(stroke.getOpacity(), Number.class));
        }
        if (stroke.getLineCap() != null) {
            ret.element(STROKE_LINECAP, (Object)this.toJSONValue(stroke.getLineCap(), String.class));
        }
        if (stroke.getLineJoin() != null) {
            ret.element(STROKE_LINEJOIN, (Object)this.toJSONValue(stroke.getLineJoin(), String.class));
        }
        if ((dashArray = stroke.dashArray()) != null && !dashArray.isEmpty()) {
            JSONArray dArray = new JSONArray();
            for (Expression e : dashArray) {
                dArray.add((Object)this.toJSONValue(e, Double.class));
            }
            ret.element(STROKE_DASHARRAY, (Collection)dArray);
            Expression dashOffset = stroke.getDashOffset();
            if (dashOffset != null) {
                ret.element(STROKE_DASHOFFSET, (Object)this.toJSONValue(dashOffset, Double.class));
            }
        }
        return ret;
    }

    private JSONObject processSymbolizer(Symbolizer symbolizer) {
        Expression geometry;
        Description desc;
        Unit uom;
        JSONObject ret = new JSONObject();
        String name = symbolizer.getName();
        if (name != null && !name.isEmpty()) {
            ret.element(NAME, (Object)name);
        }
        if ((uom = symbolizer.getUnitOfMeasure()) != null) {
            ret.element(UOM, (Object)uom.toString());
        }
        if ((desc = symbolizer.getDescription()) != null) {
            InternationalString abs;
            InternationalString title = desc.getTitle();
            if (title != null) {
                ret.element(TITLE, (Object)title.toString());
            }
            if ((abs = desc.getAbstract()) != null) {
                ret.element(ABSTRACT, (Object)abs.toString());
            }
        }
        if ((geometry = symbolizer.getGeometry()) != null) {
            ret.element(GEOMETRY, (Object)this.toJSONValue(geometry, Geometry.class));
        }
        if (symbolizer instanceof PointSymbolizer) {
            ret = this.processPointSymbolizer(ret, (PointSymbolizer)symbolizer);
        } else if (symbolizer instanceof LineSymbolizer) {
            ret = this.processLineSymbolizer(ret, (LineSymbolizer)symbolizer);
        } else if (symbolizer instanceof PolygonSymbolizer) {
            ret = this.processPolygonSymbolizer(ret, (PolygonSymbolizer)symbolizer);
        } else if (symbolizer instanceof RasterSymbolizer) {
            ret = this.processRasterSymbolizer(ret, (RasterSymbolizer)symbolizer);
        } else if (symbolizer instanceof TextSymbolizer) {
            ret = this.processTextSymbolizer(ret, (TextSymbolizer)symbolizer);
        } else {
            this.LOGGER.warning("unknown symbolizer type " + symbolizer.getClass().getName());
        }
        Map opts = symbolizer.getOptions();
        ret = this.processVendorOptions(ret, opts);
        return ret;
    }

    private JSONObject processVendorOptions(JSONObject ret, Map<String, ?> map) {
        if (!map.isEmpty()) {
            JSONObject vendorOpts = new JSONObject();
            for (Map.Entry<String, ?> opt : map.entrySet()) {
                if (opt.getValue() instanceof Expression) {
                    vendorOpts.element(opt.getKey(), (Object)this.toJSONValue((Expression)opt.getValue(), Object.class));
                    continue;
                }
                vendorOpts.element(opt.getKey(), opt.getValue());
            }
            ret.element(VENDOR_OPTIONS, (Map)vendorOpts);
        }
        return ret;
    }

    private JSONObject processTextSymbolizer(JSONObject ret, TextSymbolizer symbolizer) {
        ret.element(LABEL, (Object)this.toJSONValue(symbolizer.getLabel(), String.class));
        JSONArray fonts = new JSONArray();
        for (Font font : symbolizer.fonts()) {
            JSONObject jFont = new JSONObject();
            JSONArray jFam = new JSONArray();
            for (Expression family : font.getFamily()) {
                jFam.add((Object)this.toJSONValue(family, String.class));
            }
            jFont.element(FONT_FAMILY, (Collection)jFam);
            jFont.element(FONT_STYLE, (Object)this.toJSONValue(font.getStyle(), String.class));
            jFont.element(FONT_WEIGHT, (Object)this.toJSONValue(font.getWeight(), String.class));
            jFont.element(FONT_SIZE, (Object)this.toJSONValue(font.getSize(), Number.class));
            fonts.add((Object)jFont);
        }
        ret.element(FONTS, (Collection)fonts);
        ret = this.processFill(ret, symbolizer.getFill());
        if (symbolizer instanceof TextSymbolizer2) {
            TextSymbolizer2 tSymb = (TextSymbolizer2)symbolizer;
            JSONObject graphic = new JSONObject();
            graphic = this.processGraphic(graphic, tSymb.getGraphic());
            ret.element(GRAPHIC, (Map)graphic);
        }
        JSONObject jPlacement = new JSONObject();
        LabelPlacement placement = symbolizer.getLabelPlacement();
        if (placement instanceof PointPlacement) {
            PointPlacement pplacement = (PointPlacement)placement;
            AnchorPoint ap = pplacement.getAnchorPoint();
            if (ap != null) {
                jPlacement.element(X_ANCHOR, (Object)this.toJSONValue(ap.getAnchorPointX(), Number.class));
                jPlacement.element(Y_ANCHOR, (Object)this.toJSONValue(ap.getAnchorPointY(), Number.class));
            }
            jPlacement.element(ROTATION, (Object)this.toJSONValue(pplacement.getRotation(), Number.class));
            Displacement displacement = pplacement.getDisplacement();
            if (displacement != null) {
                jPlacement.element(X_DISPLACEMENT, (Object)this.toJSONValue(displacement.getDisplacementX(), Number.class));
                jPlacement.element(Y_DISPLACEMENT, (Object)this.toJSONValue(displacement.getDisplacementY(), Number.class));
            }
        }
        if (placement instanceof LinePlacement) {
            LinePlacement lPlacement = (LinePlacement)placement;
            jPlacement.element(PERPENDICULAR_OFFSET, (Object)this.toJSONValue(lPlacement.getPerpendicularOffset(), String.class));
        }
        ret.element(LABEL_PLACEMENT, (Map)jPlacement);
        Halo halo = symbolizer.getHalo();
        if (halo != null) {
            JSONObject jHalo = new JSONObject();
            jHalo.element(RADIUS, (Object)this.toJSONValue(halo.getRadius(), Number.class));
            jHalo = this.processFill(jHalo, halo.getFill());
            ret.element(HALO, (Map)jHalo);
        }
        return ret;
    }

    static {
        symbolizerNames.put(PolygonSymbolizer.class, POLYGON);
        symbolizerNames.put(LineSymbolizer.class, LINE);
        symbolizerNames.put(PointSymbolizer.class, POINT);
        symbolizerNames.put(RasterSymbolizer.class, RASTER);
        symbolizerNames.put(TextSymbolizer.class, TEXT);
        symbolizerNames.put(PolygonSymbolizerImpl.class, POLYGON);
        symbolizerNames.put(LineSymbolizerImpl.class, LINE);
        symbolizerNames.put(PointSymbolizerImpl.class, POINT);
        symbolizerNames.put(RasterSymbolizerImpl.class, RASTER);
        symbolizerNames.put(TextSymbolizerImpl.class, TEXT);
    }
}

