/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.impl.LayerGroupStyle;
import org.geoserver.catalog.impl.LegendInfoImpl;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.ServiceException;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wms.CascadedLegendRequest;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.capabilities.CapabilityUtil;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.util.NullProgressListener;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.ows.wms.WebMapServer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.util.URLs;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.geotools.xml.styling.SLDParser;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.ProgressListener;
import org.xml.sax.EntityResolver;

public class GetLegendGraphicKvpReader
extends KvpRequestReader {
    private static final Logger LOGGER = Logging.getLogger(GetLegendGraphicKvpReader.class);
    private static final StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
    private WMS wms;

    public GetLegendGraphicKvpReader(WMS wms) {
        super(GetLegendGraphicRequest.class);
        this.wms = wms;
    }

    public GetLegendGraphicRequest read(Object req, Map kvp, Map rawKvp) throws Exception {
        String language;
        GetLegendGraphicRequest request = (GetLegendGraphicRequest)super.read(req, kvp, rawKvp);
        request.setRawKvp(rawKvp);
        request.setKvp(kvp);
        request.setWms(this.wms);
        if (request.getVersion() == null || request.getVersion().length() == 0) {
            String version = (String)rawKvp.get("WMTVER");
            if (version == null) {
                version = this.wms.getVersion();
            }
            request.setVersion(version);
        }
        if ((language = (String)rawKvp.get("LANGUAGE")) != null) {
            request.setLocale(new Locale(language));
        }
        String layer = (String)rawKvp.get("LAYER");
        boolean strict = rawKvp.containsKey("STRICT") ? Boolean.valueOf((String)rawKvp.get("STRICT")).booleanValue() : request.isStrict();
        request.setStrict(strict);
        if (strict && layer == null) {
            throw new ServiceException("LAYER parameter not present for GetLegendGraphic", "LayerNotDefined");
        }
        if (strict && request.getFormat() == null) {
            throw new ServiceException("Missing FORMAT parameter for GetLegendGraphic", "MissingFormat");
        }
        LayerInfo infoObject = null;
        ArrayList<GetLegendGraphicRequest.LegendRequest> layers = new ArrayList<GetLegendGraphicRequest.LegendRequest>();
        if (layer != null) {
            try {
                LayerInfo layerInfo = this.wms.getLayerByName(layer);
                if (layerInfo != null) {
                    GetLegendGraphicRequest.LegendRequest legend = null;
                    legend = layerInfo.getResource() instanceof WMSLayerInfo ? this.getCascadeLegendRequest(layerInfo, request) : this.addLayer(layerInfo, request);
                    legend.setLayer(layer);
                    layers.add(legend);
                    infoObject = layerInfo;
                }
                LayerGroupInfo layerGroupInfo = this.wms.getLayerGroupByName(layer);
                if (layerGroupInfo != null) {
                    String lgStyleName = (String)rawKvp.get("STYLE");
                    List<LayerInfo> groupLayers = this.getLayerGroupLayers(lgStyleName, layerGroupInfo);
                    for (LayerInfo singleLayer : groupLayers) {
                        GetLegendGraphicRequest.LegendRequest legend = null;
                        legend = singleLayer.getResource() instanceof WMSLayerInfo ? this.getCascadeLegendRequest(singleLayer, request) : this.addLayer(singleLayer, request);
                        legend.setLayerGroupInfo(layerGroupInfo);
                        layers.add(legend);
                    }
                    infoObject = layerGroupInfo;
                }
                throw new ServiceException(layer + " layer does not exist.");
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e);
            }
            catch (NoSuchElementException ne) {
                throw new ServiceException(new StringBuffer(layer).append(" layer does not exists.").toString(), (Throwable)ne);
            }
            catch (ServiceException se) {
                throw se;
            }
            catch (Exception te) {
                throw new ServiceException("Can't obtain the schema for the required layer.", (Throwable)te);
            }
        } else {
            GetLegendGraphicRequest.LegendRequest styleLegend = new GetLegendGraphicRequest.LegendRequest();
            layers.add(styleLegend);
        }
        request.getLegends().addAll(layers);
        if (request.getFormat() == null) {
            request.setFormat("image/png");
        }
        if (null == this.wms.getLegendGraphicOutputFormat(request.getFormat())) {
            throw new ServiceException(new StringBuffer("Invalid graphic format: ").append(request.getFormat()).toString(), "InvalidFormat");
        }
        try {
            this.parseOptionalParameters(request, infoObject, rawKvp);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return request;
    }

    private List<LayerInfo> getLayerGroupLayers(String styleName, LayerGroupInfo layerGroup) {
        List layers = null;
        if (styleName != null && !"".equals(styleName)) {
            boolean defaultStyle = this.isGroupDefaultStyle(styleName, layerGroup);
            boolean singleOrOpaque = LayerGroupHelper.isSingleOrOpaque((LayerGroupInfo)layerGroup);
            if (!defaultStyle && singleOrOpaque) {
                try {
                    layers = layerGroup.layers(styleName);
                }
                catch (NoSuchElementException e) {
                    this.throwNoSuchStyle(styleName);
                }
            }
        }
        if (layers == null) {
            layers = layerGroup.layers();
        }
        return layers;
    }

    private GetLegendGraphicRequest.LegendRequest getCascadeLegendRequest(LayerInfo layerInfo, GetLegendGraphicRequest request) throws IOException {
        WMSLayerInfo wmsLayerInfo = (WMSLayerInfo)layerInfo.getResource();
        WMSStoreInfo wmsStoreInfo = wmsLayerInfo.getStore();
        WebMapServer wmsServer = wmsStoreInfo.getWebMapServer(null);
        Object remoteLegendGraphicRequest = wmsServer.getCapabilities().getVersion().equalsIgnoreCase("1.3.0") ? new CascadedLegendRequest.GetLegendGraphicRequestV1_3_0(wmsServer.createGetMapRequest().getFinalURL(), "1.3.0") : wmsServer.createGetLegendGraphicRequest();
        remoteLegendGraphicRequest.setLayer(wmsLayerInfo.getNativeName());
        CascadedLegendRequest legend = new CascadedLegendRequest(request);
        legend.setRemoteLegendGraphicRequest((org.geotools.ows.wms.request.GetLegendGraphicRequest)remoteLegendGraphicRequest);
        legend.setLayer(layerInfo.getName());
        legend.setTitle(layerInfo.getTitle());
        legend.setLayerInfo(layerInfo);
        return legend;
    }

    private GetLegendGraphicRequest.LegendRequest addLayer(LayerInfo layerInfo, GetLegendGraphicRequest request) throws FactoryRegistryException, IOException, TransformException, SchemaException {
        FeatureType featureType = this.getLayerFeatureType(layerInfo);
        if (featureType != null) {
            LegendInfo legendInfo;
            GetLegendGraphicRequest.LegendRequest legend = new GetLegendGraphicRequest.LegendRequest(featureType, layerInfo.getResource().getQualifiedName());
            legend.setLayerInfo(layerInfo);
            MapLayerInfo mli = new MapLayerInfo(layerInfo, request.getLocale());
            if (mli.getLabel() != null) {
                legend.setTitle(mli.getLabel());
            }
            if ((legendInfo = this.resolveLegendInfo(layerInfo.getLegend(), request, null)) != null) {
                this.configureLegendInfo(request, legend, legendInfo);
            }
            return legend;
        }
        throw new ServiceException("Cannot get FeatureType for Layer", "MissingFeatureType");
    }

    private void configureLegendInfo(GetLegendGraphicRequest request, GetLegendGraphicRequest.LegendRequest legend, LegendInfo legendInfo) {
        legend.setLegendInfo(legendInfo);
        if (legendInfo.getHeight() > 0 && !request.getKvp().containsKey("HEIGHT")) {
            request.setHeight(legendInfo.getHeight());
        }
        if (legendInfo.getWidth() > 0 && !request.getKvp().containsKey("WIDTH")) {
            request.setWidth(legendInfo.getWidth());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LegendInfo resolveLegendInfo(LegendInfo legendInfo, GetLegendGraphicRequest request, StyleInfo context) {
        if (legendInfo == null) {
            return null;
        }
        String onlineResource = legendInfo.getOnlineResource();
        String baseUrl = request.getBaseUrl();
        if (onlineResource == null) {
            return null;
        }
        URL url = null;
        try {
            GeoServerDataDirectory dd;
            Resource styleParentResource;
            URI uri = new URI(onlineResource);
            GeoServerResourceLoader resources = this.wms.getCatalog().getResourceLoader();
            if (uri.isAbsolute()) {
                if (baseUrl == null || !onlineResource.startsWith(baseUrl + "styles/")) return legendInfo;
                onlineResource = onlineResource.substring(baseUrl.length() + 7);
            } else if (context != null && (styleParentResource = (dd = new GeoServerDataDirectory(resources)).get(context, new String[0])) != null && styleParentResource.getType() == Resource.Type.DIRECTORY) {
                url = URLs.fileToUrl((File)new File(styleParentResource.dir(), onlineResource));
            }
            if (url == null) {
                File styles = resources.findOrCreateDirectory("styles");
                URL base = URLs.fileToUrl((File)styles);
                url = new URL(base, onlineResource);
            }
        }
        catch (IOException | URISyntaxException invalid) {
            LOGGER.log(Level.FINER, "Unable to resolve " + onlineResource + " locally", invalid);
            return null;
        }
        LegendInfoImpl resolved = new LegendInfoImpl();
        resolved.setOnlineResource(url.toExternalForm());
        resolved.setFormat(legendInfo.getFormat());
        resolved.setHeight(legendInfo.getHeight());
        resolved.setWidth(legendInfo.getWidth());
        return resolved;
    }

    private FeatureType getLayerFeatureType(LayerInfo layerInfo) throws IOException, FactoryRegistryException, TransformException, SchemaException {
        MapLayerInfo mli = new MapLayerInfo(layerInfo);
        if (layerInfo.getType() == PublishedType.VECTOR) {
            FeatureType featureType = mli.getFeature().getFeatureType();
            return featureType;
        }
        if (layerInfo.getType() == PublishedType.RASTER) {
            CoverageInfo coverageInfo = mli.getCoverage();
            GridCoverage2DReader reader = (GridCoverage2DReader)coverageInfo.getGridCoverageReader((ProgressListener)new NullProgressListener(), GeoTools.getDefaultHints());
            SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverageReader((GridCoverage2DReader)reader, null);
            return feature.getSchema();
        }
        return null;
    }

    private void parseOptionalParameters(GetLegendGraphicRequest req, Object infoObj, Map rawKvp) throws IOException {
        this.parseStyleAndRule(req, infoObj, rawKvp);
    }

    private void parseStyleAndRule(GetLegendGraphicRequest req, Object infoObj, Map rawKvp) throws IOException {
        String rule;
        String listOfStyles = (String)rawKvp.get("STYLE");
        if (listOfStyles == null) {
            listOfStyles = "";
        }
        List styleNames = KvpUtils.readFlat((String)listOfStyles);
        String sldUrl = (String)rawKvp.get("SLD");
        String sldBody = (String)rawKvp.get("SLD_BODY");
        if ((sldBody != null || sldUrl != null) && this.wms.isDynamicStylingDisabled()) {
            throw new ServiceException("Dynamic style usage is forbidden");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("looking for styles ").append(listOfStyles).toString());
        }
        ArrayList<Style> sldStyles = new ArrayList<Style>();
        if (sldUrl != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("taking style from SLD parameter");
            }
            this.addStylesFrom(sldStyles, styleNames, this.loadRemoteStyle(sldUrl));
        } else if (sldBody != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("taking style from SLD_BODY parameter");
            }
            this.addStylesFrom(sldStyles, styleNames, this.parseSldBody(sldBody));
        } else if (!styleNames.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("taking style from STYLE parameter");
            }
            for (String styleName : styleNames) {
                LegendInfo legend;
                StyleInfo styleInfo;
                if (infoObj instanceof LayerGroupInfo) {
                    LayerGroupInfo layerGroupInfo = (LayerGroupInfo)infoObj;
                    boolean groupDefaultStyle = this.isGroupDefaultStyle(styleName, layerGroupInfo);
                    LayerGroupStyle lgStyle = null;
                    if (!groupDefaultStyle && LayerGroupHelper.isSingleOrOpaque((LayerGroupInfo)layerGroupInfo) && (lgStyle = LayerGroupHelper.getGroupStyleByName((LayerGroupInfo)layerGroupInfo, (String)styleName)) == null) {
                        this.throwNoSuchStyle(styleName);
                    }
                    this.addLayerGroupStyles(req, layerGroupInfo, sldStyles, lgStyle);
                    continue;
                }
                Style style = this.wms.getStyleByName(styleName);
                if (style == null) {
                    this.throwNoSuchStyle(styleName);
                }
                sldStyles.add(style);
                if (!(infoObj instanceof LayerInfo) || (styleInfo = this.wms.getCatalog().getStyleByName(styleName)) == null || (legend = this.resolveLegendInfo(styleInfo.getLegend(), req, styleInfo)) == null) continue;
                LayerInfo layerInfo = (LayerInfo)infoObj;
                Name name = layerInfo.getResource().getQualifiedName();
                GetLegendGraphicRequest.LegendRequest legendRequest = req.getLegend(name);
                if (legendRequest != null) {
                    this.configureLegendInfo(req, legendRequest, legend);
                    continue;
                }
                LOGGER.log(Level.FINE, "Unable to set LegendInfo for " + name);
            }
        } else if (infoObj instanceof LayerInfo) {
            LayerInfo layerInfo = (LayerInfo)infoObj;
            sldStyles.add(this.getStyleFromLayer(layerInfo));
            StyleInfo defaultStyle = layerInfo.getDefaultStyle();
            LegendInfo legend = this.resolveLegendInfo(defaultStyle.getLegend(), req, defaultStyle);
            if (legend != null) {
                Name name = layerInfo.getResource().getQualifiedName();
                GetLegendGraphicRequest.LegendRequest legendRequest = req.getLegend(name);
                if (legendRequest != null) {
                    this.configureLegendInfo(req, legendRequest, legend);
                } else {
                    LOGGER.log(Level.FINE, "Unable to set LegendInfo for " + name);
                }
            }
        } else if (infoObj instanceof LayerGroupInfo) {
            this.addLayerGroupStyles(req, (LayerGroupInfo)infoObj, sldStyles, null);
        }
        Iterator stylesIterator = sldStyles.iterator();
        for (GetLegendGraphicRequest.LegendRequest legend1 : req.getLegends()) {
            if (!stylesIterator.hasNext()) break;
            legend1.setStyle((Style)stylesIterator.next());
        }
        if ((rule = (String)rawKvp.get("RULE")) != null) {
            List ruleNames = KvpUtils.readFlat((String)rule);
            Iterator s = ruleNames.iterator();
            for (GetLegendGraphicRequest.LegendRequest legend : req.getLegends()) {
                if (!s.hasNext()) break;
                legend.setRule((String)s.next());
            }
        }
    }

    private void addLayerGroupStyles(GetLegendGraphicRequest req, LayerGroupInfo infoObj, List<Style> sldStyles, LayerGroupStyle lgStyle) throws IOException {
        LayerGroupInfo layerGroupInfo = infoObj;
        List groupLayers = lgStyle == null ? layerGroupInfo.layers() : layerGroupInfo.layers(lgStyle.getName().getName());
        List groupStyles = lgStyle == null ? layerGroupInfo.styles() : layerGroupInfo.styles(lgStyle.getName().getName());
        for (int count = 0; count < groupLayers.size(); ++count) {
            LayerInfo layerInfo = (LayerInfo)groupLayers.get(count);
            StyleInfo styleInfo = null;
            if (count < groupStyles.size() && groupStyles.get(count) != null) {
                styleInfo = (StyleInfo)groupStyles.get(count);
                sldStyles.add(styleInfo.getStyle());
            } else {
                sldStyles.add(this.getStyleFromLayer(layerInfo));
                styleInfo = layerInfo.getDefaultStyle();
            }
            LegendInfo legend = this.resolveLegendInfo(styleInfo.getLegend(), req, styleInfo);
            if (legend == null) continue;
            Name name = layerInfo.getResource().getQualifiedName();
            GetLegendGraphicRequest.LegendRequest legendRequest = req.getLegend(name);
            if (legendRequest != null) {
                this.configureLegendInfo(req, legendRequest, legend);
                continue;
            }
            LOGGER.log(Level.FINE, "Unable to set LegendInfo for " + name);
        }
    }

    private void throwNoSuchStyle(String styleName) {
        String msg = "No such style: " + styleName;
        throw new ServiceException(msg, "StyleNotDefined");
    }

    private boolean isGroupDefaultStyle(String styleName, LayerGroupInfo layerGroupInfo) {
        return styleName.equals("") || CapabilityUtil.encodeGroupDefaultStyle(this.wms, layerGroupInfo) && styleName.equals(CapabilityUtil.getGroupDefaultStyleName(layerGroupInfo));
    }

    private Style getStyleFromLayer(LayerInfo layerInfo) {
        MapLayerInfo mli = new MapLayerInfo(layerInfo);
        return mli.getDefaultStyle();
    }

    private void addStylesFrom(List<Style> sldStyles, List<String> styleNames, Style[] source) {
        if (styleNames.isEmpty()) {
            sldStyles.add(this.findStyle(null, source));
        } else {
            for (String styleName : styleNames) {
                sldStyles.add(this.findStyle(styleName, source));
            }
        }
    }

    private Style findStyle(String styleName, Style[] styles) throws NoSuchElementException {
        if (styles == null || styles.length == 0) {
            throw new NoSuchElementException("No styles have been provided to search for " + styleName);
        }
        if (styleName == null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("styleName is null, request in literal mode, returning first style");
            }
            return styles[0];
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("request in library mode, looking for style ").append(styleName).toString());
        }
        StringBuffer noMatchNames = new StringBuffer();
        for (int i = 0; i < styles.length; ++i) {
            if (styles[i] != null && styleName.equals(styles[i].getName())) {
                return styles[i];
            }
            noMatchNames.append(styles[i].getName());
            if (i >= styles.length) continue;
            noMatchNames.append(", ");
        }
        throw new NoSuchElementException(styleName + " not found. Provided style names: " + noMatchNames);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Style[] loadRemoteStyle(String sldUrl) throws ServiceException {
        try {
            URL url = new URL(sldUrl);
            try (InputStream in = url.openStream();){
                Style[] styleArray = this.parseSld(new InputStreamReader(in));
                return styleArray;
            }
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e, "Not a valid URL to an SLD document " + sldUrl, "loadRemoteStyle");
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e, "Can't open the SLD URL " + sldUrl, "loadRemoteStyle");
        }
    }

    private Style[] parseSldBody(String sldBody) throws ServiceException {
        return this.parseSld(new StringReader(sldBody));
    }

    private Style[] parseSld(Reader xmlIn) throws ServiceException {
        SLDParser parser = new SLDParser(styleFactory, xmlIn);
        EntityResolver entityResolver = this.wms.getCatalog().getResourcePool().getEntityResolver();
        if (entityResolver != null) {
            parser.setEntityResolver(entityResolver);
        }
        Style[] styles = null;
        try {
            styles = parser.readXML();
        }
        catch (RuntimeException e) {
            throw new ServiceException((Throwable)e);
        }
        if (styles == null || styles.length == 0) {
            throw new ServiceException("Document contains no styles");
        }
        return styles;
    }
}

