/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.text.WordUtils;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geotools.styling.ColorMapEntry;

public abstract class Cell {
    protected final Color bkgColor;
    protected final double bkgOpacity;
    protected final String text;
    protected final LegendUtils.HAlign hAlign;
    protected final LegendUtils.VAlign vAlign;
    protected final Dimension requestedDimension;
    protected final Font labelFont;
    protected final Color labelFontColor;
    protected final boolean fontAntiAliasing;
    protected final Color borderColor;
    protected final boolean wrap;
    protected int WRAP_WIDTH = 150;

    protected Cell(Color bkgColor, double bkgOpacity, String text, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAlign, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor, boolean wrap) {
        this.bkgColor = bkgColor;
        this.bkgOpacity = bkgOpacity;
        this.text = text;
        this.hAlign = hAlign;
        this.vAlign = vAlign;
        this.requestedDimension = requestedDimension;
        this.labelFont = labelFont;
        this.labelFontColor = labelFontColor;
        this.fontAntiAliasing = fontAntiAliasing;
        this.borderColor = borderColor;
        this.wrap = wrap;
    }

    public abstract void draw(Graphics2D var1, Rectangle2D var2, boolean var3);

    public abstract Dimension getPreferredDimension(Graphics2D var1);

    public static abstract class ColorManager
    extends Cell {
        public ColorManager(Color color, double opacity, Dimension requestedDimension, Color borderColor, boolean wrap) {
            super(color, opacity, null, null, null, requestedDimension, null, null, false, borderColor, wrap);
        }

        @Override
        public abstract void draw(Graphics2D var1, Rectangle2D var2, boolean var3);

        @Override
        public Dimension getPreferredDimension(Graphics2D graphics) {
            return new Dimension(this.requestedDimension);
        }

        public static class SimpleColorManager
        extends ColorManager {
            public SimpleColorManager(Color color, double opacity, Dimension requestedDimension, Color borderColor, boolean wrap) {
                super(color, opacity, requestedDimension, borderColor, wrap);
            }

            @Override
            public void draw(Graphics2D graphics, Rectangle2D clipBox, boolean completeBorder) {
                if (this.bkgOpacity > 0.0) {
                    Color oldColor = graphics.getColor();
                    Color newColor = new Color(this.bkgColor.getRed(), this.bkgColor.getGreen(), this.bkgColor.getBlue(), (int)(255.0 * this.bkgOpacity + 0.5));
                    graphics.setColor(newColor);
                    graphics.fill(clipBox);
                    graphics.setColor(this.borderColor);
                    if (completeBorder) {
                        int minx = (int)(clipBox.getMinX() + 0.5);
                        int miny = (int)(clipBox.getMinY() + 0.5);
                        int w = (int)(clipBox.getWidth() + 0.5) - 1;
                        int h = (int)(clipBox.getHeight() + 0.5) - 1;
                        graphics.draw(new Rectangle2D.Double(minx, miny, w, h));
                    }
                    graphics.setColor(oldColor);
                } else {
                    Color oldColor = graphics.getColor();
                    graphics.setColor(Color.white);
                    graphics.fill(clipBox);
                    graphics.setColor(Color.RED);
                    int minx = (int)(clipBox.getMinX() + 0.5);
                    int miny = (int)(clipBox.getMinY() + 0.5);
                    int maxx = (int)((double)minx + clipBox.getWidth() - 1.0 + 0.5);
                    int maxy = (int)((double)miny + clipBox.getHeight() - 1.0 + 0.5);
                    graphics.drawLine(minx, miny, maxx, maxy);
                    graphics.drawLine(minx, maxy, maxx, miny);
                    graphics.setColor(this.borderColor);
                    if (completeBorder) {
                        int w = (int)(clipBox.getWidth() + 0.5) - 1;
                        int h = (int)(clipBox.getHeight() + 0.5) - 1;
                        graphics.draw(new Rectangle2D.Double(minx, miny, w, h));
                    }
                    graphics.setColor(oldColor);
                }
            }

            public static class GradientColorManager
            extends SimpleColorManager {
                private Color previousColor = null;
                private boolean leftEdge;

                @Override
                public Dimension getPreferredDimension(Graphics2D graphics) {
                    return new Dimension(this.requestedDimension.width, (int)(1.5 * (double)this.requestedDimension.height + 0.5));
                }

                public GradientColorManager(Color color, double opacity, Color previousColor, Dimension requestedDimension, Color borderColor, boolean wrap) {
                    super(color, opacity, requestedDimension, borderColor, wrap);
                    this.previousColor = previousColor;
                    if (previousColor == null) {
                        this.leftEdge = true;
                    }
                }

                @Override
                public void draw(Graphics2D graphics, Rectangle2D clipBox, boolean completeBorder) {
                    Rectangle2D.Double rectLegend;
                    double minx = clipBox.getMinX();
                    double miny = clipBox.getMinY();
                    double w = clipBox.getWidth();
                    double h = clipBox.getHeight();
                    if (!this.leftEdge) {
                        rectLegend = new Rectangle2D.Double(minx, miny, w, h / 2.0);
                        Paint oldPaint = graphics.getPaint();
                        GradientPaint paint = new GradientPaint((float)minx, (float)miny, this.previousColor, (float)minx, (float)(miny + h / 2.0), this.bkgColor);
                        graphics.setPaint(paint);
                        graphics.fill(rectLegend);
                        graphics.setPaint(oldPaint);
                    }
                    rectLegend = new Rectangle2D.Double(minx, miny + (this.leftEdge ? 0.0 : h / 2.0), w, !this.leftEdge ? h / 2.0 : h);
                    super.draw(graphics, rectLegend, completeBorder);
                    if (completeBorder) {
                        Color oldColor = graphics.getColor();
                        graphics.setColor(this.borderColor);
                        int minx_ = (int)(clipBox.getMinX() + 0.5);
                        int maxx = (int)(minx + clipBox.getWidth() + 0.5) - 1;
                        int maxy = (int)(miny + clipBox.getHeight() + 0.5) - 1;
                        graphics.drawLine(minx_, maxy, maxx, maxy);
                        graphics.setColor(oldColor);
                    }
                }
            }
        }
    }

    public static class TextManager
    extends Cell {
        public TextManager(String text, LegendUtils.VAlign vAlign, LegendUtils.HAlign hAlign, Color bkgColor, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor, boolean wrap) {
            super(bkgColor, 1.0, text, hAlign, vAlign, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor, wrap);
        }

        @Override
        public Dimension getPreferredDimension(Graphics2D graphics) {
            String nText;
            Font oldFont = graphics.getFont();
            graphics.setFont(this.labelFont);
            int labelHeight = (int)Math.ceil(graphics.getFontMetrics().getStringBounds(this.text, graphics).getHeight());
            int width = (int)Math.ceil(graphics.getFontMetrics().getStringBounds(this.text, graphics).getWidth());
            int labelWidth = this.wrap ? Math.min(this.WRAP_WIDTH, width) : width;
            Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, labelWidth, labelHeight);
            graphics.setFont(oldFont);
            if (!this.wrap) {
                return new Dimension(labelWidth, labelHeight);
            }
            if (width > labelWidth) {
                FontMetrics fm = graphics.getFontMetrics();
                int widthChars = this.WRAP_WIDTH / fm.stringWidth("m");
                nText = WordUtils.wrap((String)this.text, (int)widthChars, (String)"\n", (boolean)true);
            } else {
                nText = this.text;
            }
            if (nText.indexOf("\n") != -1 || nText.indexOf("\\n") != -1) {
                ArrayList<Integer> lineHeight = new ArrayList<Integer>();
                String realLabel = nText.replaceAll("\\\\n", "\n");
                StringTokenizer st = new StringTokenizer(realLabel, "\n\r\f");
                while (st.hasMoreElements()) {
                    String token = st.nextToken();
                    Rectangle2D thisLineBounds = graphics.getFontMetrics().getStringBounds(token, graphics);
                    int thisLineHeight = (int)Math.ceil(thisLineBounds.getHeight());
                    bounds.add(0.0, (double)thisLineHeight + ((RectangularShape)bounds).getHeight());
                    bounds.add(thisLineBounds.getWidth(), 0.0);
                    lineHeight.add((int)Math.ceil(thisLineBounds.getHeight()));
                }
            }
            return new Dimension((int)Math.ceil(((RectangularShape)bounds).getWidth()), (int)Math.ceil(((RectangularShape)bounds).getHeight()));
        }

        @Override
        public void draw(Graphics2D graphics, Rectangle2D clipBox, boolean completeBorder) {
            int yText;
            int xText;
            Font oldFont = graphics.getFont();
            graphics.setColor(this.labelFontColor);
            graphics.setFont(this.labelFont);
            if (this.fontAntiAliasing) {
                graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            double minx = clipBox.getMinX();
            double miny = clipBox.getMinY();
            double w = clipBox.getWidth();
            double h = clipBox.getHeight();
            Dimension dimension = this.getPreferredDimension(graphics);
            switch (this.hAlign) {
                case CENTERED: {
                    xText = (int)(minx + (w - dimension.getWidth()) / 2.0 + 0.5);
                    break;
                }
                case LEFT: {
                    xText = (int)(minx + 0.5);
                    break;
                }
                case RIGHT: {
                    xText = (int)(minx + (w - dimension.getWidth()) + 0.5);
                    break;
                }
                case JUSTIFIED: {
                    throw new UnsupportedOperationException("Unsupported");
                }
                default: {
                    throw new IllegalStateException("Unsupported horizontal alignment " + (Object)((Object)this.hAlign));
                }
            }
            switch (this.vAlign) {
                case BOTTOM: {
                    yText = (int)(miny + h - (double)graphics.getFontMetrics().getDescent() + 0.5);
                    break;
                }
                case TOP: {
                    yText = (int)(miny + (double)graphics.getFontMetrics().getHeight() + 0.5);
                    break;
                }
                case MIDDLE: {
                    yText = (int)(miny + (h + (double)graphics.getFontMetrics().getHeight()) / 2.0 + 0.5);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported vertical alignment " + (Object)((Object)this.vAlign));
                }
            }
            if (this.wrap) {
                Rectangle2D labelBounds = this.labelFont.getStringBounds(this.text, graphics.getFontRenderContext());
                if (this.text.contains("\n") || this.text.contains("\\n") || labelBounds.getWidth() > dimension.getWidth()) {
                    FontMetrics fm = graphics.getFontMetrics();
                    int widthChars = (int)Math.floor(dimension.getWidth() / (double)fm.stringWidth("m"));
                    String realLabel = labelBounds.getWidth() > dimension.getWidth() ? WordUtils.wrap((String)this.text, (int)widthChars, (String)"\n", (boolean)true) : this.text;
                    StringTokenizer st = new StringTokenizer(realLabel, "\n\r\f");
                    int y = 0 - graphics.getFontMetrics().getDescent();
                    int c = 0;
                    Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
                    ArrayList<Integer> lineHeight = new ArrayList<Integer>();
                    realLabel = realLabel.replaceAll("\\\\n", "\n");
                    while (st.hasMoreElements()) {
                        String token = st.nextToken();
                        Rectangle2D thisLineBounds = graphics.getFontMetrics().getStringBounds(token, graphics);
                        int thisLineHeight = (int)Math.ceil(thisLineBounds.getHeight());
                        bounds.add(0.0, (double)thisLineHeight + ((RectangularShape)bounds).getHeight());
                        bounds.add(thisLineBounds.getWidth(), 0.0);
                        lineHeight.add((int)Math.ceil(thisLineBounds.getHeight()));
                    }
                    st = new StringTokenizer(realLabel, "\n\r\f");
                    while (st.hasMoreElements()) {
                        graphics.drawString(st.nextToken(), xText, y += ((Integer)lineHeight.get(c++)).intValue());
                    }
                } else {
                    graphics.drawString(this.text, xText, yText);
                }
            } else {
                graphics.drawString(this.text, xText, yText);
            }
            graphics.setFont(oldFont);
        }
    }

    public static class ClassesEntryLegendBuilder
    extends ColorMapEntryLegendBuilder {
        public ClassesEntryLegendBuilder(List<ColorMapEntry> mapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor, boolean wrap) {
            this(mapEntries, hAlign, vAling, bkgColor, bkgOpacity, text, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor, null, 0, false, wrap);
        }

        public ClassesEntryLegendBuilder(List<ColorMapEntry> mapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor, String unit, int digits, boolean wrap) {
            this(mapEntries, hAlign, vAling, bkgColor, bkgOpacity, text, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor, unit, digits, true, wrap);
        }

        public ClassesEntryLegendBuilder(List<ColorMapEntry> mapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor, String unit, int digits, boolean formatQuantity, boolean wrap) {
            String ruleText;
            ColorMapEntry previousCME = mapEntries.get(0);
            ColorMapEntry currentCME = mapEntries.get(1);
            boolean leftEdge = previousCME == null;
            Color color = LegendUtils.color(currentCME);
            double opacity = LegendUtils.getOpacity(currentCME);
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * opacity));
            super.add(new ColorManager.SimpleColorManager(color, opacity, requestedDimension, borderColor, wrap));
            String label = LegendUtils.getLabel(currentCME);
            double quantity1 = leftEdge ? LegendUtils.getQuantity(currentCME) : LegendUtils.getQuantity(previousCME);
            double quantity2 = LegendUtils.getQuantity(currentCME);
            String symbol1 = null;
            String symbol2 = null;
            if (leftEdge) {
                symbol1 = " < ";
            } else {
                symbol1 = " <= ";
                symbol2 = " < ";
            }
            if (formatQuantity) {
                ruleText = "";
                if (opacity > 0.0) {
                    String value1 = this.formatQuantity(quantity1, digits, unit);
                    String value2 = this.formatQuantity(quantity2, digits, unit);
                    ruleText = leftEdge ? "x" + symbol1 + value1 : (Double.isInfinite(quantity2) ? value1 + symbol1 + "x" : value1 + symbol1 + "x" + symbol2 + value2);
                }
            } else {
                String value1 = Double.toString(quantity1);
                String value2 = Double.toString(quantity2);
                ruleText = leftEdge ? "x" + symbol1 + value1 : (Double.isInfinite(quantity2) ? value1 + symbol1 + "x" : value1 + symbol1 + "x" + symbol2 + value2);
            }
            super.add(new TextManager(ruleText, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, leftEdge, borderColor, wrap));
            if (label != null) {
                this.hasLabel = true;
                super.add(new TextManager(label, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, leftEdge, borderColor, wrap));
            } else {
                super.add(null);
            }
        }
    }

    public static class RampColorMapEntryLegendBuilder
    extends ColorMapEntryLegendBuilder {
        private TextManager lastRuleManager;

        public RampColorMapEntryLegendBuilder(List<ColorMapEntry> mapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor, boolean wrap) {
            this(mapEntries, hAlign, vAling, bkgColor, bkgOpacity, text, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor, null, 0, false, wrap);
        }

        public RampColorMapEntryLegendBuilder(List<ColorMapEntry> mapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor, String unit, int digits, boolean wrap) {
            this(mapEntries, hAlign, vAling, bkgColor, bkgOpacity, text, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor, unit, digits, true, wrap);
        }

        public RampColorMapEntryLegendBuilder(List<ColorMapEntry> mapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor, String unit, int digits, boolean formatQuantity, boolean wrap) {
            String lastRuleText;
            String rule;
            Color previousColor;
            ColorMapEntry previousCME = mapEntries.get(0);
            ColorMapEntry currentCME = mapEntries.get(1);
            boolean leftEdge = previousCME == null;
            if (!leftEdge) {
                previousColor = LegendUtils.color(previousCME);
                double opacity = LegendUtils.getOpacity(previousCME);
                previousColor = new Color(previousColor.getRed(), previousColor.getGreen(), previousColor.getBlue(), (int)(255.0 * opacity + 0.5));
            } else {
                previousColor = null;
            }
            Color color = LegendUtils.color(currentCME);
            double opacity = LegendUtils.getOpacity(currentCME);
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * opacity));
            super.add(new ColorManager.SimpleColorManager.GradientColorManager(color, opacity, previousColor, requestedDimension, borderColor, wrap));
            String label = LegendUtils.getLabel(currentCME);
            double quantity = LegendUtils.getQuantity(currentCME);
            if (formatQuantity) {
                rule = "";
                lastRuleText = "";
                if (opacity > 0.0) {
                    String formattedQuantity = this.formatQuantity(quantity, digits, unit);
                    if (leftEdge) {
                        rule = formattedQuantity + " >= x";
                        lastRuleText = "";
                    } else {
                        rule = formattedQuantity + " ";
                        lastRuleText = formattedQuantity + " <= x";
                    }
                }
            } else {
                String formattedQuantity = Double.toString(quantity);
                if (leftEdge) {
                    rule = formattedQuantity + " >= x";
                    lastRuleText = "";
                } else {
                    rule = formattedQuantity + " = x";
                    lastRuleText = formattedQuantity + " <= x";
                }
            }
            super.add(new TextManager(rule, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, leftEdge, borderColor, wrap));
            this.lastRuleManager = new TextManager(lastRuleText, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, leftEdge, borderColor, wrap);
            if (label != null) {
                this.hasLabel = true;
                super.add(new TextManager(label, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, leftEdge, borderColor, wrap));
            } else {
                super.add(null);
            }
        }

        @Override
        protected void setLastRow() {
            this.set(this.lastRuleManager, 1);
        }
    }

    public static class SingleColorMapEntryLegendBuilder
    extends ColorMapEntryLegendBuilder {
        public SingleColorMapEntryLegendBuilder(List<ColorMapEntry> cMapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor, String unit, int digits, boolean formatQuantity, boolean wrap) {
            String rule;
            ColorMapEntry currentCME = cMapEntries.get(0);
            Color color = LegendUtils.color(currentCME);
            double opacity = LegendUtils.getOpacity(currentCME);
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * opacity));
            super.add(new ColorManager.SimpleColorManager(color, opacity, requestedDimension, borderColor, wrap));
            String label = LegendUtils.getLabel(currentCME);
            double quantity = LegendUtils.getQuantity(currentCME);
            String symbol = " = ";
            if (formatQuantity) {
                String value = this.formatQuantity(quantity, digits, unit);
                rule = value + " " + " = " + " x";
            } else {
                rule = Double.toString(quantity) + " " + " = " + " x";
            }
            super.add(new TextManager(rule, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor, wrap));
            if (label != null) {
                this.hasLabel = true;
                super.add(new TextManager(label, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor, wrap));
            } else {
                super.add(null);
            }
        }

        public SingleColorMapEntryLegendBuilder(List<ColorMapEntry> cMapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor, boolean wrap) {
            this(cMapEntries, hAlign, vAling, bkgColor, bkgOpacity, text, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor, null, 0, false, wrap);
        }

        public SingleColorMapEntryLegendBuilder(List<ColorMapEntry> cMapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor, String unit, int digits, boolean wrap) {
            this(cMapEntries, hAlign, vAling, bkgColor, bkgOpacity, text, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor, unit, digits, true, wrap);
        }
    }

    public static abstract class ColorMapEntryLegendBuilder
    extends Row {
        protected boolean hasLabel;

        protected ColorMapEntryLegendBuilder() {
        }

        protected ColorMapEntryLegendBuilder(List<Cell> columns) {
            super(columns);
        }

        protected ColorMapEntryLegendBuilder(ColorManager colorManager, TextManager labelManager, TextManager ruleManager) {
            super(Arrays.asList(colorManager, ruleManager, labelManager));
        }

        public boolean hasLabel() {
            return this.hasLabel;
        }

        public Cell getRuleManager() {
            return this.get(1);
        }

        public Cell getLabelManager() {
            return this.get(2);
        }

        public Cell getColorManager() {
            return this.get(0);
        }

        protected String formatQuantity(double quantity, int digits, String unit) {
            String format = "%." + digits + "f";
            return String.format(Locale.US, format, quantity) + (unit != null ? " " + unit : "");
        }

        protected void setLastRow() {
        }
    }

    public static abstract class Row {
        private final List<Cell> cells = new ArrayList<Cell>();

        Row() {
        }

        Row(List<Cell> cells) {
            this.cells.addAll(cells);
        }

        protected Cell get(int index) {
            return this.cells.get(index);
        }

        protected void add(Cell cell) {
            this.cells.add(cell);
        }

        protected void set(Cell cell, int idx) {
            this.cells.set(idx, cell);
        }
    }
}

