/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.icons;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.wms.icons.IconPropertyExtractor;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.opengis.filter.Filter;

public class MiniRule {
    public final Filter filter;
    public final boolean isElseFilter;
    public final List<Symbolizer> symbolizers;
    private String name;

    public MiniRule(Filter filter, boolean isElseFilter, List<Symbolizer> symbolizers) {
        this.filter = filter;
        this.isElseFilter = isElseFilter;
        this.symbolizers = symbolizers;
    }

    public static List<List<MiniRule>> minify(Style style) {
        return MiniRule.minify(style, false);
    }

    public static List<List<MiniRule>> minify(Style style, boolean includeNonPointGraphics) {
        ArrayList<List<MiniRule>> ftStyles = new ArrayList<List<MiniRule>>();
        for (FeatureTypeStyle ftStyle : style.featureTypeStyles()) {
            ArrayList<MiniRule> rules = new ArrayList<MiniRule>();
            for (Rule rule : ftStyle.rules()) {
                ArrayList<Symbolizer> graphicSymbolizers = new ArrayList<Symbolizer>();
                for (Symbolizer symbolizer : rule.symbolizers()) {
                    Graphic graphic = IconPropertyExtractor.getGraphic(symbolizer, includeNonPointGraphics);
                    if (graphic == null) continue;
                    graphicSymbolizers.add(symbolizer);
                }
                if (graphicSymbolizers.isEmpty()) continue;
                MiniRule miniRule = new MiniRule(rule.getFilter(), rule.isElseFilter(), graphicSymbolizers);
                miniRule.setName(rule.getName());
                rules.add(miniRule);
            }
            if (rules.isEmpty()) continue;
            ftStyles.add(rules);
        }
        return ftStyles;
    }

    static Style makeStyle(StyleFactory factory, List<List<MiniRule>> ftStyles) {
        Style style = factory.createStyle();
        for (List<MiniRule> rules : ftStyles) {
            FeatureTypeStyle ftStyle = factory.createFeatureTypeStyle();
            for (MiniRule miniRule : rules) {
                if (miniRule.symbolizers.isEmpty()) continue;
                Rule realRule = factory.createRule();
                for (Symbolizer sym : miniRule.symbolizers) {
                    realRule.symbolizers().add(sym);
                }
                ftStyle.rules().add(realRule);
            }
            style.featureTypeStyles().add(ftStyle);
        }
        return style;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

