/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.media.jai.PlanarImage;
import org.apache.xml.utils.XMLChar;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.wms.FeatureInfoRequestParameters;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.clip.CroppedGridCoverage2DReader;
import org.geoserver.wms.featureinfo.ColorMapLabelMatcher;
import org.geoserver.wms.featureinfo.ColorMapLabelMatcherExtractor;
import org.geoserver.wms.featureinfo.LayerIdentifier;
import org.geoserver.wms.featureinfo.VectorBasicLayerIdentifier;
import org.geoserver.wms.map.RasterSymbolizerVisitor;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.CoverageReadingTransformation;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.FilteringFeatureCollection;
import org.geotools.data.util.NullProgressListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.TransformedDirectPosition;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.util.XRectangle2D;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ImageUtilities;
import org.geotools.ows.ServiceException;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RenderingTransformationHelper;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.ProgressListener;

public class RasterLayerIdentifier
implements LayerIdentifier<GridCoverage2DReader> {
    static final Logger LOGGER = Logging.getLogger(RasterLayerIdentifier.class);
    private WMS wms;

    public RasterLayerIdentifier(WMS wms) {
        this.wms = wms;
    }

    @Override
    public boolean canHandle(MapLayerInfo layer) {
        int type = layer.getType();
        return type == MapLayerInfo.TYPE_RASTER;
    }

    @Override
    public List<FeatureCollection> identify(FeatureInfoRequestParameters requestParams, int maxFeatures) throws Exception {
        MapLayerInfo layer = requestParams.getLayer();
        Filter filter = requestParams.getFilter();
        SortBy[] sort = requestParams.getSort();
        CoverageInfo cinfo = layer.getCoverage();
        GridCoverage2DReader reader = this.handleClipParam(requestParams, (GridCoverage2DReader)cinfo.getGridCoverageReader((ProgressListener)new NullProgressListener(), GeoTools.getDefaultHints()));
        DirectPosition position = this.getQueryPosition(requestParams, cinfo, reader);
        if (!reader.getOriginalEnvelope().contains(position)) {
            return null;
        }
        GeneralParameterValue[] parameters = this.setupReadParameters(requestParams, layer, filter, sort, cinfo, reader, position);
        if (parameters == null) {
            return null;
        }
        ArrayList<FeatureCollection> result = new ArrayList<FeatureCollection>();
        boolean plainRenderingIdentified = false;
        for (FeatureTypeStyle fts : requestParams.getStyle().featureTypeStyles()) {
            if (fts.getTransformation() == null && plainRenderingIdentified) continue;
            plainRenderingIdentified |= fts.getTransformation() == null;
            Object info = this.read(requestParams, reader, parameters, fts);
            if (info instanceof GridCoverage2D) {
                GridCoverage2D coverage = (GridCoverage2D)info;
                result.addAll(this.toFeatures(cinfo, coverage, position, requestParams));
                continue;
            }
            if (info instanceof FeatureCollection) {
                FeatureCollection fc = (FeatureCollection)info;
                result.add(this.filterCollection(fc, requestParams));
                continue;
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("Unable to load raster data for this request.");
        }
        return result;
    }

    private FeatureCollection filterCollection(FeatureCollection fc, FeatureInfoRequestParameters params) {
        int requestBuffer = params.getBuffer() <= 0 ? VectorBasicLayerIdentifier.MIN_BUFFER_SIZE : params.getBuffer();
        ReferencedEnvelope bbox = LayerIdentifier.getEnvelopeFilter(params, requestBuffer);
        FilterFactory2 ff = params.getFilterFactory();
        BBOX filter = ff.bbox((Expression)ff.property(""), (BoundingBox)bbox);
        return new FilteringFeatureCollection(fc, (Filter)filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FeatureCollection> toFeatures(CoverageInfo cinfo, GridCoverage2D coverage, DirectPosition position, FeatureInfoRequestParameters requestParams) {
        SimpleFeatureCollection pixel = null;
        try {
            double[] pixelValues = coverage.evaluate(position, (double[])null);
            if (requestParams.isExcludeNodataResults() && this.pixelsAreNodata(coverage, pixelValues)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Returning no result due to nodata pixel");
                }
                for (int i = 0; i < pixelValues.length; ++i) {
                    pixelValues[i] = Double.NaN;
                }
            }
            ColorMapLabelMatcherExtractor labelVisitor = new ColorMapLabelMatcherExtractor(requestParams.getScaleDenominator());
            requestParams.getStyle().accept((StyleVisitor)labelVisitor);
            List<ColorMapLabelMatcher> colorMapLabelMatcherList = labelVisitor.getColorMapLabelMatcherList();
            pixel = this.wrapPixelInFeatureCollection(coverage, pixelValues, cinfo.getQualifiedName(), colorMapLabelMatcherList);
        }
        catch (PointOutsideCoverageException ri) {
        }
        finally {
            RenderedImage ri = coverage.getRenderedImage();
            coverage.dispose(true);
            if (ri instanceof PlanarImage) {
                ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
            }
        }
        return Collections.singletonList(pixel);
    }

    private GeneralParameterValue[] setupReadParameters(FeatureInfoRequestParameters requestParams, MapLayerInfo layer, Filter filter, SortBy[] sort, CoverageInfo cinfo, GridCoverage2DReader reader, DirectPosition position) throws IOException, TransformException, ServiceException {
        GetMapRequest getMap = requestParams.getGetMapRequest();
        GeneralParameterValue[] parameters = this.wms.getWMSReadParameters(getMap, layer, filter, sort, requestParams.getTimes(), requestParams.getElevations(), reader, true);
        MathTransform worldToGrid = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER).inverse();
        DirectPosition rasterMid = worldToGrid.transform(position, null);
        Rectangle2D.Double rasterArea = new Rectangle2D.Double();
        rasterArea.setFrameFromCenter(rasterMid.getOrdinate(0), rasterMid.getOrdinate(1), rasterMid.getOrdinate(0) + 2.0, rasterMid.getOrdinate(1) + 2.0);
        Rectangle integerRasterArea = rasterArea.getBounds();
        GridEnvelope gridEnvelope = reader.getOriginalGridRange();
        Object originalArea = gridEnvelope instanceof GridEnvelope2D ? (GridEnvelope2D)gridEnvelope : new Rectangle();
        XRectangle2D.intersect((Rectangle2D)integerRasterArea, (Rectangle2D)originalArea, (Rectangle2D)integerRasterArea);
        if (integerRasterArea.isEmpty()) {
            return null;
        }
        String[] propertyNames = requestParams.getPropertyNames();
        for (GeneralParameterValue generalParameterValue : parameters) {
            if (!(generalParameterValue instanceof Parameter)) continue;
            Parameter parameter = (Parameter)generalParameterValue;
            ReferenceIdentifier name = parameter.getDescriptor().getName();
            if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) {
                parameter.setValue((Object)new GridGeometry2D((GridEnvelope)new GridEnvelope2D(integerRasterArea), reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), reader.getCoordinateReferenceSystem()));
                continue;
            }
            if (propertyNames == null || propertyNames.length <= 0 || !name.equals(AbstractGridFormat.BANDS.getName())) continue;
            int[] bands = new int[propertyNames.length];
            HashSet<String> requestedNames = new HashSet<String>(Arrays.asList(propertyNames));
            List dimensionNames = cinfo.getDimensions().stream().map(d -> d.getName()).collect(Collectors.toList());
            int j = 0;
            for (int i = 0; i < dimensionNames.size() && !requestedNames.isEmpty(); ++i) {
                String dimensionName = (String)dimensionNames.get(i);
                if (!requestedNames.remove(dimensionName)) continue;
                bands[j++] = i;
            }
            if (!requestedNames.isEmpty() && !this.hasVectorTransformations(requestParams)) {
                String availableNames = dimensionNames.stream().collect(Collectors.joining(", "));
                throw new ServiceException("Could not find the following requested properties " + requestedNames + ", available property names are " + availableNames, "InvalidParameterValue", "PropertyName");
            }
            parameter.setValue((Object)bands);
        }
        return parameters;
    }

    private boolean hasVectorTransformations(FeatureInfoRequestParameters params) {
        Style style = params.getStyle();
        RasterSymbolizerVisitor visitor = new RasterSymbolizerVisitor(params.getScaleDenominator(), null);
        style.accept((StyleVisitor)visitor);
        CoverageReadingTransformation readingTx = visitor.getCoverageReadingTransformation();
        return readingTx != null || this.getTransformation(visitor) != null;
    }

    private DirectPosition getQueryPosition(FeatureInfoRequestParameters params, CoverageInfo cinfo, GridCoverage2DReader reader) {
        CoordinateReferenceSystem requestedCRS = params.getRequestedCRS();
        CoordinateReferenceSystem targetCRS = cinfo.getProjectionPolicy() == ProjectionPolicy.NONE || cinfo.getProjectionPolicy() == ProjectionPolicy.REPROJECT_TO_DECLARED ? cinfo.getNativeCRS() : cinfo.getCRS();
        Coordinate middle = WMS.pixelToWorld(params.getX(), params.getY(), params.getRequestedBounds(), params.getWidth(), params.getHeight());
        double x = middle.x;
        double y = middle.y;
        DirectPosition targetCoverageMedianPosition = reader.getOriginalEnvelope().getMedian();
        if (requestedCRS != null && requestedCRS instanceof GeographicCRS) {
            TransformedDirectPosition coverageMedianPosition = new TransformedDirectPosition(targetCRS, requestedCRS, new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
            try {
                coverageMedianPosition.transform(targetCoverageMedianPosition);
            }
            catch (TransformException exception) {
                throw new CannotEvaluateException("Cannot find coverage median position in requested CRS", (Throwable)exception);
            }
            if (CRS.getAxisOrder((CoordinateReferenceSystem)requestedCRS) == CRS.AxisOrder.NORTH_EAST) {
                y += (double)(360L * Math.round((coverageMedianPosition.getOrdinate(1) - y) / 360.0));
            } else {
                x += (double)(360L * Math.round((coverageMedianPosition.getOrdinate(0) - x) / 360.0));
            }
        }
        DirectPosition2D position = new DirectPosition2D(requestedCRS, x, y);
        if (requestedCRS != null) {
            TransformedDirectPosition arbitraryToInternal = new TransformedDirectPosition(requestedCRS, targetCRS, new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
            try {
                arbitraryToInternal.transform((DirectPosition)position);
            }
            catch (TransformException exception) {
                throw new CannotEvaluateException("Unable to answer the geatfeatureinfo", (Throwable)exception);
            }
            position = arbitraryToInternal;
        }
        if (targetCRS != null && targetCRS instanceof GeographicCRS) {
            x = position.getOrdinate(0);
            y = position.getOrdinate(1);
            if (CRS.getAxisOrder((CoordinateReferenceSystem)targetCRS) == CRS.AxisOrder.NORTH_EAST) {
                y += (double)(360L * Math.round((targetCoverageMedianPosition.getOrdinate(1) - y) / 360.0));
            } else {
                x += (double)(360L * Math.round((targetCoverageMedianPosition.getOrdinate(0) - x) / 360.0));
            }
            position = new DirectPosition2D(targetCRS, x, y);
        }
        return position;
    }

    private Object read(FeatureInfoRequestParameters params, GridCoverage2DReader reader, GeneralParameterValue[] parameters, FeatureTypeStyle fts) throws IOException, SchemaException, TransformException, FactoryException {
        RasterSymbolizerVisitor visitor = new RasterSymbolizerVisitor(params.getScaleDenominator(), null);
        fts.accept((StyleVisitor)visitor);
        CoverageReadingTransformation readingTx = visitor.getCoverageReadingTransformation();
        if (readingTx != null) {
            CoverageReadingTransformation.ReaderAndParams ctx = new CoverageReadingTransformation.ReaderAndParams(reader, parameters);
            return readingTx.evaluate((Object)ctx);
        }
        GridCoverage2D coverage = reader.read(parameters);
        Expression transformation = this.getTransformation(visitor);
        if (transformation != null) {
            RenderingTransformationHelper helper = new RenderingTransformationHelper(){

                protected GridCoverage2D readCoverage(GridCoverage2DReader reader, Object params, GridGeometry2D readGG) throws IOException {
                    throw new UnsupportedOperationException("This helper is meant to be used with a coverage already read");
                }
            };
            return helper.applyRenderingTransformation(transformation, (FeatureSource)DataUtilities.source((FeatureCollection)FeatureUtilities.wrapGridCoverage((GridCoverage2D)coverage)), Query.ALL, Query.ALL, null, coverage.getCoordinateReferenceSystem2D(), null);
        }
        if (!visitor.getRasterSymbolizers().isEmpty()) {
            return coverage;
        }
        return null;
    }

    private Expression getTransformation(RasterSymbolizerVisitor visitor) {
        Expression result = visitor.getRasterRenderingTransformation();
        if (result == null && visitor.getOtherRenderingTransformations().size() == 1) {
            result = visitor.getOtherRenderingTransformations().get(0);
        }
        return result;
    }

    private boolean pixelsAreNodata(GridCoverage2D coverage, double[] values) {
        RenderedImage ri = coverage.getRenderedImage();
        ImageWorker worker = new ImageWorker(ri);
        Range nodata = worker.getNoData();
        int nodataValues = 0;
        if (nodata != null) {
            for (double value : values) {
                if (!nodata.contains(value)) continue;
                ++nodataValues;
            }
        }
        return nodataValues == values.length;
    }

    private SimpleFeatureCollection wrapPixelInFeatureCollection(GridCoverage2D coverage, double[] pixelValues, Name coverageName, List<ColorMapLabelMatcher> colorMapLabelMatcherList) {
        GridSampleDimension[] sampleDimensions = coverage.getSampleDimensions();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(coverageName);
        boolean isLabelActive = !colorMapLabelMatcherList.isEmpty();
        boolean isLabelReplacingValue = ColorMapLabelMatcher.isLabelReplacingValue(colorMapLabelMatcherList);
        if (!isLabelReplacingValue) {
            this.addBandNamesToFeatureType(sampleDimensions, builder);
        }
        if (isLabelActive) {
            this.addLabelAttributeNameToFeatureType(colorMapLabelMatcherList, builder, coverage);
        }
        SimpleFeatureType gridType = builder.buildFeatureType();
        int labelSize = colorMapLabelMatcherList.size();
        int valuesLength = isLabelReplacingValue ? labelSize : (isLabelActive ? pixelValues.length + labelSize : pixelValues.length);
        Object[] values = new Object[valuesLength];
        ArrayList<String> labels = new ArrayList<String>();
        int lastOccupiedPosition = 0;
        for (int i = 0; i < pixelValues.length; ++i) {
            double pixelVal = pixelValues[i];
            if (isLabelActive) {
                this.addValueToLabelListByPixel(labels, colorMapLabelMatcherList, pixelVal, i);
            }
            if (isLabelReplacingValue) continue;
            values[i] = pixelVal;
            ++lastOccupiedPosition;
        }
        if (isLabelActive) {
            for (String label : labels) {
                values[lastOccupiedPosition] = label;
                ++lastOccupiedPosition;
            }
        }
        return DataUtilities.collection((SimpleFeature)SimpleFeatureBuilder.build((SimpleFeatureType)gridType, (Object[])values, (String)""));
    }

    private void addBandNamesToFeatureType(GridSampleDimension[] sampleDimensions, SimpleFeatureTypeBuilder builder) {
        HashSet<String> bandNames = new HashSet<String>();
        for (int i = 0; i < sampleDimensions.length; ++i) {
            String name = RasterLayerIdentifier.descriptionToNcName(sampleDimensions[i].getDescription().toString());
            if (bandNames.contains(name)) {
                name = name + "_Band" + i;
            }
            bandNames.add(name);
            builder.add(name, Double.class);
        }
    }

    private void addLabelAttributeNameToFeatureType(List<ColorMapLabelMatcher> colorMapLabelMatcherList, SimpleFeatureTypeBuilder builder, GridCoverage2D coverage) {
        int numLabel = ColorMapLabelMatcher.getLabelAttributeNameCount(colorMapLabelMatcherList);
        int indexLabel = 1;
        for (ColorMapLabelMatcher lifi : colorMapLabelMatcherList) {
            String label = lifi.getAttributeName();
            Integer channelName = lifi.getChannel();
            if (label.equals("Label")) {
                String labelIndexed = numLabel > 1 ? label + indexLabel : label;
                ++indexLabel;
                GridSampleDimension sampleDimension = channelName != null ? coverage.getSampleDimension(channelName - 1) : coverage.getSampleDimensions()[0];
                String sampleDimDesc = sampleDimension.getDescription().toString();
                label = labelIndexed + "_" + RasterLayerIdentifier.descriptionToNcName(sampleDimDesc);
            }
            builder.add(label, String.class);
        }
    }

    private void addValueToLabelListByPixel(List<String> labels, List<ColorMapLabelMatcher> colorMapLabelMatcherList, double pixel, int currentPixelIdx) {
        for (ColorMapLabelMatcher lifi : colorMapLabelMatcherList) {
            Integer channelName = lifi.getChannel();
            if (channelName != null && currentPixelIdx != channelName - 1) continue;
            labels.add(lifi.getLabelForPixel(pixel));
        }
    }

    static String descriptionToNcName(String description) {
        if (description == null || description.length() == 0) {
            return "Unknown";
        }
        char[] result = description.toCharArray();
        for (int i = 0; i < result.length; ++i) {
            if ((i != 0 || XMLChar.isNCNameStart((int)result[i])) && (i <= 0 || XMLChar.isNCName((int)result[i]))) continue;
            result[i] = 95;
        }
        return new String(result);
    }

    @Override
    public GridCoverage2DReader handleClipParam(FeatureInfoRequestParameters params, GridCoverage2DReader reader) {
        Geometry roiGeom = params.getGetMapRequest().getClip();
        if (roiGeom == null) {
            return reader;
        }
        return new CroppedGridCoverage2DReader(reader, roiGeom);
    }
}

