/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.geotools.renderer.style.DynamicSymbolFactoryFinder;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.NilExpression;
import org.opengis.style.GraphicalSymbol;

class DynamicSizeStyleExtractor
extends DuplicatingStyleVisitor {
    static final Logger LOGGER = Logging.getLogger(DynamicSizeStyleExtractor.class);
    boolean dynamic = false;

    DynamicSizeStyleExtractor() {
    }

    public void visit(Rule rule) {
        super.visit(rule);
        Rule copy = (Rule)this.pages.peek();
        ArrayList<Symbolizer> nonNullCopies = new ArrayList<Symbolizer>();
        for (Symbolizer s : copy.symbolizers()) {
            if (s == null) continue;
            nonNullCopies.add(s);
        }
        if (nonNullCopies.isEmpty()) {
            this.pages.pop();
            this.pages.push(null);
        } else {
            copy.symbolizers().clear();
            copy.symbolizers().addAll(nonNullCopies);
        }
    }

    public void visit(Fill fill) {
        boolean dynamicPrevious = false;
        try {
            super.visit(fill);
        }
        finally {
            this.dynamic = dynamicPrevious;
        }
    }

    public void visit(FeatureTypeStyle fts) {
        super.visit(fts);
        FeatureTypeStyle copy = (FeatureTypeStyle)this.pages.peek();
        ArrayList<Rule> nonNullCopies = new ArrayList<Rule>();
        for (Rule r : copy.rules()) {
            if (r == null) continue;
            nonNullCopies.add(r);
        }
        if (nonNullCopies.isEmpty()) {
            this.pages.pop();
            this.pages.push(null);
        } else {
            copy.rules().clear();
            copy.rules().addAll(nonNullCopies);
        }
    }

    public void visit(Style style) {
        super.visit(style);
        Style copy = (Style)this.pages.peek();
        ArrayList<FeatureTypeStyle> nonNullCopies = new ArrayList<FeatureTypeStyle>();
        for (FeatureTypeStyle ft : copy.featureTypeStyles()) {
            if (ft == null) continue;
            nonNullCopies.add(ft);
        }
        if (nonNullCopies.isEmpty()) {
            this.pages.pop();
            this.pages.push(null);
        } else {
            copy.featureTypeStyles().clear();
            copy.featureTypeStyles().addAll(nonNullCopies);
        }
    }

    public void visit(LineSymbolizer line) {
        this.dynamic = false;
        super.visit(line);
        if (!this.dynamic) {
            this.pages.pop();
            this.pages.push(null);
        }
    }

    public void visit(PolygonSymbolizer poly) {
        this.dynamic = false;
        super.visit(poly);
        if (!this.dynamic) {
            this.pages.pop();
            this.pages.push(null);
        }
    }

    public void visit(PointSymbolizer ps) {
        this.dynamic = false;
        super.visit(ps);
        if (!this.dynamic) {
            this.pages.pop();
            this.pages.push(null);
        }
    }

    public void visit(RasterSymbolizer raster) {
        this.pages.push(null);
    }

    public void visit(TextSymbolizer text) {
        this.pages.push(null);
    }

    public void visit(Graphic gr) {
        super.visit(gr);
        Expression sizeExpression = gr.getSize();
        if (!this.dynamic) {
            this.dynamic = sizeExpression == null || !(sizeExpression instanceof Literal) && !(sizeExpression instanceof NilExpression) || this.hasDynamicGraphic(gr);
        }
    }

    private boolean hasDynamicGraphic(Graphic gr) {
        for (GraphicalSymbol gs : gr.graphicalSymbols()) {
            if (!(gs instanceof ExternalGraphic)) continue;
            ExternalGraphic eg = (ExternalGraphic)gs;
            try {
                Icon icon = null;
                if (eg.getInlineContent() != null) {
                    icon = eg.getInlineContent();
                    continue;
                }
                String location = eg.getLocation().toExternalForm();
                Expression expanded = ExpressionExtractor.extractCqlExpressions((String)location);
                if (!(expanded instanceof Literal)) {
                    return true;
                }
                Iterator it = DynamicSymbolFactoryFinder.getExternalGraphicFactories();
                while (it.hasNext()) {
                    try {
                        icon = ((ExternalGraphicFactory)it.next()).getIcon(null, expanded, eg.getFormat(), 16);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Error occurred evaluating external graphic", e);
                    }
                }
                if (icon == null) continue;
                break;
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.FINE, "Failed to check graphics for attribute embedded in the path " + eg, e);
            }
        }
        return false;
    }

    public void visit(Stroke stroke) {
        super.visit(stroke);
        if (!(stroke.getWidth() instanceof Literal)) {
            this.dynamic = true;
        }
    }
}

