/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.geoserver.wms.featureinfo.ColorMapLabelMatcher;
import org.geoserver.wms.map.RasterSymbolizerVisitor;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.RasterSymbolizer;

class ColorMapLabelMatcherExtractor
extends RasterSymbolizerVisitor {
    static final String LABEL_IN_FEATURE_INFO = "labelInFeatureInfo";
    static final String LABEL_ATTRIBUTE_NAME = "labelAttributeName";
    List<ColorMapLabelMatcher> colorMapLabelMatcherList = new ArrayList<ColorMapLabelMatcher>();

    ColorMapLabelMatcherExtractor(double scaleDenominator) {
        super(scaleDenominator, null);
    }

    @Override
    public void visit(RasterSymbolizer raster) {
        super.visit(raster);
        ColorMap cm = raster.getColorMap();
        Map vendorOptions = raster.getOptions();
        String labelIncluded = (String)vendorOptions.get(LABEL_IN_FEATURE_INFO);
        String targetAttributeName = (String)vendorOptions.get(LABEL_ATTRIBUTE_NAME);
        if (targetAttributeName == null) {
            targetAttributeName = "Label";
        }
        if (labelIncluded != null && !labelIncluded.toUpperCase().equals(ColorMapLabelMatcher.LabelInFeatureInfoMode.NONE.name())) {
            Integer channelName = this.extractChannelSelectionName(raster.getChannelSelection());
            ColorMapLabelMatcher colorMapLabelMatcher = new ColorMapLabelMatcher(targetAttributeName, cm, labelIncluded, channelName);
            this.colorMapLabelMatcherList.add(colorMapLabelMatcher);
        }
    }

    public List<ColorMapLabelMatcher> getColorMapLabelMatcherList() {
        return this.colorMapLabelMatcherList;
    }

    private Integer extractChannelSelectionName(ChannelSelection channelSelection) {
        Integer channelName = null;
        if (channelSelection != null && channelSelection.getGrayChannel() != null) {
            channelName = (Integer)channelSelection.getGrayChannel().getChannelName().evaluate(null, Integer.class);
        }
        return channelName;
    }
}

