/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.dimension.impl;

import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.wms.dimension.AbstractDefaultValueSelectionStrategy;
import org.geotools.util.Converters;
import org.geotools.util.Range;

public class FixedValueStrategyImpl
extends AbstractDefaultValueSelectionStrategy {
    private Object value;
    private String fixedCapabilitiesValue;

    public FixedValueStrategyImpl(Object value) {
        this.value = value;
    }

    public FixedValueStrategyImpl(Object value, String fixedCapabilitiesValue) {
        this.value = value;
        this.fixedCapabilitiesValue = fixedCapabilitiesValue;
    }

    @Override
    public Object getDefaultValue(ResourceInfo resource, String dimensionName, DimensionInfo dimension, Class<?> clz) {
        if (this.value instanceof Range) {
            Range r = (Range)this.value;
            if (clz.isAssignableFrom(r.getElementClass())) {
                return r;
            }
            Comparable min = (Comparable)Converters.convert((Object)r.getMinValue(), clz);
            Comparable max = (Comparable)Converters.convert((Object)r.getMaxValue(), clz);
            return new Range(clz, min, max);
        }
        return Converters.convert((Object)this.value, clz);
    }

    @Override
    public String getCapabilitiesRepresentation(ResourceInfo resource, String dimensionName, DimensionInfo dimensionInfo) {
        if (this.fixedCapabilitiesValue != null) {
            return this.fixedCapabilitiesValue;
        }
        return super.getCapabilitiesRepresentation(resource, dimensionName, dimensionInfo);
    }
}

