/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.describelayer;

import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wms.DescribeLayerRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class DescribeLayerTransformer
extends TransformerBase {
    private String baseURL;

    public DescribeLayerTransformer(String baseURL) {
        if (baseURL == null) {
            throw new NullPointerException("serverBaseUrl");
        }
        this.baseURL = baseURL;
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new DescribeLayerTranslator(handler);
    }

    public Transformer createTransformer() throws TransformerException {
        Transformer transformer = super.createTransformer();
        String dtdUrl = ResponseUtils.buildSchemaURL((String)this.baseURL, (String)"wms/1.1.1/WMS_DescribeLayerResponse.dtd");
        transformer.setOutputProperty("doctype-system", dtdUrl);
        return transformer;
    }

    private class DescribeLayerTranslator
    extends TransformerBase.TranslatorSupport {
        public DescribeLayerTranslator(ContentHandler handler) {
            super(handler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof DescribeLayerRequest)) {
                throw new IllegalArgumentException();
            }
            DescribeLayerRequest req = (DescribeLayerRequest)o;
            AttributesImpl versionAtt = new AttributesImpl();
            String requestVersion = req.getVersion();
            if (requestVersion == null) {
                throw new NullPointerException("requestVersion");
            }
            versionAtt.addAttribute("", "version", "version", "", requestVersion);
            this.start("WMS_DescribeLayerResponse", versionAtt);
            this.handleLayers(req);
            this.end("WMS_DescribeLayerResponse");
        }

        private void handleLayers(DescribeLayerRequest req) {
            List<MapLayerInfo> layers = req.getLayers();
            AttributesImpl queryAtts = new AttributesImpl();
            queryAtts.addAttribute("", "typeName", "typeName", "", "");
            for (MapLayerInfo layer : layers) {
                String owsType;
                String owsUrl;
                AttributesImpl layerAtts = new AttributesImpl();
                layerAtts.addAttribute("", "name", "name", "", "");
                String workspaceName = "";
                if (MapLayerInfo.TYPE_VECTOR == layer.getType()) {
                    if (layer.getResource() instanceof FeatureTypeInfo) {
                        FeatureTypeInfo typeInfo = (FeatureTypeInfo)layer.getResource();
                        workspaceName = typeInfo.getStore().getWorkspace().getName();
                    }
                    owsUrl = ResponseUtils.buildURL((String)DescribeLayerTransformer.this.baseURL, (String)"wfs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                    owsUrl = ResponseUtils.appendQueryString((String)owsUrl, (String)"");
                    owsType = "WFS";
                    layerAtts.addAttribute("", "wfs", "wfs", "", owsUrl);
                } else if (MapLayerInfo.TYPE_RASTER == layer.getType()) {
                    owsUrl = ResponseUtils.buildURL((String)DescribeLayerTransformer.this.baseURL, (String)"wcs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                    owsUrl = ResponseUtils.appendQueryString((String)owsUrl, (String)"");
                    owsType = "WCS";
                } else {
                    owsType = null;
                    owsUrl = null;
                }
                if (owsType != null && owsUrl != null) {
                    layerAtts.addAttribute("", "owsURL", "owsURL", "", owsUrl);
                    layerAtts.addAttribute("", "owsType", "owsType", "", owsType);
                }
                layerAtts.setAttribute(0, "", "name", "name", "", layer.getLayerInfo().prefixedName());
                this.start("LayerDescription", layerAtts);
                String qAttsLyrName = layer.getName();
                if (workspaceName.length() > 0 && !layer.getName().startsWith(workspaceName + ":")) {
                    qAttsLyrName = workspaceName + ":" + layer.getName();
                }
                queryAtts.setAttribute(0, "", "typeName", "typeName", "", qAttsLyrName);
                this.element("Query", null, queryAtts);
                this.end("LayerDescription");
            }
        }
    }
}

