/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.describelayer;

import java.io.IOException;
import java.io.OutputStream;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DescribeLayerRequest;
import org.geoserver.wms.describelayer.DescribeLayerModel;
import org.springframework.util.Assert;

public abstract class DescribeLayerResponse
extends Response {
    private final String type;

    public DescribeLayerResponse(String format) {
        super(DescribeLayerModel.class, format);
        this.type = format;
    }

    public boolean canProduce(String format) {
        return this.type.equalsIgnoreCase(format);
    }

    public String getContentType() {
        return this.type;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        Object op = operation.getParameters()[0];
        if (op instanceof DescribeLayerRequest) {
            DescribeLayerRequest dlr = (DescribeLayerRequest)op;
            return dlr.getOutputFormat();
        }
        throw new ServiceException("Unable to parse incoming operation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        Assert.notNull((Object)operation.getParameters(), (String)"parameters");
        Assert.isTrue((boolean)(operation.getParameters()[0] instanceof DescribeLayerRequest), (String)"The first parameter must be a DescribeLayerRequest");
        DescribeLayerRequest request = (DescribeLayerRequest)operation.getParameters()[0];
        Assert.isTrue((boolean)(value instanceof DescribeLayerModel), (String)"Value should be a DescribeLayerModel");
        DescribeLayerModel results = (DescribeLayerModel)value;
        try {
            this.write(results, request, output);
        }
        finally {
            if (output != null) {
                try {
                    output.flush();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public abstract void write(DescribeLayerModel var1, DescribeLayerRequest var2, OutputStream var3) throws IOException, ServiceException;
}

